/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildProcessManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BuildBehaviourTab
extends AbstractCBuildPropertyTab {
    private static final int TRI_STATES_SIZE = 4;
    private Button b_stopOnError;
    private Button b_parallel;
    private Button b_parallelOpt;
    private Button b_parallelNum;
    private Spinner parallelProcesses;
    private Label title2;
    private Button b_autoBuild;
    private Text t_autoBuild;
    private Button b_cmdBuild;
    private Text t_cmdBuild;
    private Button b_cmdClean;
    private Text t_cmdClean;
    private IBuilder bldr;
    private IConfiguration icfg;
    private boolean canModify = true;
    protected final int cpuNumber = BuildProcessManager.checkCPUNumber();

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Group g3 = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_9, 2, 768);
        GridLayout gl = new GridLayout(2, true);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        g3.setLayout((Layout)gl);
        Composite c1 = new Composite((Composite)g3, 0);
        this.setupControl((Control)c1, 1, 1808);
        GridData gd = (GridData)c1.getLayoutData();
        gd.verticalSpan = 2;
        gd.verticalIndent = 0;
        c1.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c1.setLayout((Layout)gl);
        this.b_stopOnError = this.setupCheck(c1, Messages.BuilderSettingsTab_10, 1, 1);
        Composite c2 = new Composite((Composite)g3, 0);
        this.setupControl((Control)c2, 1, 1808);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c2.setLayout((Layout)gl);
        this.b_parallel = this.setupCheck(c2, Messages.BuilderSettingsTab_11, 1, 1);
        Composite c3 = new Composite((Composite)g3, 0);
        this.setupControl((Control)c3, 1, 1808);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c3.setLayout((Layout)gl);
        this.b_parallelOpt = new Button(c3, 16);
        this.b_parallelOpt.setText(Messages.BuilderSettingsTab_12);
        this.setupControl((Control)this.b_parallelOpt, 2, 1);
        ((GridData)this.b_parallelOpt.getLayoutData()).horizontalIndent = 15;
        this.b_parallelOpt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuildBehaviourTab.this.setParallelDef(BuildBehaviourTab.this.b_parallelOpt.getSelection());
                BuildBehaviourTab.this.updateButtons();
            }
        });
        this.b_parallelNum = new Button(c3, 16);
        this.b_parallelNum.setText(Messages.BuilderSettingsTab_13);
        this.setupControl((Control)this.b_parallelNum, 1, 1);
        ((GridData)this.b_parallelNum.getLayoutData()).horizontalIndent = 15;
        this.b_parallelNum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuildBehaviourTab.this.setParallelDef(!BuildBehaviourTab.this.b_parallelNum.getSelection());
                BuildBehaviourTab.this.updateButtons();
            }
        });
        this.parallelProcesses = new Spinner(c3, 2048);
        this.setupControl((Control)this.parallelProcesses, 1, 1);
        this.parallelProcesses.setValues(this.cpuNumber, 1, 10000, 0, 1, 10);
        this.parallelProcesses.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildBehaviourTab.this.setParallelNumber(BuildBehaviourTab.this.parallelProcesses.getSelection());
                BuildBehaviourTab.this.updateButtons();
            }
        });
        AccessibleAdapter makeTargetLabelAccessibleListener = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.BuilderSettingsTab_16;
            }
        };
        Group g4 = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_14, 3, 768);
        this.setupLabel((Composite)g4, Messages.BuilderSettingsTab_15, 1, 1);
        this.title2 = this.setupLabel((Composite)g4, Messages.BuilderSettingsTab_16, 2, 1);
        this.b_autoBuild = this.setupCheck((Composite)g4, Messages.BuilderSettingsTab_17, 1, 1);
        this.t_autoBuild = this.setupBlock((Composite)g4, (Control)this.b_autoBuild);
        this.t_autoBuild.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildBehaviourTab.this.canModify) {
                    BuildBehaviourTab.this.setBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", BuildBehaviourTab.this.t_autoBuild.getText());
                }
            }
        });
        this.t_autoBuild.getAccessible().addAccessibleListener((AccessibleListener)makeTargetLabelAccessibleListener);
        this.setupLabel((Composite)g4, Messages.BuilderSettingsTab_18, 3, 1);
        this.b_cmdBuild = this.setupCheck((Composite)g4, Messages.BuilderSettingsTab_19, 1, 1);
        this.t_cmdBuild = this.setupBlock((Composite)g4, (Control)this.b_cmdBuild);
        this.t_cmdBuild.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildBehaviourTab.this.canModify) {
                    BuildBehaviourTab.this.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", BuildBehaviourTab.this.t_cmdBuild.getText());
                }
            }
        });
        this.t_cmdBuild.getAccessible().addAccessibleListener((AccessibleListener)makeTargetLabelAccessibleListener);
        this.b_cmdClean = this.setupCheck((Composite)g4, Messages.BuilderSettingsTab_20, 1, 1);
        this.t_cmdClean = this.setupBlock((Composite)g4, (Control)this.b_cmdClean);
        this.t_cmdClean.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildBehaviourTab.this.canModify) {
                    BuildBehaviourTab.this.setBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", BuildBehaviourTab.this.t_cmdClean.getText());
                }
            }
        });
        this.t_cmdClean.getAccessible().addAccessibleListener((AccessibleListener)makeTargetLabelAccessibleListener);
    }

    static int[] calc3states(ICPropertyProvider p, IConfiguration c, int mode) {
        if (p.isMultiCfg() && c instanceof ICMultiItemsHolder) {
            boolean p0 = mode == 0;
            boolean p1 = mode == 1;
            IConfiguration[] cfs = (IConfiguration[])((ICMultiItemsHolder)c).getItems();
            IBuilder b = cfs[0].getBuilder();
            int[] res = new int[4];
            boolean[] x = new boolean[4];
            boolean bl = p0 ? b.isManagedBuildOn() : (x[0] = p1 ? b.isStopOnError() : b.isAutoBuildEnable());
            boolean bl2 = p0 ? b.isDefaultBuildCmd() : (x[1] = p1 ? b.supportsStopOnError(true) : b.isIncrementalBuildEnabled());
            boolean bl3 = p0 ? b.canKeepEnvironmentVariablesInBuildfile() : (x[2] = p1 ? b.supportsStopOnError(false) : b.isCleanBuildEnabled());
            x[3] = p0 ? b.keepEnvironmentVariablesInBuildfile() : (p1 ? ((Configuration)cfs[0]).getInternalBuilderParallel() : BuildBehaviourTab.getParallelDef(c));
            int i = 1;
            while (i < cfs.length) {
                b = cfs[i].getBuilder();
                if (x[0] != (p0 ? b.isManagedBuildOn() : (p1 ? b.isStopOnError() : b.isAutoBuildEnable()))) {
                    res[0] = 2;
                }
                if (x[1] != (p0 ? b.isDefaultBuildCmd() : (p1 ? b.supportsStopOnError(true) : b.isIncrementalBuildEnabled()))) {
                    res[1] = 2;
                }
                if (x[2] != (p0 ? b.canKeepEnvironmentVariablesInBuildfile() : (p1 ? b.supportsStopOnError(false) : b.isCleanBuildEnabled()))) {
                    res[2] = 2;
                }
                if (x[3] != (p0 ? b.keepEnvironmentVariablesInBuildfile() : (p1 ? ((Configuration)cfs[i]).getInternalBuilderParallel() : BuildBehaviourTab.getParallelDef(c)))) {
                    res[3] = 2;
                }
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (res[i] != 2) {
                    res[i] = x[i] ? 1 : 0;
                }
                ++i;
            }
            return res;
        }
        return null;
    }

    protected void updateButtons() {
        this.bldr = this.icfg.getEditableBuilder();
        this.canModify = false;
        int[] extStates = BuildBehaviourTab.calc3states(this.page, this.icfg, 1);
        if (extStates != null) {
            BuildBehaviourTab.setTriSelection((Button)this.b_stopOnError, (int)extStates[0]);
            this.b_stopOnError.setEnabled(extStates[1] == 1 && extStates[2] == 1);
        } else {
            BuildBehaviourTab.setTriSelection((Button)this.b_stopOnError, (boolean)this.bldr.isStopOnError());
            this.b_stopOnError.setEnabled(this.bldr.supportsStopOnError(true) && this.bldr.supportsStopOnError(false));
        }
        if (extStates == null) {
            BuildBehaviourTab.setTriSelection((Button)this.b_parallel, (boolean)this.getInternalBuilderParallel());
        } else {
            BuildBehaviourTab.setTriSelection((Button)this.b_parallel, (int)extStates[3]);
        }
        int n = this.getParallelNumber();
        if (n < 0) {
            n = -n;
        }
        this.parallelProcesses.setSelection(n);
        this.b_parallel.setVisible(this.bldr.supportsParallelBuild());
        this.b_parallelOpt.setVisible(this.bldr.supportsParallelBuild());
        this.b_parallelNum.setVisible(this.bldr.supportsParallelBuild());
        this.parallelProcesses.setVisible(this.bldr.supportsParallelBuild());
        extStates = BuildBehaviourTab.calc3states(this.page, this.icfg, 2);
        if (extStates == null) {
            BuildBehaviourTab.setTriSelection((Button)this.b_autoBuild, (boolean)this.bldr.isAutoBuildEnable());
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdBuild, (boolean)this.bldr.isIncrementalBuildEnabled());
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdClean, (boolean)this.bldr.isCleanBuildEnabled());
            this.b_parallelOpt.setSelection(BuildBehaviourTab.getParallelDef(this.icfg));
            this.b_parallelNum.setSelection(!BuildBehaviourTab.getParallelDef(this.icfg));
        } else {
            BuildBehaviourTab.setTriSelection((Button)this.b_autoBuild, (int)extStates[0]);
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdBuild, (int)extStates[1]);
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdClean, (int)extStates[2]);
            if (extStates[3] == 2) {
                this.b_parallelOpt.setSelection(false);
                this.b_parallelNum.setSelection(false);
            } else {
                this.b_parallelOpt.setSelection(BuildBehaviourTab.getParallelDef(this.icfg));
                this.b_parallelNum.setSelection(!BuildBehaviourTab.getParallelDef(this.icfg));
            }
        }
        if (this.page.isMultiCfg()) {
            MultiConfiguration mc = (MultiConfiguration)this.icfg;
            this.t_autoBuild.setText(mc.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            this.t_cmdBuild.setText(mc.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            this.t_cmdClean.setText(mc.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
        } else {
            this.t_autoBuild.setText(this.bldr.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            this.t_cmdBuild.setText(this.bldr.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            this.t_cmdClean.setText(this.bldr.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
        }
        boolean external = !this.isInternalBuilderEnabled();
        boolean parallel = this.b_parallel.getSelection();
        this.b_parallelNum.setEnabled(parallel);
        this.b_parallelOpt.setEnabled(parallel);
        this.parallelProcesses.setEnabled(parallel & this.b_parallelNum.getSelection());
        this.title2.setVisible(external);
        this.t_autoBuild.setVisible(external);
        ((Control)this.t_autoBuild.getData()).setVisible(external);
        this.t_cmdBuild.setVisible(external);
        ((Control)this.t_cmdBuild.getData()).setVisible(external);
        this.t_cmdClean.setVisible(external);
        ((Control)this.t_cmdClean.getData()).setVisible(external);
        if (external) {
            this.checkPressed((Control)this.b_autoBuild, false);
            this.checkPressed((Control)this.b_cmdBuild, false);
            this.checkPressed((Control)this.b_cmdClean, false);
        }
        this.canModify = true;
    }

    private Text setupBlock(Composite c, Control check) {
        Text t = this.setupText(c, 1, 768);
        Button b = this.setupButton(c, VARIABLESBUTTON_NAME, 1, 3);
        b.setData((Object)t);
        t.setData((Object)b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuildBehaviourTab.this.buttonVarPressed(event);
            }
        });
        if (check != null) {
            check.setData((Object)t);
        }
        return t;
    }

    private void buttonVarPressed(SelectionEvent e) {
        String x;
        Widget b = e.widget;
        if (b == null || b.getData() == null) {
            return;
        }
        if (b.getData() instanceof Text && (x = AbstractCPropertyTab.getVariableDialog((Shell)this.usercomp.getShell(), (ICConfigurationDescription)this.getResDesc().getConfiguration())) != null) {
            ((Text)b.getData()).insert(x);
        }
    }

    public void checkPressed(SelectionEvent e) {
        this.checkPressed((Control)e.widget, true);
        this.updateButtons();
    }

    private void checkPressed(Control b, boolean needsUpdate) {
        if (b == null) {
            return;
        }
        boolean val = false;
        if (b instanceof Button) {
            val = ((Button)b).getSelection();
        }
        if (b.getData() instanceof Text) {
            Text t = (Text)b.getData();
            t.setEnabled(val);
            if (t.getData() != null && t.getData() instanceof Control) {
                Control c = (Control)t.getData();
                c.setEnabled(val);
            }
        }
        if (needsUpdate) {
            this.setValue(b, val);
        }
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.icfg = BuildBehaviourTab.getCfg(cfgd.getConfiguration());
        this.updateButtons();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        BuildBehaviourTab.apply(src, dst, this.page.isMultiCfg());
    }

    static void apply(ICResourceDescription src, ICResourceDescription dst, boolean multi) {
        if (multi) {
            ICMultiConfigDescription mc1 = (ICMultiConfigDescription)src.getConfiguration();
            ICMultiConfigDescription mc2 = (ICMultiConfigDescription)dst.getConfiguration();
            ICConfigurationDescription[] cds1 = (ICConfigurationDescription[])mc1.getItems();
            ICConfigurationDescription[] cds2 = (ICConfigurationDescription[])mc2.getItems();
            int i = 0;
            while (i < cds1.length) {
                BuildBehaviourTab.applyToCfg(cds1[i], cds2[i]);
                ++i;
            }
        } else {
            BuildBehaviourTab.applyToCfg(src.getConfiguration(), dst.getConfiguration());
        }
    }

    private static void applyToCfg(ICConfigurationDescription c1, ICConfigurationDescription c2) {
        Configuration cfg01 = (Configuration)BuildBehaviourTab.getCfg(c1);
        Configuration cfg02 = (Configuration)BuildBehaviourTab.getCfg(c2);
        cfg02.enableInternalBuilder(cfg01.isInternalBuilderEnabled());
        BuildBehaviourTab.copyBuilders(cfg01.getBuilder(), cfg02.getEditableBuilder());
    }

    static void copyBuilders(IBuilder b1, IBuilder b2) {
        try {
            b2.setUseDefaultBuildCmd(b1.isDefaultBuildCmd());
            if (!b1.isDefaultBuildCmd()) {
                b2.setCommand(b1.getCommand());
                b2.setArguments(b1.getArguments());
            } else {
                b2.setCommand(null);
                b2.setArguments(null);
            }
            b2.setStopOnError(b1.isStopOnError());
            b2.setParallelBuildOn(b1.isParallelBuildOn());
            b2.setParallelizationNum(b1.getParallelizationNum());
            if (b2.canKeepEnvironmentVariablesInBuildfile()) {
                b2.setKeepEnvironmentVariablesInBuildfile(b1.keepEnvironmentVariablesInBuildfile());
            }
            ((Builder)b2).setBuildPath(((Builder)b1).getBuildPathAttribute());
            b2.setAutoBuildEnable(b1.isAutoBuildEnable());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            b2.setCleanBuildEnable(b1.isCleanBuildEnabled());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
            b2.setIncrementalBuildEnable(b1.isIncrementalBuildEnabled());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            b2.setManagedBuildOn(b1.isManagedBuildOn());
        }
        catch (CoreException ex) {
            ManagedBuilderUIPlugin.log(ex);
        }
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    protected void performDefaults() {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                BuildBehaviourTab.copyBuilders(b.getSuperClass(), b);
                ++i;
            }
        } else {
            BuildBehaviourTab.copyBuilders(this.bldr.getSuperClass(), this.bldr);
        }
        this.updateData(this.getResDesc());
    }

    private static boolean getParallelDef(IConfiguration cfg) {
        if (cfg instanceof Configuration) {
            return ((Configuration)cfg).getParallelDef();
        }
        if (cfg instanceof IMultiConfiguration) {
            return ((IMultiConfiguration)cfg).getParallelDef();
        }
        return false;
    }

    private void setParallelDef(boolean def) {
        if (this.icfg instanceof Configuration) {
            ((Configuration)this.icfg).setParallelDef(def);
        }
        if (this.icfg instanceof IMultiConfiguration) {
            ((IMultiConfiguration)this.icfg).setParallelDef(def);
        }
    }

    private int getParallelNumber() {
        if (this.icfg instanceof Configuration) {
            return ((Configuration)this.icfg).getParallelNumber();
        }
        if (this.icfg instanceof IMultiConfiguration) {
            return ((IMultiConfiguration)this.icfg).getParallelNumber();
        }
        return 0;
    }

    private void setParallelNumber(int num) {
        if (this.icfg instanceof Configuration) {
            ((Configuration)this.icfg).setParallelNumber(num);
        }
        if (this.icfg instanceof IMultiConfiguration) {
            ((IMultiConfiguration)this.icfg).setParallelNumber(num);
        }
    }

    private boolean getInternalBuilderParallel() {
        if (this.icfg instanceof Configuration) {
            return ((Configuration)this.icfg).getInternalBuilderParallel();
        }
        if (this.icfg instanceof IMultiConfiguration) {
            return ((IMultiConfiguration)this.icfg).getInternalBuilderParallel();
        }
        return false;
    }

    private boolean isInternalBuilderEnabled() {
        if (this.icfg instanceof Configuration) {
            return ((Configuration)this.icfg).isInternalBuilderEnabled();
        }
        if (this.icfg instanceof IMultiConfiguration) {
            return ((IMultiConfiguration)this.icfg).isInternalBuilderEnabled();
        }
        return false;
    }

    private void setBuildAttribute(String name, String value) {
        try {
            if (this.icfg instanceof IMultiConfiguration) {
                IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
                int i = 0;
                while (i < cfs.length) {
                    IBuilder b = cfs[i].getEditableBuilder();
                    b.setBuildAttribute(name, value);
                    ++i;
                }
            } else {
                this.icfg.getEditableBuilder().setBuildAttribute(name, value);
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    private void setValue(Control b, boolean val) {
        try {
            if (this.icfg instanceof IMultiConfiguration) {
                IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
                int i = 0;
                while (i < cfs.length) {
                    IBuilder bld = cfs[i].getEditableBuilder();
                    if (b == this.b_autoBuild) {
                        bld.setAutoBuildEnable(val);
                    } else if (b == this.b_cmdBuild) {
                        bld.setIncrementalBuildEnable(val);
                    } else if (b == this.b_cmdClean) {
                        bld.setCleanBuildEnable(val);
                    } else if (b == this.b_stopOnError) {
                        bld.setStopOnError(val);
                    } else if (b == this.b_parallel) {
                        bld.setParallelBuildOn(val);
                    }
                    ++i;
                }
            } else if (b == this.b_autoBuild) {
                this.bldr.setAutoBuildEnable(val);
            } else if (b == this.b_cmdBuild) {
                this.bldr.setIncrementalBuildEnable(val);
            } else if (b == this.b_cmdClean) {
                this.bldr.setCleanBuildEnable(val);
            } else if (b == this.b_stopOnError) {
                this.bldr.setStopOnError(val);
            } else if (b == this.b_parallel) {
                this.bldr.setParallelBuildOn(val);
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }
}

