/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="#getProvider()#getExecutor()")
public class DefaultVMModelProxyStrategy
implements IVMModelProxy {
    private final AbstractVMProvider fProvider;
    private final Object fRootElement;
    private IPresentationContext fContext;
    private Viewer fViewer;
    private boolean fDisposed = false;
    private ListenerList fListeners = new ListenerList();
    private IDoubleClickListener fDoubleClickListener;
    private boolean fAllowRecursiveVMNodes = false;

    public DefaultVMModelProxyStrategy(AbstractVMProvider provider, Object rootElement) {
        this.fProvider = provider;
        this.fRootElement = rootElement;
    }

    @Override
    public boolean isDeltaEvent(Object event) {
        return this.getEventDeltaFlags(event) != 0;
    }

    @Override
    public int getEventDeltaFlags(Object event) {
        IRootVMNode rootNode = this.getVMProvider().getRootVMNode();
        if (rootNode != null && rootNode.isDeltaEvent(this.getRootElement(), event)) {
            return this.getDeltaFlags(rootNode, null, event);
        }
        return 0;
    }

    protected AbstractVMProvider getVMProvider() {
        return this.fProvider;
    }

    private Object[] getListeners() {
        return this.fListeners.getListeners();
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public Object getRootElement() {
        return this.fRootElement;
    }

    @Override
    public Object getViewerInput() {
        return this.fRootElement;
    }

    @Override
    public TreePath getRootPath() {
        return TreePath.EMPTY;
    }

    @Override
    public void fireModelChanged(IModelDelta delta) {
        final IModelDelta root = this.getRootDelta(delta);
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IModelChangedListener listener = (IModelChangedListener)listeners[i];
            ISafeRunnable safeRunnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log((Throwable)exception);
                }

                public void run() throws Exception {
                    listener.modelChanged(root, (IModelProxy)DefaultVMModelProxyStrategy.this);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
            ++i;
        }
    }

    protected IModelDelta getRootDelta(IModelDelta delta) {
        IModelDelta parent = delta.getParentDelta();
        while (parent != null) {
            delta = parent;
            parent = delta.getParentDelta();
        }
        return delta;
    }

    public void dispose() {
        this.fDisposed = true;
        if (this.fViewer instanceof StructuredViewer && this.fDoubleClickListener != null) {
            ((StructuredViewer)this.fViewer).removeDoubleClickListener(this.fDoubleClickListener);
            this.fDoubleClickListener = null;
        }
    }

    public void init(IPresentationContext context) {
        this.fDisposed = false;
        this.fContext = context;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public void installed(final Viewer viewer) {
        this.fViewer = viewer;
        this.getVMProvider().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                DefaultVMModelProxyStrategy.this.fProvider.handleEvent(new ModelProxyInstalledEvent(DefaultVMModelProxyStrategy.this, viewer, DefaultVMModelProxyStrategy.this.fRootElement));
            }
        });
        if (this.fViewer instanceof StructuredViewer && this.fDoubleClickListener == null) {
            this.fDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    DefaultVMModelProxyStrategy.this.handleDoubleClick(e);
                }
            };
            ((StructuredViewer)this.fViewer).addDoubleClickListener(this.fDoubleClickListener);
        }
    }

    protected void handleDoubleClick(final DoubleClickEvent e) {
        ISelection selection;
        final AbstractVMProvider vmProvider = this.getVMProvider();
        if (!vmProvider.isDisposed() && !(selection = e.getSelection()).isEmpty() && selection instanceof ITreeSelection) {
            final TreePath path = ((ITreeSelection)selection).getPaths()[0];
            final Object input = e.getViewer().getInput();
            vmProvider.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    Object rootElement = DefaultVMModelProxyStrategy.this.getRootElement();
                    boolean eventContainsRootElement = rootElement.equals(input);
                    int i = 0;
                    while (!eventContainsRootElement && i < path.getSegmentCount()) {
                        eventContainsRootElement = rootElement.equals(path.getSegment(i));
                        ++i;
                    }
                    if (eventContainsRootElement) {
                        vmProvider.handleEvent(e);
                    }
                }
            });
        }
    }

    @Override
    public Viewer getViewer() {
        return this.fViewer;
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    protected int getDeltaFlags(IVMNode node, ModelDelta parentDelta, Object event) {
        int flags = node.getDeltaFlags(event);
        IVMNode[] iVMNodeArray = this.getVMProvider().getChildVMNodes(node);
        int n = iVMNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMNode childNode = iVMNodeArray[n2];
            if (!childNode.equals(node)) {
                int childNodeDeltaFlags = this.getDeltaFlags(childNode, parentDelta, event);
                if ((childNodeDeltaFlags & 0x400) != 0) {
                    childNodeDeltaFlags &= 0xFFFFFBFF;
                    childNodeDeltaFlags |= 0x800;
                }
                flags |= childNodeDeltaFlags;
            }
            ++n2;
        }
        while (parentDelta != null) {
            if ((parentDelta.getFlags() & 0x400) != 0) {
                flags = flags & 0xFFFFFBFF & 0xFFFFF7FF;
                break;
            }
            parentDelta = (ModelDelta)parentDelta.getParentDelta();
        }
        return flags;
    }

    @Override
    public void createDelta(final Object event, final DataRequestMonitor<IModelDelta> rm) {
        final IRootVMNode rootNode = this.getVMProvider().getRootVMNode();
        rootNode.createRootDelta(this.getRootElement(), event, new DataRequestMonitor<VMDelta>(this.getVMProvider().getExecutor(), rm){

            protected void handleSuccess() {
                final IModelDelta viewRootDelta = DefaultVMModelProxyStrategy.this.getRootDelta((IModelDelta)this.getData());
                Map<IVMNode, Integer> childNodesWithDeltaFlags = DefaultVMModelProxyStrategy.this.getChildNodesWithDeltaFlags(rootNode, (ModelDelta)this.getData(), event);
                if (childNodesWithDeltaFlags.size() == 0) {
                    rm.setData((Object)viewRootDelta);
                    rm.done();
                    return;
                }
                DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(rootNode, childNodesWithDeltaFlags, (VMDelta)((Object)this.getData()), event, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        rm.setData((Object)DefaultVMModelProxyStrategy.this.pruneDelta((VMDelta)viewRootDelta));
                        rm.done();
                    }
                });
            }
        });
    }

    protected VMDelta pruneDelta(VMDelta delta) {
        delta.accept(new IModelDeltaVisitor(){

            public boolean visit(IModelDelta deltaNode, int depth) {
                if ((deltaNode.getFlags() & 0xC00) != 0) {
                    VMDelta parent = (VMDelta)deltaNode.getParentDelta();
                    while (parent != null) {
                        if ((parent.getFlags() & 0x400) != 0) {
                            ((VMDelta)deltaNode).setFlags(deltaNode.getFlags() & 0xFFFFF3FF);
                            break;
                        }
                        parent = parent.getParentDelta();
                    }
                }
                return true;
            }
        });
        return delta;
    }

    protected void buildChildDeltas(final IVMNode node, final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        node.getContextsForEvent(parentDelta, event, new DataRequestMonitor<IVMContext[]>(this.getVMProvider().getExecutor(), rm){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    if (!$assertionsDisabled && this.getData() == null) {
                        throw new AssertionError();
                    }
                    DefaultVMModelProxyStrategy.this.buildChildDeltasForEventContext((IVMContext[])this.getData(), node, event, parentDelta, nodeOffset, rm);
                } else if (this.getStatus().getCode() == 10003) {
                    DefaultVMModelProxyStrategy.this.buildChildDeltasForAllContexts(node, event, parentDelta, nodeOffset, rm);
                } else {
                    super.handleCompleted();
                }
            }
        });
    }

    protected void buildChildDeltasForEventContext(final IVMContext[] vmcs, final IVMNode node, final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        final Map<IVMNode, Integer> childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(node, parentDelta, event);
        if (childNodesWithDeltaFlags.size() == 0) {
            rm.done();
            return;
        }
        boolean calculateIndex = false;
        if (nodeOffset >= 0) {
            for (int childDelta : childNodesWithDeltaFlags.values()) {
                if ((childDelta & 0x300000) == 0) continue;
                calculateIndex = true;
                break;
            }
        }
        if (calculateIndex) {
            this.getVMProvider().updateNode(node, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getVMProvider().getExecutor(), rm){

                protected void handleSuccess() {
                    if (((List)this.getData()).isEmpty()) {
                        rm.done();
                        return;
                    }
                    CountingRequestMonitor countingRm = new CountingRequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), rm);
                    int count = 0;
                    IVMContext[] iVMContextArray = vmcs;
                    int n = vmcs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVMContext vmc = iVMContextArray[n2];
                        int i = 0;
                        while (i < ((List)this.getData()).size()) {
                            if (vmc.equals(((List)this.getData()).get(i))) break;
                            ++i;
                        }
                        if (i != ((List)this.getData()).size()) {
                            int elementIndex = nodeOffset + i;
                            VMDelta delta = parentDelta.getChildDelta(vmc);
                            if (delta == null || delta.getIndex() != elementIndex) {
                                delta = parentDelta.addNode((Object)vmc, elementIndex, 0);
                            }
                            DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, delta, event, (RequestMonitor)countingRm);
                            ++count;
                        }
                        ++n2;
                    }
                    countingRm.setDoneCount(count);
                }
            }));
        } else {
            CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getVMProvider().getExecutor(), rm);
            int count = 0;
            IVMContext[] iVMContextArray = vmcs;
            int n = vmcs.length;
            int n2 = 0;
            while (n2 < n) {
                IVMContext vmc = iVMContextArray[n2];
                VMDelta delta = parentDelta.getChildDelta(vmc);
                if (delta == null) {
                    delta = parentDelta.addNode(vmc, 0);
                }
                this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, delta, event, rm);
                ++count;
                ++n2;
            }
            countingRm.setDoneCount(count);
        }
    }

    protected void buildChildDeltasForAllContexts(final IVMNode node, final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        final Map<IVMNode, Integer> childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(node, parentDelta, event);
        if (childNodesWithDeltaFlags.size() == 0) {
            rm.done();
            return;
        }
        boolean mustGetElements = false;
        boolean _updateFlagsOnly = true;
        for (int childDelta : childNodesWithDeltaFlags.values()) {
            if ((childDelta & 0xFFFFF7FF) != 0) {
                mustGetElements = true;
            }
            if ((childDelta & 0xFFFFF3FF) == 0) continue;
            _updateFlagsOnly = false;
        }
        final boolean updateFlagsOnly = _updateFlagsOnly;
        if (!mustGetElements) {
            this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, parentDelta, event, new RequestMonitor(this.getVMProvider().getExecutor(), rm){

                protected void handleError() {
                    super.handleError();
                }
            });
        } else {
            this.getVMProvider().updateNode(node, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getVMProvider().getExecutor(), rm){

                /*
                 * Enabled aggressive block sorting
                 */
                protected void handleCompleted() {
                    if (DefaultVMModelProxyStrategy.this.fDisposed) {
                        return;
                    }
                    List childElements = (List)this.getData();
                    if (childElements == null || childElements.size() == 0) {
                        if (updateFlagsOnly) {
                            DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, parentDelta, event, rm);
                            return;
                        }
                        rm.done();
                        return;
                    }
                    CountingRequestMonitor countingRM = new CountingRequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), rm);
                    int rmCount = 0;
                    int i = 0;
                    while (i < childElements.size()) {
                        int elementIndex = nodeOffset >= 0 ? nodeOffset + i : -1;
                        VMDelta delta = parentDelta.getChildDelta(childElements.get(i));
                        if (delta == null) {
                            delta = parentDelta.addNode(childElements.get(i), elementIndex, 0);
                        }
                        DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, delta, event, (RequestMonitor)countingRM);
                        ++rmCount;
                        ++i;
                    }
                    countingRM.setDoneCount(rmCount);
                }
            }));
        }
    }

    protected void callChildNodesToBuildDelta(final IVMNode node, final Map<IVMNode, Integer> childNodes, final VMDelta delta, final Object event, final RequestMonitor rm) {
        assert (childNodes.size() != 0);
        boolean calculateOffsets = false;
        for (int childDelta : childNodes.values()) {
            if ((childDelta & 0x300012) == 0) continue;
            calculateOffsets = true;
            break;
        }
        this.getChildNodesElementOffsets(node, (IModelDelta)delta, calculateOffsets, new DataRequestMonitor<Map<IVMNode, Integer>>(this.getVMProvider().getExecutor(), rm){

            protected void handleSuccess() {
                final CountingRequestMonitor multiRm = new CountingRequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), rm);
                int multiRmCount = 0;
                delta.setChildCount((Integer)((Map)this.getData()).get(null));
                for (final IVMNode childNode : childNodes.keySet()) {
                    if (node.equals(childNode)) {
                        if (!DefaultVMModelProxyStrategy.this.allowRecursiveVMNodes() || !DefaultVMModelProxyStrategy.this.isDeltaElementOfType(delta, childNode)) continue;
                        childNode.buildDelta(event, delta, 0, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)multiRm){

                            protected void handleSuccess() {
                                DefaultVMModelProxyStrategy.this.buildChildDeltas(childNode, event, delta, 0, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)multiRm));
                            }
                        });
                        ++multiRmCount;
                        continue;
                    }
                    final int nodeOffset = (Integer)((Map)this.getData()).get(childNode);
                    childNode.buildDelta(event, delta, nodeOffset, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)multiRm){

                        protected void handleSuccess() {
                            DefaultVMModelProxyStrategy.this.buildChildDeltas(childNode, event, delta, nodeOffset, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)multiRm));
                        }
                    });
                    ++multiRmCount;
                }
                multiRm.setDoneCount(multiRmCount);
            }
        });
    }

    private void getChildNodesElementOffsets(IVMNode node, IModelDelta delta, boolean calculdateOffsets, DataRequestMonitor<Map<IVMNode, Integer>> rm) {
        final IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
        assert (childNodes.length != 0);
        if (calculdateOffsets) {
            final Integer[] counts = new Integer[childNodes.length];
            final CountingRequestMonitor crm = new CountingRequestMonitor(this.getVMProvider().getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                private final /* synthetic */ DataRequestMonitor val$rm;
                {
                    this.val$rm = dataRequestMonitor;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    HashMap<IVMNode, Integer> data = new HashMap<IVMNode, Integer>();
                    int offset = 0;
                    int i = 0;
                    while (i < childNodes.length) {
                        data.put(childNodes[i], offset);
                        offset += counts[i].intValue();
                        ++i;
                    }
                    data.put(null, offset);
                    this.val$rm.setData(data);
                    this.val$rm.done();
                }
            };
            int countRM = 0;
            int i = 0;
            while (i < childNodes.length) {
                final int nodeIndex = i;
                this.getVMProvider().updateNode(childNodes[i], new VMChildrenCountUpdate(delta, this.getVMProvider().getPresentationContext(), new DataRequestMonitor<Integer>(this.getVMProvider().getExecutor(), (RequestMonitor)crm){

                    protected void handleCompleted() {
                        counts[nodeIndex] = (Integer)this.getData();
                        crm.done();
                    }
                }));
                ++countRM;
                ++i;
            }
            crm.setDoneCount(countRM);
        } else {
            HashMap<IVMNode, Integer> data = new HashMap<IVMNode, Integer>();
            int i = 0;
            while (i < childNodes.length) {
                data.put(childNodes[i], -1);
                ++i;
            }
            data.put(null, -1);
            rm.setData(data);
            rm.done();
        }
    }

    protected Map<IVMNode, Integer> getChildNodesWithDeltaFlags(IVMNode node, ModelDelta parentDelta, Object e) {
        HashMap<IVMNode, Integer> nodes = new HashMap<IVMNode, Integer>();
        IVMNode[] iVMNodeArray = this.getVMProvider().getChildVMNodes(node);
        int n = iVMNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            int delta;
            IVMNode childNode = iVMNodeArray[n2];
            if ((!childNode.equals(node) || this.allowRecursiveVMNodes()) && (delta = this.getDeltaFlags(childNode, parentDelta, e)) != 0) {
                nodes.put(childNode, delta);
            }
            ++n2;
        }
        return nodes;
    }

    public boolean allowRecursiveVMNodes() {
        return this.fAllowRecursiveVMNodes;
    }

    public void setAllowRecursiveVMNodes(boolean allow) {
        this.fAllowRecursiveVMNodes = allow;
    }

    protected boolean isDeltaElementOfType(VMDelta delta, IVMNode node) {
        if (delta.getElement() instanceof IDMVMContext) {
            IDMVMContext dmvmContext = (IDMVMContext)delta.getElement();
            return dmvmContext.getVMNode().equals(node);
        }
        return false;
    }
}

