/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.properties;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelBackground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelFont;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelForeground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class LabelColumnInfo {
    private String[] fPropertyNames;
    private LabelAttribute[] fLabelAttributes;

    public LabelColumnInfo(LabelAttribute[] attributes) {
        this.fLabelAttributes = attributes;
        LinkedList<String> names = new LinkedList<String>();
        LabelAttribute[] labelAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            LabelAttribute attr = labelAttributeArray[n2];
            String[] stringArray = attr.getPropertyNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                names.add(name);
                ++n4;
            }
            ++n2;
        }
        this.fPropertyNames = names.toArray(new String[names.size()]);
    }

    public String[] getPropertyNames() {
        return this.fPropertyNames;
    }

    public LabelAttribute[] getLabelAttributes() {
        return this.fLabelAttributes;
    }

    protected void setLabelAttributes(LabelAttribute[] attributes) {
        this.fLabelAttributes = attributes;
        LinkedList<String> names = new LinkedList<String>();
        LabelAttribute[] labelAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            LabelAttribute attr = labelAttributeArray[n2];
            String[] stringArray = attr.getPropertyNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                names.add(name);
                ++n4;
            }
            ++n2;
        }
        this.fPropertyNames = names.toArray(new String[names.size()]);
    }

    public void insertAttribute(LabelAttribute attribute) {
        LabelAttribute[] newAttributeList = new LabelAttribute[this.fLabelAttributes.length + 1];
        int idx = 0;
        while (idx < this.fLabelAttributes.length) {
            newAttributeList[idx + 1] = this.fLabelAttributes[idx];
            ++idx;
        }
        newAttributeList[0] = attribute;
        this.setLabelAttributes(newAttributeList);
    }

    public void updateColumn(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
        LabelAttribute[] labelAttributes;
        boolean textSet = false;
        boolean imageSet = false;
        boolean fontSet = false;
        boolean foregroundSet = false;
        boolean backgroundSet = false;
        LabelAttribute[] labelAttributeArray = labelAttributes = this.getLabelAttributes();
        int n = labelAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            LabelAttribute info = labelAttributeArray[n2];
            if (!(info instanceof LabelText && textSet || info instanceof LabelImage && imageSet || info instanceof LabelFont && fontSet || info instanceof LabelForeground && foregroundSet || info instanceof LabelBackground && backgroundSet || !info.isEnabled(status, properties))) {
                info.updateAttribute(update, columnIndex, status, properties);
                textSet = textSet || info instanceof LabelText;
                imageSet = imageSet || info instanceof LabelImage;
                fontSet = fontSet || info instanceof LabelFont;
                foregroundSet = foregroundSet || info instanceof LabelForeground;
                backgroundSet = backgroundSet || info instanceof LabelBackground;
            }
            ++n2;
        }
    }
}

