/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ndk.internal.build;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.runtime.Platform;

public class NdkEnvSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static Map<String, IBuildEnvironmentVariable> mEnvVars;

    private synchronized void init() {
        if (mEnvVars != null) {
            return;
        }
        mEnvVars = new HashMap<String, IBuildEnvironmentVariable>();
        if (Platform.getOS().equals("win32")) {
            IBuildEnvironmentVariable path = new IBuildEnvironmentVariable(){

                public String getName() {
                    return "PATH";
                }

                public String getValue() {
                    File bin = new File("C:\\MinGW\\msys\\1.0\\bin");
                    if (bin.isDirectory()) {
                        return bin.getAbsolutePath();
                    }
                    bin = new File("C:\\cygwin\\bin");
                    if (bin.isDirectory()) {
                        return bin.getAbsolutePath();
                    }
                    return null;
                }

                public int getOperation() {
                    return 3;
                }

                public String getDelimiter() {
                    return ";";
                }
            };
            if (path.getValue() != null) {
                mEnvVars.put(path.getName(), path);
            }
            IBuildEnvironmentVariable cygwin = new IBuildEnvironmentVariable(){

                public String getName() {
                    return "CYGWIN";
                }

                public String getValue() {
                    return "nodosfilewarning";
                }

                public int getOperation() {
                    return 1;
                }

                public String getDelimiter() {
                    return null;
                }
            };
            mEnvVars.put(cygwin.getName(), cygwin);
        }
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        this.init();
        return mEnvVars.get(variableName);
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        this.init();
        return mEnvVars.values().toArray(new IBuildEnvironmentVariable[mEnvVars.size()]);
    }
}

