/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl_7_0
extends MIRunControl
implements IReverseRunControl {
    private IGDBBackend fGdb;
    private IMIProcesses fProcService;
    private CommandFactory fCommandFactory;
    private boolean fReverseSupported = true;
    private boolean fReverseStepping = false;
    private boolean fReverseModeEnabled = false;
    private boolean fRunControlOperationsEnabled = true;
    private RunToLineActiveOperation fRunToLineActiveOperation = null;

    public GDBRunControl_7_0(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            public void handleSuccess() {
                GDBRunControl_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fProcService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        if (this.fGdb.getSessionType() == SessionType.CORE) {
            this.fRunControlOperationsEnabled = false;
            this.fReverseSupported = false;
        }
        this.register(new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), IMIRunControl.class.getName(), MIRunControl.class.getName(), IReverseRunControl.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    @Override
    public IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, int threadId) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)container, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = null;
        if (procDmc != null) {
            threadDmc = this.fProcService.createThreadContext(procDmc, Integer.toString(threadId));
        }
        return this.fProcService.createExecutionContext(container, threadDmc, Integer.toString(threadId));
    }

    @Override
    public void suspend(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        this.canSuspend(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    GDBRunControl_7_0.this.fGdb.interruptAndWait(0, rm);
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context cannot be suspended.", null));
                    rm.done();
                }
            }
        });
    }

    @Override
    public void getExecutionContexts(IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        this.fProcService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (this.getData() instanceof IRunControl.IExecutionDMContext[]) {
                    IRunControl.IExecutionDMContext[] execDmcs = (IRunControl.IExecutionDMContext[])this.getData();
                    rm.setData((Object)execDmcs);
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid contexts", null));
                }
                rm.done();
            }
        });
    }

    @Override
    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (!this.fRunControlOperationsEnabled) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        super.canResume(context, rm);
    }

    @Override
    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (!this.fRunControlOperationsEnabled) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        super.canSuspend(context, rm);
    }

    @Override
    public void canStep(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, final DataRequestMonitor<Boolean> rm) {
        MIStack stackService;
        if (!this.fRunControlOperationsEnabled) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (stepType == IRunControl.StepType.STEP_RETURN && (stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class))) != null) {
            stackService.getStackDepth((IDMContext)context, 2, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess() && (Integer)this.getData() == 1) {
                        rm.setData((Object)false);
                        rm.done();
                    } else {
                        GDBRunControl_7_0.this.canResume(context, (DataRequestMonitor<Boolean>)rm);
                    }
                }
            });
            return;
        }
        this.canResume(context, rm);
    }

    @Override
    public void canReverseResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)(this.fReverseModeEnabled && this.doCanResume(context) ? 1 : 0));
        rm.done();
    }

    @Override
    public void canReverseStep(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, final DataRequestMonitor<Boolean> rm) {
        if (context instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (stepType == IRunControl.StepType.STEP_RETURN) {
            if (!this.fReverseModeEnabled || !this.doCanResume(context)) {
                rm.setData((Object)false);
                rm.done();
                return;
            }
            MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
            if (stackService != null) {
                stackService.getStackDepth((IDMContext)context, 2, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                    public void handleCompleted() {
                        if (this.isSuccess() && (Integer)this.getData() == 1) {
                            rm.setData((Object)false);
                            rm.done();
                        } else {
                            GDBRunControl_7_0.this.canReverseResume(context, (DataRequestMonitor<Boolean>)rm);
                        }
                    }
                });
                return;
            }
        }
        this.canReverseResume(context, rm);
    }

    @Override
    public boolean isReverseStepping(IRunControl.IExecutionDMContext context) {
        return !this.isTerminated() && this.fReverseStepping;
    }

    @Override
    public void reverseResume(final IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        if (this.fReverseModeEnabled && this.doCanResume(context)) {
            ICommand<MIInfo> cmd = null;
            if (context instanceof IRunControl.IContainerDMContext) {
                cmd = this.fCommandFactory.createMIExecReverseContinue(context);
            } else {
                IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = this.fCommandFactory.createMIExecReverseContinue(dmc);
            }
            this.setResumePending(true);
            this.getCache().setContextAvailable((IDMContext)context, false);
            this.getConnection().queueCommand(cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                public void handleFailure() {
                    GDBRunControl_7_0.this.setResumePending(false);
                    GDBRunControl_7_0.this.getCache().setContextAvailable((IDMContext)context, true);
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + ", is already running or reverse not enabled.", null));
            rm.done();
        }
    }

    @Override
    public void reverseStep(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (!this.fReverseModeEnabled || !this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        ICommand<MIInfo> cmd = null;
        switch (stepType) {
            case STEP_INTO: {
                cmd = this.fCommandFactory.createMIExecReverseStep(dmc, 1);
                break;
            }
            case STEP_OVER: {
                cmd = this.fCommandFactory.createMIExecReverseNext(dmc, 1);
                break;
            }
            case STEP_RETURN: {
                MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
                if (stackService != null) {
                    IStack.IFrameDMContext topFrameDmc = stackService.createFrameDMContext(dmc, 0);
                    cmd = this.fCommandFactory.createMIExecUncall(topFrameDmc);
                    break;
                }
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot create context for command, stack service not available.", null));
                rm.done();
                return;
            }
            case INSTRUCTION_STEP_INTO: {
                cmd = this.fCommandFactory.createMIExecReverseStepInstruction(dmc, 1);
                break;
            }
            case INSTRUCTION_STEP_OVER: {
                cmd = this.fCommandFactory.createMIExecReverseNextInstruction(dmc, 1);
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given step type not supported", null));
                rm.done();
                return;
            }
        }
        this.setResumePending(true);
        this.fReverseStepping = true;
        this.getCache().setContextAvailable((IDMContext)context, false);
        this.getConnection().queueCommand(cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleFailure() {
                GDBRunControl_7_0.this.setResumePending(false);
                GDBRunControl_7_0.this.fReverseStepping = false;
                GDBRunControl_7_0.this.getCache().setContextAvailable((IDMContext)context, true);
            }
        });
    }

    @Override
    public void canEnableReverseMode(ICommandControlService.ICommandControlDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.fReverseSupported);
        rm.done();
    }

    @Override
    public void isReverseModeEnabled(ICommandControlService.ICommandControlDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.fReverseModeEnabled);
        rm.done();
    }

    @Override
    public void enableReverseMode(ICommandControlService.ICommandControlDMContext context, final boolean enable, final RequestMonitor rm) {
        if (!this.fReverseSupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Reverse mode is not supported.", null));
            rm.done();
            return;
        }
        if (this.fReverseModeEnabled == enable) {
            rm.done();
            return;
        }
        this.getConnection().queueCommand(this.fCommandFactory.createCLIRecord(context, enable), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleSuccess() {
                GDBRunControl_7_0.this.setReverseModeEnabled(enable);
                rm.done();
            }
        });
    }

    @Override
    public void runToLocation(IRunControl.IExecutionDMContext context, final String location, final boolean skipBreakpoints, final RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(dmc)) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IBreakpoints.IBreakpointsTargetDMContext.class);
            this.getConnection().queueCommand(this.fCommandFactory.createMIBreakInsert(bpDmc, true, false, null, 0, location, dmc.getThreadId()), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), rm){

                public void handleSuccess() {
                    int bpId = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getNumber();
                    String addr = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getAddress();
                    GDBRunControl_7_0.this.fRunToLineActiveOperation = new RunToLineActiveOperation(dmc, bpId, location, addr, skipBreakpoints);
                    GDBRunControl_7_0.this.resume(dmc, new RequestMonitor((Executor)GDBRunControl_7_0.this.getExecutor(), rm){

                        public void handleFailure() {
                            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)GDBRunControl_7_0.this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                            int bpId = GDBRunControl_7_0.this.fRunToLineActiveOperation.getBreakointId();
                            GDBRunControl_7_0.this.getConnection().queueCommand(GDBRunControl_7_0.this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{bpId}), new DataRequestMonitor((Executor)GDBRunControl_7_0.this.getExecutor(), null));
                            GDBRunControl_7_0.this.fRunToLineActiveOperation = null;
                            super.handleFailure();
                        }
                    });
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    @Override
    public void resumeAtLocation(IRunControl.IExecutionDMContext context, String location, RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given context: " + context + " is not an thread execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(dmc)) {
            this.setResumePending(true);
            this.getCache().setContextAvailable((IDMContext)dmc, false);
            this.getConnection().queueCommand(this.fCommandFactory.createMIExecJump(dmc, location), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleFailure() {
                    GDBRunControl_7_0.this.setResumePending(false);
                    GDBRunControl_7_0.this.getCache().setContextAvailable((IDMContext)dmc, true);
                    super.handleFailure();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIInferiorExitEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            int bpId = this.fRunToLineActiveOperation.getBreakointId();
            this.getConnection().queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{bpId}), new DataRequestMonitor((Executor)this.getExecutor(), null));
            this.fRunToLineActiveOperation = null;
        }
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            int bpId = 0;
            if (e instanceof MIBreakpointHitEvent) {
                bpId = ((MIBreakpointHitEvent)e).getNumber();
            }
            String fileLocation = String.valueOf(e.getFrame().getFile()) + ":" + e.getFrame().getLine();
            String addrLocation = e.getFrame().getAddress();
            if (fileLocation.equals(this.fRunToLineActiveOperation.getFileLocation()) || addrLocation.equals(this.fRunToLineActiveOperation.getAddrLocation()) || bpId == this.fRunToLineActiveOperation.getBreakointId()) {
                this.fRunToLineActiveOperation = null;
            } else {
                if (this.fRunToLineActiveOperation.shouldSkipBreakpoints() && e instanceof MIBreakpointHitEvent) {
                    this.getConnection().queueCommand(this.fCommandFactory.createMIExecContinue(this.fRunToLineActiveOperation.getThreadContext()), new DataRequestMonitor((Executor)this.getExecutor(), null));
                    return;
                }
                IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                this.getConnection().queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{this.fRunToLineActiveOperation.getBreakointId()}), new DataRequestMonitor((Executor)this.getExecutor(), null));
                this.fRunToLineActiveOperation = null;
            }
        }
        super.eventDispatched(e);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.fRunControlOperationsEnabled = !e.isVisualizationModeEnabled();
    }

    public void setReverseModeEnabled(boolean enabled) {
        this.fReverseModeEnabled = enabled;
    }

    private static class RunToLineActiveOperation {
        private IMIExecutionDMContext fThreadContext;
        private int fBpId;
        private String fFileLocation;
        private String fAddrLocation;
        private boolean fSkipBreakpoints;

        public RunToLineActiveOperation(IMIExecutionDMContext threadContext, int bpId, String fileLoc, String addr, boolean skipBreakpoints) {
            this.fThreadContext = threadContext;
            this.fBpId = bpId;
            this.fFileLocation = fileLoc;
            this.fAddrLocation = addr;
            this.fSkipBreakpoints = skipBreakpoints;
        }

        public IMIExecutionDMContext getThreadContext() {
            return this.fThreadContext;
        }

        public int getBreakointId() {
            return this.fBpId;
        }

        public String getFileLocation() {
            return this.fFileLocation;
        }

        public String getAddrLocation() {
            return this.fAddrLocation;
        }

        public boolean shouldSkipBreakpoints() {
            return this.fSkipBreakpoints;
        }
    }
}

