/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service.macos;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MacOSGDBRunControl
extends GDBRunControl {
    private CommandFactory fCommandFactory;

    public MacOSGDBRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                MacOSGDBRunControl.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{IRunControl.class.getName(), IMIRunControl.class.getName(), MIRunControl.class.getName(), GDBRunControl.class.getName(), MacOSGDBRunControl.class.getName()}, new Hashtable());
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        super.shutdown(requestMonitor);
    }

    public void suspend(final IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        assert (context != null);
        this.canSuspend(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    ICommand<MIInfo> cmd = null;
                    if (context instanceof IRunControl.IContainerDMContext) {
                        cmd = MacOSGDBRunControl.this.fCommandFactory.createMIExecInterrupt(context);
                    } else {
                        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                        if (dmc == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + " is not an execution context.", null));
                            rm.done();
                            return;
                        }
                        cmd = MacOSGDBRunControl.this.fCommandFactory.createMIExecInterrupt(dmc);
                    }
                    MacOSGDBRunControl.this.getConnection().queueCommand(cmd, new DataRequestMonitor((Executor)MacOSGDBRunControl.this.getExecutor(), rm));
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context cannot be suspended.", null));
                    rm.done();
                }
            }
        });
    }
}

