/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.NamespacesGrouping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembersGrouping
extends CElementGrouping {
    private final Object fParent;
    private final String fNamespace;

    public MembersGrouping(Object parent, String namespace) {
        super(256);
        assert (parent instanceof ICElement || parent instanceof NamespacesGrouping);
        this.fParent = parent;
        this.fNamespace = namespace;
    }

    @Override
    public String getLabel(Object object) {
        return this.fNamespace;
    }

    public Object[] getChildren(Object object) {
        ArrayList<Object> nsMembers = new ArrayList<Object>();
        if (this.fParent instanceof IParent) {
            try {
                nsMembers.addAll(this.getNamespaceChildren(((IParent)this.fParent).getChildren()));
            }
            catch (CModelException cModelException) {}
        } else if (this.fParent instanceof NamespacesGrouping) {
            INamespace[] namespaces;
            NamespacesGrouping nsGrouping = (NamespacesGrouping)((Object)this.fParent);
            INamespace[] iNamespaceArray = namespaces = nsGrouping.getNamespaces();
            int n = namespaces.length;
            int n2 = 0;
            while (n2 < n) {
                INamespace iNamespace = iNamespaceArray[n2];
                try {
                    nsMembers.addAll(this.getNamespaceChildren(iNamespace.getChildren()));
                }
                catch (CModelException cModelException) {}
                ++n2;
            }
        }
        return nsMembers.toArray();
    }

    private Collection<? extends ICElement> getNamespaceChildren(ICElement[] icElements) {
        ArrayList<ICElement> members = new ArrayList<ICElement>(icElements.length);
        ICElement[] iCElementArray = icElements;
        int n = icElements.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace;
            String name;
            int idx;
            ICElement icElement = iCElementArray[n2];
            if (icElement instanceof IMember && (idx = (name = icElement.getElementName()).lastIndexOf("::")) >= 0 && this.fNamespace.equals(namespace = name.substring(0, idx))) {
                members.add(icElement);
            }
            ++n2;
        }
        return members;
    }

    public Object getParent(Object object) {
        return this.fParent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MembersGrouping) {
            MembersGrouping other = (MembersGrouping)((Object)obj);
            return this.fParent.equals(other.fParent) && this.fNamespace.equals(other.fNamespace);
        }
        return false;
    }

    public int hashCode() {
        return this.fParent.hashCode() * 17 + this.fNamespace.hashCode();
    }

    @Override
    public String toString() {
        return this.fNamespace;
    }
}

