/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ui.services.IDisposable;

public class RefactoringASTCache
implements IDisposable {
    private static final int PARSE_MODE = 230;
    private final Map<ITranslationUnit, IASTTranslationUnit> fASTCache = new ConcurrentHashMap<ITranslationUnit, IASTTranslationUnit>();
    private IIndex fIndex;
    private IASTTranslationUnit fSharedAST;
    private boolean fDisposed;

    public IASTTranslationUnit getAST(ITranslationUnit tu, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Assert.isTrue((!this.fDisposed ? 1 : 0) != 0, (String)"RefactoringASTCache is already disposed");
        this.getIndex();
        if (pm != null && pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        IASTTranslationUnit ast = this.fASTCache.get(tu = CModelUtil.toWorkingCopy(tu));
        if (ast == null) {
            if (this.fSharedAST != null && tu.equals(this.fSharedAST.getOriginatingTranslationUnit())) {
                ast = this.fSharedAST;
            } else {
                ast = ASTProvider.getASTProvider().acquireSharedAST(tu, this.fIndex, ASTProvider.WAIT_ACTIVE_ONLY, pm);
                if (ast == null) {
                    if (pm != null && pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ast = tu.getAST(this.fIndex, 230);
                    this.fASTCache.put(tu, ast);
                } else {
                    if (this.fSharedAST != null) {
                        ASTProvider.getASTProvider().releaseSharedAST(this.fSharedAST);
                    }
                    this.fSharedAST = ast;
                }
            }
        }
        if (pm != null) {
            pm.done();
        }
        return ast;
    }

    public IIndex getIndex() throws CoreException, OperationCanceledException {
        Assert.isTrue((!this.fDisposed ? 1 : 0) != 0, (String)"RefactoringASTCache is already disposed");
        if (this.fIndex == null) {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
            try {
                index.acquireReadLock();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
            this.fIndex = index;
        }
        return this.fIndex;
    }

    public void dispose() {
        Assert.isTrue((!this.fDisposed ? 1 : 0) != 0, (String)"RefactoringASTCache.dispose() called more than once");
        this.fDisposed = true;
        if (this.fSharedAST != null) {
            ASTProvider.getASTProvider().releaseSharedAST(this.fSharedAST);
        }
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.fDisposed) {
            CUIPlugin.logError("RefactoringASTCache was not disposed");
        }
        super.finalize();
    }
}

