/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionComposite;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierResult;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExtractFunctionInputPage
extends UserInputWizardPage {
    private final ExtractFunctionInformation info;
    private ExtractFunctionComposite comp;
    protected final String NO_NAME_ERROR_LABEL = Messages.ExtractFunctionInputPage_EnterName;

    public ExtractFunctionInputPage(String name, ExtractFunctionInformation info) {
        super(name);
        this.info = info;
    }

    public void createControl(Composite parent) {
        this.comp = new ExtractFunctionComposite(parent, this.info, this);
        this.setPageComplete(false);
        this.comp.getMethodNameText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractFunctionInputPage.this.info.setMethodName(ExtractFunctionInputPage.this.comp.getMethodName());
                ExtractFunctionInputPage.this.checkName();
            }
        });
        Control[] controlArray = this.comp.getVisibiltyGroup().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttons = controlArray[n2];
            buttons.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    String text = ((Button)e.getSource()).getText();
                    ExtractFunctionInputPage.this.visibilityChange(text);
                }
            });
            ++n2;
        }
        this.comp.getReplaceSimilarButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExtractFunctionInputPage.this.info.setReplaceDuplicates(ExtractFunctionInputPage.this.comp.getReplaceSimilarButton().isEnabled());
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.setControl((Control)this.comp);
    }

    protected void visibilityChange(String text) {
        this.info.setVisibility(VisibilityEnum.getEnumForStringRepresentation(text));
    }

    private void checkName() {
        String methodName = this.comp.getMethodName();
        IdentifierResult result = IdentifierHelper.checkIdentifierName(methodName);
        if (result.isCorrect()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(String.valueOf(Messages.ExtractFunctionInputPage_CheckFunctionName) + " " + result.getMessage());
            this.setPageComplete(false);
        }
    }

    public void errorWithAfterUsedVariable(String variableUsedAfterBlock) {
        if (variableUsedAfterBlock == null) {
            this.setErrorMessage(null);
            this.checkName();
        } else {
            this.setErrorMessage("The parameter '" + variableUsedAfterBlock + "' " + Messages.ExtractFunctionInputPage_1);
        }
    }
}

