/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import com.ibm.icu.text.Collator;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.AccessorFactory;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.FieldDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorDescriptor
implements Comparable<AccessorDescriptor> {
    private static final Collator collator = Collator.getInstance();
    private final AccessorKind kind;
    private final String accessorName;
    private final IASTName fieldName;
    private AccessorFactory accessorFactory;
    private IASTSimpleDeclaration accessorDeclaration;
    private IASTSimpleDeclaration existingAccessorDeclaration;
    private IASTFunctionDefinition existingAccessorDefinition;

    public AccessorDescriptor(AccessorKind kind, String accessorName, FieldDescriptor fieldDescriptor) {
        GetterSetterContext context = fieldDescriptor.getContext();
        this.kind = kind;
        this.accessorName = accessorName;
        this.fieldName = fieldDescriptor.getFieldName();
        if (accessorName != null) {
            this.accessorFactory = AccessorFactory.createFactory(kind, this.fieldName, fieldDescriptor.getFieldDeclaration(), accessorName);
            this.accessorDeclaration = this.accessorFactory.createDeclaration();
            for (IASTFunctionDefinition currentDefinition : context.existingFunctionDefinitions) {
                if (!currentDefinition.getDeclarator().getName().toString().equals(accessorName)) continue;
                this.existingAccessorDefinition = currentDefinition;
            }
            for (IASTSimpleDeclaration currentDeclaration : context.existingFunctionDeclarations) {
                if (!GetterSetterContext.getDeclarationName(currentDeclaration).toString().equals(accessorName)) continue;
                this.existingAccessorDeclaration = currentDeclaration;
            }
        }
    }

    boolean canBeGenerated() {
        return this.accessorName != null && this.existingAccessorDeclaration == null && this.existingAccessorDefinition == null;
    }

    public AccessorKind getKind() {
        return this.kind;
    }

    public IASTName getFieldName() {
        return this.fieldName;
    }

    @Override
    public int compareTo(AccessorDescriptor other) {
        int c = collator.compare(this.fieldName.toString(), other.fieldName.toString());
        if (c != 0) {
            return c;
        }
        return this.kind.ordinal() - other.kind.ordinal();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessorDescriptor)) {
            return false;
        }
        AccessorDescriptor other = (AccessorDescriptor)obj;
        return this.fieldName == other.fieldName && this.kind == other.kind;
    }

    public String toString() {
        return this.accessorName;
    }

    public IASTSimpleDeclaration getAccessorDeclaration() {
        return this.accessorDeclaration;
    }

    public IASTFunctionDefinition getAccessorDefinition(boolean qualifedName) {
        ICPPASTQualifiedName qname = qualifedName ? this.getClassName() : null;
        return this.accessorFactory.createDefinition(qname);
    }

    private ICPPASTQualifiedName getClassName() {
        IASTNode node = this.fieldName.getParent();
        while (!(node instanceof IASTCompositeTypeSpecifier)) {
            node = node.getParent();
        }
        IASTCompositeTypeSpecifier comp = (IASTCompositeTypeSpecifier)node;
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        qname.addName(comp.getName().copy(IASTNode.CopyStyle.withLocations));
        return qname;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessorKind {
        GETTER,
        SETTER;

    }
}

