/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.SourceHeaderPartnerFinder;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringASTCache;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDefinitionInsertLocationFinder {
    Map<IASTSimpleDeclaration, IASTName> cachedDeclarationToDefinition = new HashMap<IASTSimpleDeclaration, IASTName>();

    public InsertLocation find(ITranslationUnit declarationTu, IASTFileLocation methodDeclarationLocation, IASTNode parent, RefactoringASTCache astCache, IProgressMonitor pm) throws CoreException {
        IASTName definition;
        IASTDeclaration[] declarations = NodeHelper.getDeclarations(parent);
        InsertLocation insertLocation = new InsertLocation();
        Collection<IASTSimpleDeclaration> allPreviousSimpleDeclarationsFromClassInReverseOrder = MethodDefinitionInsertLocationFinder.getAllPreviousSimpleDeclarationsFromClassInReverseOrder(declarations, methodDeclarationLocation, pm);
        Collection<IASTSimpleDeclaration> allFollowingSimpleDeclarationsFromClass = MethodDefinitionInsertLocationFinder.getAllFollowingSimpleDeclarationsFromClass(declarations, methodDeclarationLocation, pm);
        for (IASTSimpleDeclaration simpleDeclaration : allPreviousSimpleDeclarationsFromClassInReverseOrder) {
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            definition = null;
            if (this.cachedDeclarationToDefinition.containsKey(simpleDeclaration)) {
                definition = this.cachedDeclarationToDefinition.get(simpleDeclaration);
            } else {
                definition = DefinitionFinder.getDefinition(simpleDeclaration, astCache, pm);
                if (definition != null) {
                    this.cachedDeclarationToDefinition.put(simpleDeclaration, definition);
                }
            }
            if (definition == null) continue;
            insertLocation.setNodeToInsertAfter(MethodDefinitionInsertLocationFinder.findFirstSurroundingParentFunctionNode((IASTNode)definition), definition.getTranslationUnit().getOriginatingTranslationUnit());
        }
        for (IASTSimpleDeclaration simpleDeclaration : allFollowingSimpleDeclarationsFromClass) {
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            definition = null;
            if (this.cachedDeclarationToDefinition.containsKey(simpleDeclaration)) {
                definition = this.cachedDeclarationToDefinition.get(simpleDeclaration);
            } else {
                definition = DefinitionFinder.getDefinition(simpleDeclaration, astCache, pm);
                if (definition != null) {
                    this.cachedDeclarationToDefinition.put(simpleDeclaration, definition);
                }
            }
            if (definition == null) continue;
            insertLocation.setNodeToInsertBefore(MethodDefinitionInsertLocationFinder.findFirstSurroundingParentFunctionNode((IASTNode)definition), definition.getTranslationUnit().getOriginatingTranslationUnit());
        }
        if (insertLocation.getTranslationUnit() == null) {
            if (declarationTu.isHeaderUnit()) {
                ITranslationUnit partner = SourceHeaderPartnerFinder.getPartnerTranslationUnit(declarationTu, astCache);
                if (partner != null) {
                    insertLocation.setParentNode((IASTNode)astCache.getAST(partner, null), partner);
                }
            } else {
                insertLocation.setParentNode((IASTNode)parent.getTranslationUnit(), declarationTu);
            }
        }
        return insertLocation;
    }

    private static IASTNode findFunctionDefinitionInParents(IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IASTFunctionDefinition) {
            if (node.getParent() instanceof ICPPASTTemplateDeclaration) {
                node = node.getParent();
            }
            return node;
        }
        return MethodDefinitionInsertLocationFinder.findFunctionDefinitionInParents(node.getParent());
    }

    private static IASTNode findFirstSurroundingParentFunctionNode(IASTNode definition) {
        IASTNode functionDefinitionInParents = MethodDefinitionInsertLocationFinder.findFunctionDefinitionInParents(definition);
        if (functionDefinitionInParents == null) {
            return null;
        }
        if (functionDefinitionInParents.getNodeLocations().length == 0) {
            return null;
        }
        return functionDefinitionInParents;
    }

    private static Collection<IASTSimpleDeclaration> getAllPreviousSimpleDeclarationsFromClassInReverseOrder(IASTDeclaration[] declarations, IASTFileLocation methodPosition, IProgressMonitor pm) {
        ArrayList<IASTSimpleDeclaration> outputDeclarations = new ArrayList<IASTSimpleDeclaration>();
        if (declarations.length >= 0) {
            IASTDeclaration[] iASTDeclarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration decl = iASTDeclarationArray[n2];
                if (pm != null && pm.isCanceled()) {
                    return outputDeclarations;
                }
                if (decl.getFileLocation().getStartingLineNumber() >= methodPosition.getStartingLineNumber()) break;
                if (MethodDefinitionInsertLocationFinder.isMemberFunctionDeclaration(decl)) {
                    outputDeclarations.add((IASTSimpleDeclaration)decl);
                }
                ++n2;
            }
        }
        Collections.reverse(outputDeclarations);
        return outputDeclarations;
    }

    private static Collection<IASTSimpleDeclaration> getAllFollowingSimpleDeclarationsFromClass(IASTDeclaration[] declarations, IASTFileLocation methodPosition, IProgressMonitor pm) {
        ArrayList<IASTSimpleDeclaration> outputDeclarations = new ArrayList<IASTSimpleDeclaration>();
        if (declarations.length >= 0) {
            IASTDeclaration[] iASTDeclarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration decl = iASTDeclarationArray[n2];
                if (pm != null && pm.isCanceled()) {
                    return outputDeclarations;
                }
                if (MethodDefinitionInsertLocationFinder.isMemberFunctionDeclaration(decl) && decl.getFileLocation().getStartingLineNumber() > methodPosition.getStartingLineNumber()) {
                    outputDeclarations.add((IASTSimpleDeclaration)decl);
                }
                ++n2;
            }
        }
        return outputDeclarations;
    }

    private static boolean isMemberFunctionDeclaration(IASTDeclaration decl) {
        return decl instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)decl).getDeclarators().length > 0 && ((IASTSimpleDeclaration)decl).getDeclarators()[0] instanceof IASTFunctionDeclarator;
    }
}

