/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.CreateFileChange;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ToggleFileCreator {
    private static final String EMPTY_STRING = "";
    private static final String H = ".h";
    private ToggleRefactoringContext context;
    private String ending;

    public ToggleFileCreator(ToggleRefactoringContext context, String ending) {
        this.context = context;
        this.ending = ending;
    }

    public IASTTranslationUnit loadTranslationUnit() {
        String filename = this.context.getDeclaration() != null ? this.context.getDeclaration().getContainingFilename() : this.context.getDefinition().getContainingFilename();
        String other = this.ending.equals(H) ? ".cpp" : H;
        filename = String.valueOf(filename.replaceAll("\\w*" + other + "$", EMPTY_STRING)) + this.getNewFileName();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename));
        IASTTranslationUnit result = null;
        try {
            result = CoreModelUtil.findTranslationUnitForLocation((IPath)file.getFullPath(), null).getAST();
        }
        catch (CModelException cModelException) {
        }
        catch (CoreException coreException) {}
        if (result == null) {
            throw new NotSupportedException(Messages.ToggleFileCreator_NoTuForSibling);
        }
        return result;
    }

    public void createNewFile() {
        String filename = this.getNewFileName();
        try {
            CreateFileChange change = new CreateFileChange(filename, (IPath)new Path(String.valueOf(this.getPath()) + filename), EMPTY_STRING, this.context.getSelectionFile().getCharset());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            throw new NotSupportedException(Messages.ToggleFileCreator_CanNotCreateNewFile);
        }
    }

    public boolean askUserForFileCreation(final ToggleRefactoringContext context) {
        if (context.isSettedDefaultAnswer()) {
            return context.getDefaultAnswer();
        }
        final Container answer = new Container();
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = CUIPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getShell();
                String functionname = context.getDeclaration() != null ? context.getDeclaration().getRawSignature() : context.getDefinition().getDeclarator().getRawSignature();
                boolean createnew = MessageDialog.openQuestion((Shell)shell, (String)Messages.ToggleFileCreator_NewImplFile, (String)(String.valueOf(Messages.ToggleFileCreator_CreateNewFile) + ToggleFileCreator.this.getNewFileName() + Messages.ToggleFileCreator_andMove + functionname + Messages.ToggleFileCreator_QMark));
                answer.setObject(createnew);
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(r);
        return (Boolean)answer.getObject();
    }

    public String getIncludeStatement() {
        return "#include \"" + ToggleNodeHelper.getFilenameWithoutExtension(this.getNewFileName()) + ".h\"";
    }

    private String getNewFileName() {
        return String.valueOf(ToggleNodeHelper.getFilenameWithoutExtension(this.context.getSelectionFile().getFullPath().toString())) + this.ending;
    }

    private String getPath() {
        String result = this.context.getSelectionFile().getFullPath().toOSString();
        return result.replaceAll("(\\w)*\\.(\\w)*", EMPTY_STRING);
    }
}

