/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.ui.refactoring.IndexToASTNameHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.DeclaratorFinder;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;

public class ToggleRefactoringContext {
    private IASTFunctionDefinition targetDefinition;
    private IASTFunctionDeclarator targetDeclaration;
    private IASTTranslationUnit targetDefinitionUnit;
    private IASTTranslationUnit targetDeclarationUnit;
    private IIndex index;
    private IASTTranslationUnit selectionUnit;
    private IFile selectionFile;
    private IBinding binding;
    private IASTName selectionName;
    private boolean defaultAnswer;
    private boolean settedDefaultAnswer;

    public ToggleRefactoringContext(IIndex index, IFile file, ITextSelection selection) {
        this.index = index;
        this.selectionFile = file;
        this.findSelectionUnit();
        this.findSelectedFunctionDeclarator(selection);
        this.findBinding();
        this.findDeclaration();
        this.findDefinition();
    }

    public void findSelectedFunctionDeclarator(ITextSelection selection) {
        this.selectionName = new DeclaratorFinder(selection, this.selectionUnit).getName();
    }

    public void findBinding() {
        try {
            this.binding = this.index.findBinding((IName)this.selectionName);
            if (this.binding == null) {
                this.binding = this.selectionName.resolveBinding();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public void findDeclaration() {
        try {
            IIndexName[] decnames = this.index.findNames(this.binding, 1);
            if (decnames.length > 1) {
                throw new NotSupportedException(Messages.ToggleRefactoringContext_MultipleDeclarations);
            }
            IIndexName[] iIndexNameArray = decnames;
            int n = decnames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName iname = iIndexNameArray[n2];
                this.selectionUnit = this.getTUForNameinFile(iname);
                IASTName astname = IndexToASTNameHelper.findMatchingASTName(this.selectionUnit, (IName)iname, this.index);
                if (astname != null) {
                    this.targetDeclaration = this.findFunctionDeclarator((IASTNode)astname);
                    this.targetDeclarationUnit = this.selectionUnit;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public void findDefinition() {
        try {
            IIndexName[] defnames = this.index.findNames(this.binding, 2);
            if (defnames.length > 1) {
                throw new NotSupportedException(Messages.ToggleRefactoringContext_MultipleDefinitions);
            }
            IIndexName[] iIndexNameArray = defnames;
            int n = defnames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName iname = iIndexNameArray[n2];
                IASTTranslationUnit unit = this.getTUForNameinFile(iname);
                IASTName astname = IndexToASTNameHelper.findMatchingASTName(unit, (IName)iname, this.index);
                if (astname != null) {
                    this.targetDefinition = this.findFunctionDefinition((IASTNode)astname);
                    this.targetDefinitionUnit = unit;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        if (this.targetDefinition == null) {
            throw new NotSupportedException(Messages.ToggleRefactoringContext_NoDefinitionFound);
        }
    }

    public IASTFunctionDeclarator getDeclaration() {
        return this.targetDeclaration;
    }

    public IASTFunctionDefinition getDefinition() {
        return this.targetDefinition;
    }

    public IASTTranslationUnit getDeclarationUnit() {
        return this.targetDeclarationUnit;
    }

    public IASTTranslationUnit getDefinitionUnit() {
        return this.targetDefinitionUnit;
    }

    public IFile getSelectionFile() {
        return this.selectionFile;
    }

    public IASTTranslationUnit getTUForSiblingFile() {
        IASTTranslationUnit unit = this.getDeclarationUnit();
        if (unit == null) {
            unit = this.getDefinitionUnit();
        }
        try {
            return ToggleNodeHelper.getSiblingFile(this.getSelectionFile(), unit);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return null;
        }
    }

    private void findSelectionUnit() {
        try {
            this.selectionUnit = TranslationUnitHelper.loadTranslationUnit(this.selectionFile, true);
        }
        catch (Exception exception) {}
        if (this.selectionUnit == null) {
            throw new NotSupportedException(Messages.ToggleRefactoringContext_NoTuFound);
        }
    }

    private IASTTranslationUnit getTUForNameinFile(IIndexName iname) throws CModelException, CoreException {
        if (this.isSameFileAsInTU(iname)) {
            return this.selectionUnit;
        }
        Path path = new Path(iname.getFileLocation().getFileName());
        return TranslationUnitHelper.loadTranslationUnit(path.toString(), true);
    }

    private boolean isSameFileAsInTU(IIndexName iname) {
        return iname.getFileLocation().getFileName().equals(this.selectionUnit.getFileLocation().getFileName());
    }

    private IASTFunctionDeclarator findFunctionDeclarator(IASTNode node) {
        if (node instanceof IASTSimpleDeclaration) {
            return (IASTFunctionDeclarator)((IASTSimpleDeclaration)node).getDeclarators()[0];
        }
        return (IASTFunctionDeclarator)ToggleNodeHelper.getAncestorOfType(node, IASTFunctionDeclarator.class);
    }

    private IASTFunctionDefinition findFunctionDefinition(IASTNode node) {
        return (IASTFunctionDefinition)ToggleNodeHelper.getAncestorOfType(node, IASTFunctionDefinition.class);
    }

    public void setDefaultAnswer(boolean defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
    }

    public boolean getDefaultAnswer() {
        return this.defaultAnswer;
    }

    public void setSettedDefaultAnswer(boolean settedDefaultAnswer) {
        this.settedDefaultAnswer = settedDefaultAnswer;
    }

    public boolean isSettedDefaultAnswer() {
        return this.settedDefaultAnswer;
    }
}

