/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringRunner;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class TogglingActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private TextSelection selection;
    private ICProject project;
    private IFile file;

    public void init(IWorkbenchWindow window) {
        this.window = window;
        assert (window != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean isTextSelection = selection != null && selection instanceof TextSelection;
        action.setEnabled(isTextSelection);
        if (!isTextSelection) {
            return;
        }
        this.selection = (TextSelection)CUIPlugin.getActivePage().getActiveEditor().getEditorSite().getSelectionProvider().getSelection();
    }

    public void run(IAction action) {
        if (!this.isWorkbenchReady()) {
            return;
        }
        new ToggleRefactoringRunner(this.file, (ITextSelection)this.selection, (ICElement)this.project, (IShellProvider)this.window, this.project).run();
    }

    private boolean isWorkbenchReady() {
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null) {
            return false;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor == null || editor.getEditorInput() == null) {
            return false;
        }
        IWorkingCopy wc = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (wc == null) {
            return false;
        }
        this.project = wc.getCProject();
        this.file = (IFile)wc.getResource();
        return this.project != null && this.file != null;
    }

    public void dispose() {
    }
}

