/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.viewsupport.IndexedFilesCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IndexedFilesLabelProvider
implements ILightweightLabelDecorator {
    private static final ImageDescriptor INDEXED = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.ui", (String)"$nl$/icons/ovr16/indexedFile.gif");

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IIndexFileLocation ifl = null;
        IProject project = null;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            ifl = IndexLocationFactory.getWorkspaceIFL((IFile)file);
            project = file.getProject();
        } else if (element instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)element;
            ifl = IndexLocationFactory.getIFL((ITranslationUnit)tu);
            project = tu.getCProject().getProject();
        }
        if (this.isIndexed(project, ifl)) {
            decoration.addOverlay(INDEXED, 0);
        }
    }

    private boolean isIndexed(IProject project, IIndexFileLocation ifl) {
        if (project == null || ifl == null) {
            return false;
        }
        return IndexedFilesCache.getInstance().isIndexed(project, ifl);
    }
}

