/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateEngineMessages;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TemplateEngineUIUtil {
    public static void showError(String message, Throwable t) {
        Object status;
        TemplateEngineUtil.log((Throwable)t);
        if (t != null) {
            if (t instanceof ProcessFailureException) {
                List statuses = ((ProcessFailureException)t).getStatuses();
                if (statuses == null || statuses.isEmpty()) {
                    Throwable p = t;
                    do {
                        if ((p = p.getCause()) == null) continue;
                        statuses = ((ProcessFailureException)p).getStatuses();
                    } while ((statuses == null || statuses.isEmpty()) && p != null && p instanceof ProcessFailureException);
                    status = statuses == null || statuses.isEmpty() ? new Status(4, CUIPlugin.getPluginId(), 4, t.getMessage(), t) : new MultiStatus(CUIPlugin.getPluginId(), 4, statuses.toArray(new IStatus[statuses.size()]), t.getMessage(), t);
                } else {
                    status = new MultiStatus(CUIPlugin.getPluginId(), 4, statuses.toArray(new IStatus[statuses.size()]), t.getMessage(), t);
                }
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                if (status != null && message.equals(status.getMessage())) {
                    message = null;
                }
            } else {
                status = new Status(4, CUIPlugin.getPluginId(), -1, String.valueOf(TemplateEngineMessages.getString((String)"TemplateEngine.internalError")) + message, t);
            }
        } else {
            status = new Status(4, CUIPlugin.getPluginId(), -1, String.valueOf(TemplateEngineMessages.getString((String)"TemplateEngine.internalError")) + message, null);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        ErrorDialog.openError((Shell)window.getShell(), (String)TemplateEngineMessages.getString((String)"TemplateEngine.templateEngine"), (String)message, (IStatus)status);
    }

    public static void showStatusDialog(String message, IStatus status) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        ErrorDialog.openError((Shell)window.getShell(), (String)TemplateEngineMessages.getString((String)"TemplateEngine.templateEngine"), (String)message, (IStatus)status);
    }
}

