/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.ui.templateengine.pages.Messages;
import org.eclipse.cdt.ui.templateengine.pages.TemplatePreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TemplateInputDialog
extends Dialog {
    private static final String NAME = Messages.getString("TemplateInputDialog.0");
    private static final String VALUE = Messages.getString("TemplateInputDialog.1");
    private static final String ADD_SHELL_MESSAGE = Messages.getString("TemplateInputDialog.2");
    private static final String EDIT_SHELL_MESSAGE = Messages.getString("TemplateInputDialog.3");
    private Label errMessageLabel;
    private String labelMessage = Messages.getString("TemplateInputDialog.4");
    private static final int TEXT_LIMIT = 100;
    private TemplatePreferencePage templatePreferencePage;
    private TemplateInputDialog sharedDialog;
    private Shell shell;
    private Display display;
    private Label valueLabel;
    private Label nameLabel;
    private Text valueText;
    private Text nameText;
    private Button oKButton;
    private int option;
    private Composite parent;

    protected TemplateInputDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.shell = shell;
        this.display = shell.getDisplay();
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.createControls(composite);
        return composite;
    }

    public void open(TemplateInputDialog myDialog, int dataOption) {
        this.option = dataOption;
        this.sharedDialog = myDialog;
        this.sharedDialog.create();
        Button oK = this.getButton(0);
        oK.setEnabled(false);
        if (this.option == 0) {
            this.shell.setText(ADD_SHELL_MESSAGE);
        } else if (this.option == 1) {
            this.shell.setText(EDIT_SHELL_MESSAGE);
        }
        this.sharedDialog.open();
    }

    private void createControls(Composite composite) {
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setText(NAME);
        this.nameText = new Text(composite, 2052);
        this.nameText.setTextLimit(100);
        GridData textData = new GridData(768);
        textData.horizontalSpan = 1;
        this.nameText.setLayoutData((Object)textData);
        this.addTextListener(this.nameText);
        this.valueLabel = new Label(composite, 0);
        this.valueLabel.setText(VALUE);
        this.valueText = new Text(composite, 2052);
        this.valueText.setTextLimit(100);
        GridData valueData = new GridData(768);
        valueData.horizontalSpan = 1;
        valueData.verticalSpan = 5;
        this.valueText.setLayoutData((Object)valueData);
        this.addTextListener(this.valueText);
        Color color = this.display.getSystemColor(3);
        Composite labelComposite = new Composite(this.parent, 0);
        labelComposite.setLayout((Layout)new GridLayout());
        labelComposite.setLayoutData((Object)new GridData(768));
        this.errMessageLabel = new Label(labelComposite, 4);
        this.errMessageLabel.setForeground(color);
        this.errMessageLabel.setText(this.labelMessage);
        this.errMessageLabel.setVisible(false);
        if (this.option == 1) {
            this.nameLabel.setEnabled(false);
            this.nameText.setEnabled(false);
            String name = TemplatePreferencePage.getSelectedItemNameFromTable();
            if (name != null) {
                this.nameText.setText(name);
            }
        }
    }

    public void addTextListener(final Text aText) {
        ModifyListener mListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String nameField = aText.getText();
                TemplateInputDialog.this.textChanged(nameField);
            }
        };
        aText.addModifyListener(mListener);
    }

    protected void okPressed() {
        String value;
        String name;
        if (this.option == 0) {
            name = this.nameText.getText();
            value = this.valueText.getText();
            if (name != "" && value != "") {
                this.templatePreferencePage = new TemplatePreferencePage(name, value);
                this.templatePreferencePage.addNewDataIntoTable();
                if (TemplatePreferencePage.isDup) {
                    this.nameText.setText("");
                    this.nameText.setFocus();
                    TemplatePreferencePage.isDup = false;
                } else if (!TemplatePreferencePage.isDup) {
                    this.nameText.setFocus();
                    this.sharedDialog.close();
                }
            }
        }
        if (this.option == 1) {
            name = this.nameText.getText();
            value = this.valueText.getText();
            if (!value.equals("")) {
                this.templatePreferencePage = new TemplatePreferencePage(name, value);
                this.templatePreferencePage.updateDataInTheTable();
            }
            this.sharedDialog.close();
        }
    }

    public int popDuplicate() {
        MessageBox mBox = new MessageBox(new Shell(), 2);
        mBox.setText(TemplatePreferencePage.Message);
        mBox.setMessage(TemplatePreferencePage.DuplicateEntry);
        int result = mBox.open();
        return result;
    }

    protected void cancelPressed() {
        this.sharedDialog.close();
    }

    private void textChanged(String textField) {
        this.errMessageLabel.setVisible(false);
        try {
            if (textField.matches("")) {
                this.oKButton = this.getButton(0);
                this.errMessageLabel.setText(this.labelMessage);
                this.errMessageLabel.setVisible(true);
                this.oKButton.setEnabled(false);
            } else if (!this.nameText.getText().equals("") && !this.valueText.getText().equals("")) {
                this.oKButton = this.getButton(0);
                this.oKButton.setEnabled(true);
            }
        }
        catch (Exception exp) {
            TemplateEngineUtil.log((Throwable)exp);
        }
    }
}

