/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools.generic;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.text.TaskTagRule;
import org.eclipse.cdt.ui.text.ICTokenScanner;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.cdt.ui.text.doctools.generic.GenericDocTag;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public class GenericTagCommentScanner
extends BufferedRuleBasedScanner
implements ICTokenScanner {
    protected TaskTagRule fTaskTagRule;
    protected IPreferenceStore fCorePreferenceStore;
    protected String fDefaultTokenProperty;
    protected String fTagToken;
    protected GenericDocTag[] fTags;
    protected char[] fTagMarkers;
    protected ITokenStore fTokenStore;

    public GenericTagCommentScanner(GenericDocTag[] tags, char[] tagMarkers, ITokenStoreFactory tokenStoreFactory, String docToken, String tagToken) {
        Assert.isNotNull((Object)tags);
        Assert.isNotNull((Object)tagMarkers);
        this.fTags = tags;
        this.fTagMarkers = tagMarkers;
        this.fTagToken = tagToken;
        this.fTokenStore = tokenStoreFactory.createTokenStore(GenericTagCommentScanner.mkArray(docToken, tagToken));
        this.fDefaultTokenProperty = docToken;
        this.setRules(this.createRules());
    }

    public IToken nextToken() {
        this.fTokenStore.ensureTokensInitialised();
        return super.nextToken();
    }

    protected IRule[] createRules() {
        ArrayList<Object> result = new ArrayList<Object>();
        this.setDefaultReturnToken(this.fTokenStore.getToken(this.fDefaultTokenProperty));
        class TagDetector
        implements IWordDetector {
            TagDetector() {
            }

            public boolean isWordStart(char c) {
                int i = 0;
                while (i < GenericTagCommentScanner.this.fTagMarkers.length) {
                    if (GenericTagCommentScanner.this.fTagMarkers[i] == c) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public boolean isWordPart(char c) {
                return c == '.' || Character.isJavaIdentifierPart(c);
            }
        }
        WordRule wr = new WordRule((IWordDetector)new TagDetector(), this.fDefaultReturnToken);
        int i = 0;
        while (i < this.fTags.length) {
            String wd = this.fTags[i].getTagName();
            int j = 0;
            while (j < this.fTagMarkers.length) {
                wr.addWord(String.valueOf(this.fTagMarkers[j]) + wd, this.fTokenStore.getToken(this.fTagToken));
                ++j;
            }
            ++i;
        }
        result.add(wr);
        this.fTaskTagRule = new TaskTagRule(this.fTokenStore.getToken("c_comment_task_tag"), this.fDefaultReturnToken, this.fTokenStore.getPreferenceStore(), this.fCorePreferenceStore);
        result.add(this.fTaskTagRule);
        return result.toArray(new IRule[result.size()]);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fTaskTagRule.affectsBehavior(event) || this.fTokenStore.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTokenStore.affectsBehavior(event)) {
            this.fTokenStore.adaptToPreferenceChange(event);
        }
        this.fTaskTagRule.adaptToPreferenceChange(event);
    }

    private static String[] mkArray(String defaultTokenProperty, String tagToken) {
        return new String[]{defaultTokenProperty, tagToken, "c_comment_task_tag"};
    }
}

