/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.StringDialogField;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SerialPortSettingsBlock
extends Observable {
    private static final String DEFAULT_ASYNC_DEVICE = "/dev/ttyS0";
    private static final String DEFAULT_ASYNC_DEVICE_SPEED = "115200";
    private Shell fShell;
    private StringDialogField fDeviceField;
    private ComboDialogField fSpeedField;
    private String[] fSpeedChoices = new String[]{"9600", "19200", "38400", "57600", "115200"};
    private Control fControl;
    private String fErrorMessage = null;

    public SerialPortSettingsBlock() {
        this.fDeviceField = this.createDeviceField();
        this.fSpeedField = this.createSpeedField();
    }

    public void createBlock(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(parent.getFont());
        PixelConverter converter = new PixelConverter((Control)comp);
        this.fDeviceField.doFillIntoGrid(comp, 2);
        LayoutUtil.setWidthHint((Control)this.fDeviceField.getTextControl(null), converter.convertWidthInCharsToPixels(20));
        this.fSpeedField.doFillIntoGrid(comp, 2);
        ((GridData)this.fSpeedField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        this.setControl((Control)comp);
    }

    protected Shell getShell() {
        return this.fShell;
    }

    public void dispose() {
        this.deleteObservers();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeDevice(configuration);
        this.initializeSpeed(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, DEFAULT_ASYNC_DEVICE);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, DEFAULT_ASYNC_DEVICE_SPEED);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDeviceField != null) {
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, this.fDeviceField.getText().trim());
        }
        if (this.fSpeedField != null) {
            int index = this.fSpeedField.getSelectionIndex();
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, this.getSpeedItem(index));
        }
    }

    private StringDialogField createDeviceField() {
        StringDialogField field = new StringDialogField();
        field.setLabelText(MIUIMessages.getString("SerialPortSettingsBlock.0"));
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                SerialPortSettingsBlock.this.deviceFieldChanged();
            }
        });
        return field;
    }

    private ComboDialogField createSpeedField() {
        ComboDialogField field = new ComboDialogField(12);
        field.setLabelText(MIUIMessages.getString("SerialPortSettingsBlock.1"));
        field.setItems(this.fSpeedChoices);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                SerialPortSettingsBlock.this.speedFieldChanged();
            }
        });
        return field;
    }

    protected void deviceFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    protected void speedFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    private void initializeDevice(ILaunchConfiguration configuration) {
        if (this.fDeviceField != null) {
            try {
                this.fDeviceField.setText(configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, DEFAULT_ASYNC_DEVICE));
            }
            catch (CoreException coreException) {}
        }
    }

    private void initializeSpeed(ILaunchConfiguration configuration) {
        if (this.fSpeedField != null) {
            int index = 0;
            try {
                index = this.getSpeedItemIndex(configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, DEFAULT_ASYNC_DEVICE_SPEED));
            }
            catch (CoreException coreException) {}
            this.fSpeedField.selectItem(index);
        }
    }

    private String getSpeedItem(int index) {
        return index >= 0 && index < this.fSpeedChoices.length ? this.fSpeedChoices[index] : null;
    }

    private int getSpeedItemIndex(String item) {
        int i = 0;
        while (i < this.fSpeedChoices.length) {
            if (this.fSpeedChoices[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setControl(Control control) {
        this.fControl = control;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.updateErrorMessage();
        return this.getErrorMessage() == null;
    }

    private void updateErrorMessage() {
        this.setErrorMessage(null);
        if (this.fDeviceField != null && this.fSpeedField != null) {
            if (this.fDeviceField.getText().trim().length() == 0) {
                this.setErrorMessage(MIUIMessages.getString("SerialPortSettingsBlock.2"));
            } else if (!this.deviceIsValid(this.fDeviceField.getText().trim())) {
                this.setErrorMessage(MIUIMessages.getString("SerialPortSettingsBlock.3"));
            } else if (this.fSpeedField.getSelectionIndex() < 0) {
                this.setErrorMessage(MIUIMessages.getString("SerialPortSettingsBlock.4"));
            }
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    private void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    private boolean deviceIsValid(String hostName) {
        return true;
    }
}

