/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.layout;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.RuleAction;
import com.android.ide.common.api.SegmentType;
import com.android.ide.common.layout.LinearLayoutRule;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TableLayoutRule
extends LinearLayoutRule {
    private static final String ACTION_ADD_ROW = "_addrow";
    private static final String ACTION_REMOVE_ROW = "_removerow";
    private static final URL ICON_ADD_ROW = TableLayoutRule.class.getResource("addrow.png");
    private static final URL ICON_REMOVE_ROW = TableLayoutRule.class.getResource("removerow.png");

    @Override
    protected boolean isVertical(INode node) {
        return true;
    }

    @Override
    protected boolean supportsOrientation() {
        return false;
    }

    @Override
    public void onChildInserted(@NonNull INode child, @NonNull INode parent, @NonNull InsertType insertType) {
    }

    @Override
    public void addContextMenuActions(@NonNull List<RuleAction> actions, final @NonNull INode selectedNode) {
        super.addContextMenuActions(actions, selectedNode);
        IMenuCallback addTab = new IMenuCallback(){

            public void action(@NonNull RuleAction action, @NonNull List<? extends INode> selectedNodes, @Nullable String valueId, @Nullable Boolean newValue) {
                INode node = selectedNode;
                INode newRow = node.appendChild("android.widget.TableRow");
                TableLayoutRule.this.mRulesEngine.select(Collections.singletonList(newRow));
            }
        };
        actions.add(RuleAction.createAction((String)ACTION_ADD_ROW, (String)"Add Row", (IMenuCallback)addTab, null, (int)5, (boolean)false));
    }

    @Override
    public void addLayoutActions(@NonNull List<RuleAction> actions, @NonNull INode parentNode, @NonNull List<? extends INode> children) {
        super.addLayoutActions(actions, parentNode, children);
        TableLayoutRule.addTableLayoutActions(this.mRulesEngine, actions, parentNode, children);
    }

    static void addTableLayoutActions(final IClientRulesEngine rulesEngine, List<RuleAction> actions, final INode parentNode, final List<? extends INode> children) {
        IMenuCallback actionCallback = new IMenuCallback(){

            public void action(final @NonNull RuleAction action, @NonNull List<? extends INode> selectedNodes, @Nullable String valueId, @Nullable Boolean newValue) {
                parentNode.editXml("Add/Remove Table Row", new INodeHandler(){

                    public void handle(@NonNull INode n) {
                        if (action.getId().equals(TableLayoutRule.ACTION_ADD_ROW)) {
                            int index = -1;
                            INode[] rows = parentNode.getChildren();
                            if (children != null) {
                                block0: for (INode child : children) {
                                    while (child != null && child.getParent() != parentNode) {
                                        child = child.getParent();
                                    }
                                    if (child == null) continue;
                                    int i = 0;
                                    while (i < rows.length) {
                                        if (rows[i] == child) {
                                            index = i;
                                            break block0;
                                        }
                                        ++i;
                                    }
                                }
                            }
                            INode newRow = index == -1 ? parentNode.appendChild("android.widget.TableRow") : parentNode.insertChildAt("android.widget.TableRow", index);
                            rulesEngine.select(Collections.singletonList(newRow));
                        } else if (action.getId().equals(TableLayoutRule.ACTION_REMOVE_ROW)) {
                            HashSet<INode> targets = new HashSet<INode>();
                            for (INode child : children) {
                                while (child != null && child.getParent() != parentNode) {
                                    child = child.getParent();
                                }
                                if (child == null) continue;
                                targets.add(child);
                            }
                            for (INode target : targets) {
                                parentNode.removeChild(target);
                            }
                        }
                    }
                });
            }
        };
        actions.add((RuleAction)RuleAction.createSeparator((int)150));
        actions.add(RuleAction.createAction((String)ACTION_ADD_ROW, (String)"Add Table Row", (IMenuCallback)actionCallback, (URL)ICON_ADD_ROW, (int)160, (boolean)false));
        if (children != null && children.size() > 0) {
            actions.add(RuleAction.createAction((String)ACTION_REMOVE_ROW, (String)"Remove Table Row", (IMenuCallback)actionCallback, (URL)ICON_REMOVE_ROW, (int)170, (boolean)false));
        }
    }

    public void onCreate(@NonNull INode node, @NonNull INode parent, @NonNull InsertType insertType) {
        super.onCreate(node, parent, insertType);
        if (insertType.isCreate()) {
            int i = 0;
            while (i < 4) {
                node.appendChild("android.widget.TableRow");
                ++i;
            }
        }
    }

    @Override
    public DropFeedback onResizeBegin(@NonNull INode child, @NonNull INode parent, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge, @Nullable Object childView, @Nullable Object parentView) {
        if (horizontalEdge == null) {
            return null;
        }
        if (child.getFqcn().equals("android.widget.TableRow")) {
            return null;
        }
        return super.onResizeBegin(child, parent, horizontalEdge, null, childView, parentView);
    }
}

