/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.actions;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.sdk.AdtConsoleSdkLog;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SdkManagerAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        AdtPlugin.getDefault().refreshSdk();
        if (!SdkManagerAction.openExternalSdkManager() && AdtPlugin.getDefault().checkSdkLocationAndId()) {
            AdtPlugin.displayError("Android SDK", "Failed to run the Android SDK Manager. Check the Android Console View for details.");
        }
    }

    public static boolean openExternalSdkManager() {
        final AtomicBoolean returnValue = new AtomicBoolean(false);
        final CloseableProgressMonitorDialog p = new CloseableProgressMonitorDialog(AdtPlugin.getShell());
        p.setOpenOnRun(true);
        try {
            p.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String osSdkLocation;
                    Sdk sdk = Sdk.getCurrent();
                    String string = osSdkLocation = sdk == null ? null : sdk.getSdkOsLocation();
                    if (osSdkLocation == null || !new File(osSdkLocation).isDirectory()) {
                        osSdkLocation = AdtPrefs.getPrefs().getOsSdkFolder();
                    }
                    if (osSdkLocation == null || !new File(osSdkLocation).isDirectory()) {
                        return;
                    }
                    monitor.beginTask("Starting Android SDK Manager", 30);
                    File androidBat = FileOp.append((String)osSdkLocation, (String[])new String[]{"tools", SdkConstants.androidCmdName()});
                    if (!androidBat.exists()) {
                        AdtPlugin.printErrorToConsole("SDK Manager", "Missing %s file in Android SDK.", SdkConstants.androidCmdName());
                        return;
                    }
                    if (monitor.isCanceled()) {
                        returnValue.set(true);
                        return;
                    }
                    p.changeCancelToClose();
                    try {
                        final AdtConsoleSdkLog logger = new AdtConsoleSdkLog();
                        String[] command = new String[]{androidBat.getAbsolutePath(), "sdk"};
                        Process process = Runtime.getRuntime().exec(command);
                        GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                            public void out(@Nullable String line) {
                            }

                            public void err(@Nullable String line) {
                                if (line != null) {
                                    logger.info("[SDK Manager] %s", line);
                                }
                            }
                        });
                        returnValue.set(true);
                    }
                    catch (Exception exception) {}
                    int i = 0;
                    while (i < 30) {
                        if (monitor.isCanceled()) {
                            returnValue.set(true);
                            return;
                        }
                        if (i == 10) {
                            monitor.subTask("Initializing... SDK Manager will show up shortly.");
                        }
                        try {
                            Thread.sleep(100L);
                            monitor.worked(1);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            AdtPlugin.log(e, "SDK Manager exec failed", new Object[0]);
            return false;
        }
        return returnValue.get();
    }

    public static boolean openAdtSdkManager() {
        final Sdk sdk = Sdk.getCurrent();
        if (sdk == null) {
            return false;
        }
        SdkUpdaterWindow window = new SdkUpdaterWindow(AdtPlugin.getShell(), (ILogger)new AdtConsoleSdkLog(){

            @Override
            public void info(@NonNull String msgFormat, Object ... args) {
            }

            @Override
            public void verbose(@NonNull String msgFormat, Object ... args) {
            }
        }, sdk.getSdkOsLocation(), SdkUpdaterWindow.SdkInvocationContext.IDE);
        ISdkChangeListener listener = new ISdkChangeListener(){

            public void onSdkLoaded() {
            }

            public void preInstallHook() {
                if (sdk != null) {
                    sdk.unloadTargetData(true);
                    sdk.unloadDexWrappers();
                }
            }

            public void postInstallHook() {
            }

            public void onSdkReload() {
                AdtPlugin.getDefault().reparseSdk();
            }
        };
        window.addListener(listener);
        window.open();
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private static class CloseableProgressMonitorDialog
    extends ProgressMonitorDialog {
        public CloseableProgressMonitorDialog(Shell parent) {
            super(parent);
        }

        public void changeCancelToClose() {
            if (this.cancel != null && !this.cancel.isDisposed()) {
                Display display;
                Display display2 = display = this.getShell() == null ? null : this.getShell().getDisplay();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CloseableProgressMonitorDialog.this.cancel != null && !CloseableProgressMonitorDialog.this.cancel.isDisposed()) {
                                CloseableProgressMonitorDialog.this.cancel.setText(IDialogConstants.CLOSE_LABEL);
                            }
                        }
                    });
                }
            }
        }
    }
}

