/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build.builders;

import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.build.SourceChangeHandler;
import com.android.ide.eclipse.adt.internal.build.builders.BaseBuilder;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.XmlErrorHandler;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PreCompilerDeltaVisitor
extends BaseBuilder.BaseDeltaVisitor
implements IResourceDeltaVisitor {
    private boolean mChangedManifest = false;
    private boolean mCompileResources = false;
    private boolean mCheckedManifestXml = false;
    private String mJavaPackage = null;
    private String mMinSdkVersion = null;
    private boolean mInRes = false;
    private IFolder mSourceFolder = null;
    private final List<IPath> mSourceFolders;
    private boolean mIsGenSourceFolder = false;
    private final List<SourceChangeHandler> mSourceChangeHandlers = Lists.newArrayList();
    private final IWorkspaceRoot mRoot;
    private IFolder mAndroidOutputFolder;

    public PreCompilerDeltaVisitor(BaseBuilder builder, List<IPath> sourceFolders, SourceChangeHandler ... handlers) {
        super(builder);
        this.mSourceFolders = sourceFolders;
        this.mRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.mSourceChangeHandlers.addAll(Arrays.asList(handlers));
        this.mAndroidOutputFolder = BaseProjectHelper.getAndroidOutputFolder(builder.getProject());
    }

    public boolean getCompileResources() {
        return this.mCompileResources || this.mChangedManifest;
    }

    public boolean hasManifestChanged() {
        return this.mChangedManifest;
    }

    public boolean getCheckedManifestXml() {
        return this.mCheckedManifestXml;
    }

    public String getManifestPackage() {
        return this.mJavaPackage;
    }

    public String getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IPath path;
        IResource resource;
        block27: {
            block29: {
                int kind;
                IFile file;
                block28: {
                    String msg;
                    String fileName;
                    block30: {
                        resource = delta.getResource();
                        path = resource.getFullPath();
                        String[] segments = path.segments();
                        if (segments.length == 1) {
                            return true;
                        }
                        if (segments.length == 2) {
                            this.mInRes = false;
                            this.mSourceFolder = null;
                            if ("res".equalsIgnoreCase(segments[1])) {
                                this.mInRes = true;
                                this.mSourceFolder = null;
                                return true;
                            }
                            if ("AndroidManifest.xml".equalsIgnoreCase(segments[1])) {
                                if (delta.getKind() != 2) {
                                    ManifestData manifestData;
                                    IFile manifestFile = (IFile)resource;
                                    if (manifestFile.exists()) {
                                        manifestFile.deleteMarkers("com.android.ide.eclipse.common.xmlProblem", true, 0);
                                        manifestFile.deleteMarkers("com.android.ide.eclipse.common.androidProblem", true, 0);
                                    }
                                    if ((manifestData = AndroidManifestHelper.parse(new IFileWrapper(manifestFile), true, (XmlErrorHandler.XmlErrorListener)this)) != null) {
                                        this.mJavaPackage = manifestData.getPackage();
                                        this.mMinSdkVersion = manifestData.getMinSdkVersionString();
                                    }
                                    this.mCheckedManifestXml = true;
                                }
                                this.mChangedManifest = true;
                                return false;
                            }
                        }
                        if (this.mSourceFolder == null) break block27;
                        if (resource.getType() == 2) {
                            return true;
                        }
                        if (resource.getType() != 1) {
                            return false;
                        }
                        file = (IFile)resource;
                        kind = delta.getKind();
                        if (!this.mIsGenSourceFolder) break block28;
                        boolean outputWarning = false;
                        fileName = resource.getName();
                        if ("R.java".equals(fileName) || "Manifest.java".equals(fileName)) {
                            this.mCompileResources = true;
                            outputWarning = true;
                        } else {
                            for (SourceChangeHandler handler : this.mSourceChangeHandlers) {
                                if (!handler.handleGeneratedFile(file, kind)) continue;
                                outputWarning = true;
                                break;
                            }
                        }
                        if (!outputWarning) break block29;
                        if (kind != 2) break block30;
                        msg = String.format(Messages.s_Removed_Recreating_s, fileName);
                        AdtPlugin.printErrorToConsole(this.mBuilder.getProject(), new Object[]{msg});
                        break block29;
                    }
                    if (kind != 4) break block29;
                    msg = String.format(Messages.s_Modified_Manually_Recreating_s, fileName);
                    AdtPlugin.printErrorToConsole(this.mBuilder.getProject(), new Object[]{msg});
                    break block29;
                }
                for (SourceChangeHandler handler : this.mSourceChangeHandlers) {
                    handler.handleSourceFile(file, kind);
                }
            }
            return false;
        }
        if (this.mInRes) {
            if (resource.getType() == 2) {
                return true;
            }
            String ext = resource.getFileExtension();
            int kind = delta.getKind();
            String p = resource.getProjectRelativePath().toString();
            String message = null;
            switch (kind) {
                case 4: {
                    message = String.format(Messages.s_Modified_Recreating_s, p);
                    break;
                }
                case 1: {
                    message = String.format(Messages.Added_s_s_Needs_Updating, p, "R.java");
                    break;
                }
                case 2: {
                    message = String.format(Messages.s_Removed_s_Needs_Updating, p, "R.java");
                }
            }
            if (message != null) {
                AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.mBuilder.getProject(), message);
            }
            if ("xml".equalsIgnoreCase(ext) && kind != 2) {
                this.mBuilder.checkXML(resource, this);
            }
        } else if (resource instanceof IFolder) {
            if (resource.equals((Object)this.mAndroidOutputFolder)) {
                return true;
            }
            for (IPath sourceFolderPath : this.mSourceFolders) {
                if (sourceFolderPath.equals((Object)path)) {
                    this.mInRes = false;
                    this.mSourceFolder = this.getFolder(sourceFolderPath);
                    this.mIsGenSourceFolder = path.segmentCount() == 2 && path.segment(1).equals("gen");
                    return true;
                }
                int count = sourceFolderPath.matchingFirstSegments(path);
                if (count != path.segmentCount()) continue;
                this.mInRes = false;
                return true;
            }
            return false;
        }
        return false;
    }

    private IFolder getFolder(IPath path) {
        IResource resource = this.mRoot.findMember(path);
        if (resource != null && resource.exists() && resource.getType() == 2) {
            return (IFolder)resource;
        }
        return null;
    }
}

