/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.animator;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.animator.AnimationContentAssist;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlDelegate;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.resources.ResourceFolderType;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnimationEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "com.android.ide.eclipse.editors.animator.AnimationEditor";
    private String mRootTag;

    private AnimationEditorDelegate(CommonXmlEditor editor) {
        super(editor, new AnimationContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
    }

    @Override
    public void delegateXmlModelChanged(Document xmlDoc) {
        AndroidTargetData data;
        Element rootElement = xmlDoc.getDocumentElement();
        if (rootElement != null) {
            this.mRootTag = rootElement.getTagName();
        }
        this.delegateInitUiRootNode(false);
        if (this.mRootTag != null && !this.mRootTag.equals(this.getUiRootNode().getDescriptor().getXmlLocalName()) && (data = this.getEditor().getTargetData()) != null) {
            ElementDescriptor descriptor = this.getFolderType() == ResourceFolderType.ANIM ? data.getAnimDescriptors().getElementDescriptor(this.mRootTag) : data.getAnimatorDescriptors().getElementDescriptor(this.mRootTag);
            this.getUiRootNode().setEditor(null);
            this.getUiRootNode().setXmlDocument(null);
            this.setUiRootNode(descriptor.createUiNode());
            this.getUiRootNode().setXmlDocument(xmlDoc);
            this.getUiRootNode().setEditor(this.getEditor());
        }
        if (this.getUiRootNode().getDescriptor() instanceof DocumentDescriptor) {
            this.getUiRootNode().loadFromXmlNode(xmlDoc);
        } else {
            this.getUiRootNode().loadFromXmlNode(rootElement);
        }
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            ElementDescriptor descriptor;
            boolean reload = false;
            AndroidTargetData data = this.getEditor().getTargetData();
            if (data == null) {
                descriptor = new DocumentDescriptor("temp", null);
            } else {
                descriptor = this.getFolderType() == ResourceFolderType.ANIM ? data.getAnimDescriptors().getElementDescriptor(this.mRootTag) : data.getAnimatorDescriptors().getElementDescriptor(this.mRootTag);
                reload = true;
            }
            this.setUiRootNode(((ElementDescriptor)descriptor).createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            if (reload) {
                this.onDescriptorsChanged();
            }
        }
    }

    private ResourceFolderType getFolderType() {
        String folderName = AdtUtils.getParentFolderName(this.getEditor().getEditorInput());
        if (folderName.length() > 0) {
            return ResourceFolderType.getFolderType((String)folderName);
        }
        return ResourceFolderType.ANIMATOR;
    }

    private void onDescriptorsChanged() {
        IStructuredModel model = this.getEditor().getModelForRead();
        if (model != null) {
            try {
                Element node = this.getEditor().getXmlDocument(model).getDocumentElement();
                this.getUiRootNode().reloadFromXmlNode(node);
            }
            finally {
                model.releaseFromRead();
            }
        }
    }

    /* synthetic */ AnimationEditorDelegate(CommonXmlEditor commonXmlEditor, AnimationEditorDelegate animationEditorDelegate) {
        this(commonXmlEditor);
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public AnimationEditorDelegate createForFile(@NonNull CommonXmlEditor delegator, @Nullable ResourceFolderType type) {
            if (ResourceFolderType.ANIM == type || ResourceFolderType.ANIMATOR == type) {
                return new AnimationEditorDelegate(delegator, null);
            }
            return null;
        }
    }
}

