/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.color;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.editors.color.ColorContentAssist;
import com.android.ide.eclipse.adt.internal.editors.color.ColorDescriptors;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlDelegate;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.resources.ResourceFolderType;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColorEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "com.android.ide.eclipse.editors.color.ColorEditor";

    private ColorEditorDelegate(CommonXmlEditor editor) {
        super(editor, new ColorContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
    }

    @Override
    public void delegateXmlModelChanged(Document xmlDoc) {
        this.delegateInitUiRootNode(false);
        Element rootElement = xmlDoc.getDocumentElement();
        this.getUiRootNode().loadFromXmlNode(rootElement);
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            AndroidTargetData data = this.getEditor().getTargetData();
            ElementDescriptor descriptor = data == null ? new ColorDescriptors().getDescriptor() : data.getColorDescriptors().getDescriptor();
            this.setUiRootNode(descriptor.createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            this.onDescriptorsChanged();
        }
    }

    private void onDescriptorsChanged() {
        IStructuredModel model = this.getEditor().getModelForRead();
        if (model != null) {
            try {
                Element node = this.getEditor().getXmlDocument(model).getDocumentElement();
                this.getUiRootNode().reloadFromXmlNode(node);
            }
            finally {
                model.releaseFromRead();
            }
        }
    }

    /* synthetic */ ColorEditorDelegate(CommonXmlEditor commonXmlEditor, ColorEditorDelegate colorEditorDelegate) {
        this(commonXmlEditor);
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public ColorEditorDelegate createForFile(@NonNull CommonXmlEditor delegator, @Nullable ResourceFolderType type) {
            if (ResourceFolderType.COLOR == type) {
                return new ColorEditorDelegate(delegator, null);
            }
            return null;
        }
    }
}

