/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.formatting;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.xml.XmlAttributeSortOrder;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import java.util.Comparator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.w3c.dom.Attr;

public class EclipseXmlFormatPreferences
extends XmlFormatPreferences {
    private static final Comparator<Attr> EXISTING_ORDER_COMPARATOR = new Comparator<Attr>(){

        @Override
        public int compare(Attr attr1, Attr attr2) {
            IndexedRegion region1 = (IndexedRegion)attr1;
            IndexedRegion region2 = (IndexedRegion)attr2;
            return region1.getStartOffset() - region2.getStartOffset();
        }
    };

    protected EclipseXmlFormatPreferences() {
    }

    @NonNull
    public static EclipseXmlFormatPreferences create() {
        EclipseXmlFormatPreferences p = new EclipseXmlFormatPreferences();
        AdtPrefs prefs = AdtPrefs.getPrefs();
        p.useEclipseIndent = prefs.isUseEclipseIndent();
        p.removeEmptyLines = prefs.isRemoveEmptyLines();
        p.oneAttributeOnFirstLine = prefs.isOneAttributeOnFirstLine();
        p.sortAttributes = prefs.getAttributeSort();
        p.spaceBeforeClose = prefs.isSpaceBeforeClose();
        return p;
    }

    @Nullable
    public Comparator<Attr> getAttributeComparator() {
        if (this.sortAttributes == XmlAttributeSortOrder.NO_SORTING) {
            return EXISTING_ORDER_COMPARATOR;
        }
        return this.sortAttributes.getAttributeComparator();
    }

    public String getOneIndentUnit() {
        if (this.useEclipseIndent) {
            Preferences preferences = XMLCorePlugin.getDefault().getPluginPreferences();
            int indentationWidth = preferences.getInt("indentationSize");
            String indentCharPref = preferences.getString("indentationChar");
            boolean useSpaces = "space".equals(indentCharPref);
            StringBuilder indentString = new StringBuilder();
            int j = 0;
            while (j < indentationWidth) {
                if (useSpaces) {
                    indentString.append(' ');
                } else {
                    indentString.append('\t');
                }
                ++j;
            }
            this.mOneIndentUnit = indentString.toString();
        }
        return this.mOneIndentUnit;
    }

    public int getTabWidth() {
        if (this.mTabWidth == -1) {
            String key = "tabWidth";
            try {
                IPreferenceStore prefs = EditorsPlugin.getDefault().getPreferenceStore();
                this.mTabWidth = prefs.getInt(key);
            }
            catch (Throwable throwable) {}
            if (this.mTabWidth <= 0) {
                this.mTabWidth = 4;
            }
        }
        return this.mTabWidth;
    }
}

