/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.XmlEditorMultiOutline;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlDelegate;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IUnknownDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutContentAssist;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.CustomViewDescriptorService;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.LayoutDescriptors;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutActionBar;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.OutlinePage;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.RulesEngine;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.PropertySheetPage;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.lint.EclipseLintClient;
import com.android.ide.eclipse.adt.internal.lint.EclipseLintRunner;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.client.api.IssueRegistry;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LayoutEditorDelegate
extends CommonXmlDelegate
implements IShowEditorInput,
CommonXmlDelegate.IActionContributorDelegate {
    private static final String LAYOUT_FOLDER_PREFIX = "layout-";
    public static final String LEGACY_EDITOR_ID = "com.android.ide.eclipse.editors.layout.LayoutEditor";
    private UiDocumentNode mUiDocRootNode;
    private GraphicalEditorPart mGraphicalEditor;
    private int mGraphicalEditorIndex;
    private OutlinePage mLayoutOutline;
    private IContentOutlinePage mEditorOutline;
    private XmlEditorMultiOutline mMultiOutline;
    private boolean mCheckOutlineAdapter;
    private IPropertySheetPage mPropertyPage;
    private final HashMap<String, ElementDescriptor> mUnknownDescriptorMap = new HashMap();
    private EclipseLintClient mClient;
    private boolean mNewFileOnConfigChange = false;

    @Nullable
    public static LayoutEditorDelegate fromEditor(@Nullable IEditorPart editorPart) {
        if (editorPart instanceof CommonXmlEditor) {
            CommonXmlDelegate delegate = ((CommonXmlEditor)editorPart).getDelegate();
            if (delegate instanceof LayoutEditorDelegate) {
                return (LayoutEditorDelegate)delegate;
            }
        } else if (editorPart instanceof GraphicalEditorPart) {
            GraphicalEditorPart part = (GraphicalEditorPart)editorPart;
            return part.getEditorDelegate();
        }
        return null;
    }

    protected LayoutEditorDelegate(CommonXmlEditor editor) {
        super(editor, new LayoutContentAssist());
    }

    public RulesEngine getRulesEngine() {
        return this.mGraphicalEditor.getRulesEngine();
    }

    public GraphicalEditorPart getGraphicalEditor() {
        return this.mGraphicalEditor;
    }

    @Override
    public UiDocumentNode getUiRootNode() {
        return this.mUiDocRootNode;
    }

    public void setNewFileOnConfigChange(boolean state) {
        this.mNewFileOnConfigChange = state;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.dispose();
            this.mGraphicalEditor = null;
        }
    }

    @Override
    public void delegateDoSave(IProgressMonitor monitor) {
        super.delegateDoSave(monitor);
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.doSave(monitor);
        }
    }

    @Override
    public void delegateCreateFormPages() {
        try {
            IFile editedFile = null;
            IEditorInput input = this.getEditor().getEditorInput();
            if (input instanceof FileEditorInput) {
                FileEditorInput fileInput = (FileEditorInput)input;
                editedFile = fileInput.getFile();
                if (!editedFile.isAccessible()) {
                    return;
                }
            } else {
                AdtPlugin.log(4, "Input is not of type FileEditorInput: %1$s", input.toString());
            }
            if (this.mGraphicalEditor == null) {
                this.mGraphicalEditor = new GraphicalEditorPart(this);
                this.mGraphicalEditorIndex = this.getEditor().addPage((IEditorPart)this.mGraphicalEditor, this.getEditor().getEditorInput());
                this.getEditor().setPageText(this.mGraphicalEditorIndex, this.mGraphicalEditor.getTitle());
                this.mGraphicalEditor.openFile(editedFile);
            } else if (this.mNewFileOnConfigChange) {
                this.mGraphicalEditor.changeFileOnNewConfig(editedFile);
                this.mNewFileOnConfigChange = false;
            } else {
                this.mGraphicalEditor.replaceFile(editedFile);
            }
        }
        catch (PartInitException e) {
            AdtPlugin.log(e, "Error creating nested page", new Object[0]);
        }
    }

    @Override
    public void delegatePostCreatePages() {
    }

    @Override
    public void delegateSetInput(IEditorInput input) {
        this.handleNewInput(input);
    }

    public void delegateSetInputWithNotify(IEditorInput input) {
        this.handleNewInput(input);
    }

    public void showEditorInput(IEditorInput editorInput) {
        if (this.getEditor().getEditorInput().equals(editorInput)) {
            return;
        }
        this.getEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        int currentPage = this.getEditor().getActivePage();
        int count = this.getEditor().getPageCount();
        int i = count - 1;
        while (i > this.mGraphicalEditorIndex) {
            this.getEditor().removePage(i);
            --i;
        }
        i = this.mGraphicalEditorIndex - 1;
        while (i >= 0) {
            this.getEditor().removePage(i);
            --i;
        }
        this.getEditor().setInputWithNotify(editorInput);
        this.getEditor().createAndroidPages();
        this.getEditor().selectDefaultPage(Integer.toString(currentPage));
        this.getEditor().firePropertyChange(1);
    }

    public void refreshXmlModel() {
        Document xmlDoc = this.mUiDocRootNode.getXmlDocument();
        this.delegateInitUiRootNode(true);
        this.mUiDocRootNode.loadFromXmlNode(xmlDoc);
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.onXmlModelChanged();
        }
    }

    @Override
    public void delegateXmlModelChanged(Document xml_doc) {
        this.delegateInitUiRootNode(false);
        this.mUiDocRootNode.loadFromXmlNode(xml_doc);
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.onXmlModelChanged();
        }
    }

    public void recomputeLayout() {
        this.mGraphicalEditor.recomputeLayout();
    }

    @Override
    public boolean delegateSupportsFormatOnGuiEdit() {
        return true;
    }

    @Nullable
    public IMarker getIssueForNode(@Nullable UiViewElementNode node) {
        if (node == null) {
            return null;
        }
        if (this.mClient != null) {
            return this.mClient.getIssueForNode(node);
        }
        return null;
    }

    @Nullable
    public Collection<Node> getLintNodes() {
        if (this.mClient != null) {
            return this.mClient.getIssueNodes();
        }
        return null;
    }

    @Override
    public Job delegateRunLint() {
        GraphicalEditorPart graphicalEditor;
        Job job = null;
        IFile file = this.getEditor().getInputFile();
        if (file != null) {
            IssueRegistry registry = EclipseLintClient.getRegistry();
            List<IFile> resources = Collections.singletonList(file);
            this.mClient = new EclipseLintClient(registry, resources, (IDocument)this.getEditor().getStructuredDocument(), false);
            this.mClient.setCollectNodes(true);
            job = EclipseLintRunner.startLint(this.mClient, resources, (IResource)file, false);
        }
        if (job != null && (graphicalEditor = this.getGraphicalEditor()) != null) {
            job.addJobChangeListener((IJobChangeListener)new LintJobListener(graphicalEditor));
        }
        return job;
    }

    @Override
    public Object delegateGetAdapter(Class<?> adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.mCheckOutlineAdapter && this.mEditorOutline != null) {
                StackTraceElement frame;
                this.mCheckOutlineAdapter = false;
                StackTraceElement[] frames = new Throwable().fillInStackTrace().getStackTrace();
                if (frames.length > 2 && (frame = frames[2]).getClassName().equals("org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage$PostSelectionServiceListener")) {
                    return this.mEditorOutline;
                }
            }
            if (this.mMultiOutline == null || this.mMultiOutline.isDisposed()) {
                this.mMultiOutline = new XmlEditorMultiOutline();
                this.mMultiOutline.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ISelection selection = event.getSelection();
                        LayoutEditorDelegate.this.getEditor().getSite().getSelectionProvider().setSelection(selection);
                        if (LayoutEditorDelegate.this.getEditor().getIgnoreXmlUpdate()) {
                            return;
                        }
                        SelectionManager manager = LayoutEditorDelegate.this.mGraphicalEditor.getCanvasControl().getSelectionManager();
                        manager.setSelection(selection);
                    }
                });
                this.updateOutline(this.getEditor().getActivePageInstance());
            }
            return this.mMultiOutline;
        }
        if (IPropertySheetPage.class == adapter && this.mGraphicalEditor != null) {
            if (this.mPropertyPage == null) {
                this.mPropertyPage = new PropertySheetPage(this.mGraphicalEditor);
            }
            return this.mPropertyPage;
        }
        return super.delegateGetAdapter(adapter);
    }

    private void updateOutline(IFormPage page) {
        OutlinePage outline;
        if (this.mMultiOutline == null) {
            return;
        }
        CommonXmlEditor editor = this.getEditor();
        if (!editor.isEditorPageActive()) {
            outline = this.getGraphicalOutline();
        } else {
            StructuredTextEditor structuredTextEditor;
            if (this.mEditorOutline == null && (structuredTextEditor = editor.getStructuredTextEditor()) != null) {
                IWorkbenchWindow window = editor.getSite().getWorkbenchWindow();
                ISelectionService service = window.getSelectionService();
                service.addPostSelectionListener(new ISelectionListener(){

                    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                        if (LayoutEditorDelegate.this.getEditor().isEditorPageActive()) {
                            LayoutEditorDelegate.this.mCheckOutlineAdapter = true;
                        }
                    }
                });
                this.mEditorOutline = (IContentOutlinePage)structuredTextEditor.getAdapter(IContentOutlinePage.class);
            }
            outline = this.mEditorOutline;
        }
        this.mMultiOutline.setPageActive((IContentOutlinePage)outline);
    }

    @NonNull
    public OutlinePage getGraphicalOutline() {
        if (this.mLayoutOutline == null) {
            this.mLayoutOutline = new OutlinePage(this.mGraphicalEditor);
        }
        return this.mLayoutOutline;
    }

    @Override
    public void delegatePageChange(int newPageIndex) {
        Node node;
        ISourceViewer textViewer;
        int caretOffset;
        if (this.getEditor().getCurrentPage() == this.getEditor().getTextPageIndex() && newPageIndex == this.mGraphicalEditorIndex && (caretOffset = (textViewer = this.getEditor().getStructuredSourceViewer()).getTextWidget().getCaretOffset()) >= 0 && (node = DomUtilities.getNode(textViewer.getDocument(), caretOffset)) != null && this.mGraphicalEditor != null) {
            this.mGraphicalEditor.select(node);
        }
        super.delegatePageChange(newPageIndex);
        if (this.mGraphicalEditor != null) {
            if (newPageIndex == this.mGraphicalEditorIndex) {
                this.mGraphicalEditor.activated();
            } else {
                this.mGraphicalEditor.deactivated();
            }
        }
    }

    @Override
    public int delegateGetPersistenceCategory() {
        return 1;
    }

    @Override
    public void delegatePostPageChange(int newPageIndex) {
        IActionBars bars;
        LayoutCanvas canvas;
        super.delegatePostPageChange(newPageIndex);
        if (this.mGraphicalEditor != null && (canvas = this.mGraphicalEditor.getCanvasControl()) != null && (bars = this.getEditor().getEditorSite().getActionBars()) != null) {
            canvas.updateGlobalActions(bars);
        }
        IFormPage page = this.getEditor().getActivePageInstance();
        this.updateOutline(page);
    }

    @Override
    public IFormPage delegatePostSetActivePage(IFormPage superReturned, String pageIndex) {
        IFormPage page = superReturned;
        if (page != null) {
            this.updateOutline(page);
        }
        return page;
    }

    @Override
    public void setActiveEditor(IEditorPart part, IActionBars bars) {
        LayoutCanvas canvas;
        if (this.mGraphicalEditor != null && (canvas = this.mGraphicalEditor.getCanvasControl()) != null) {
            canvas.updateGlobalActions(bars);
        }
    }

    @Override
    public void delegateActivated() {
        if (this.mGraphicalEditor != null) {
            if (this.getEditor().getActivePage() == this.mGraphicalEditorIndex) {
                this.mGraphicalEditor.activated();
            } else {
                this.mGraphicalEditor.deactivated();
            }
        }
    }

    @Override
    public void delegateDeactivated() {
        if (this.mGraphicalEditor != null && this.getEditor().getActivePage() == this.mGraphicalEditorIndex) {
            this.mGraphicalEditor.deactivated();
        }
    }

    @Override
    public String delegateGetPartName() {
        String parentName;
        IFileEditorInput fileInput;
        IFile file;
        IContainer parent;
        IEditorInput editorInput = this.getEditor().getEditorInput();
        if (!AdtPrefs.getPrefs().isSharedLayoutEditor() && editorInput instanceof IFileEditorInput && (parent = (file = (fileInput = (IFileEditorInput)editorInput).getFile()).getParent()) != null && (parentName = parent.getName()).startsWith(LAYOUT_FOLDER_PREFIX)) {
            parentName = parentName.substring(LAYOUT_FOLDER_PREFIX.length());
            return String.valueOf(parentName) + File.separatorChar + file.getName();
        }
        return super.delegateGetPartName();
    }

    public boolean isGraphicalEditorActive() {
        IWorkbenchPartSite workbenchSite = this.getEditor().getSite();
        IWorkbenchPage workbenchPage = workbenchSite.getPage();
        if (workbenchPage.isPartVisible((IWorkbenchPart)this.getEditor()) && workbenchPage.getActiveEditor() == this.getEditor()) {
            return this.mGraphicalEditorIndex == this.getEditor().getActivePage();
        }
        return false;
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.mUiDocRootNode == null || force) {
            AndroidTargetData data = this.getEditor().getTargetData();
            Document doc = null;
            if (this.mUiDocRootNode != null) {
                doc = this.mUiDocRootNode.getXmlDocument();
            }
            DocumentDescriptor desc = data == null ? new DocumentDescriptor("temp", null) : data.getLayoutDescriptors().getDescriptor();
            this.mUiDocRootNode = (UiDocumentNode)desc.createUiNode();
            super.setUiRootNode(this.mUiDocRootNode);
            this.mUiDocRootNode.setEditor(this.getEditor());
            this.mUiDocRootNode.setUnknownDescriptorProvider(new IUnknownDescriptorProvider(){

                @Override
                public ElementDescriptor getDescriptor(String xmlLocalName) {
                    ElementDescriptor unknown = (ElementDescriptor)LayoutEditorDelegate.this.mUnknownDescriptorMap.get(xmlLocalName);
                    if (unknown == null) {
                        unknown = LayoutEditorDelegate.this.createUnknownDescriptor(xmlLocalName);
                        LayoutEditorDelegate.this.mUnknownDescriptorMap.put(xmlLocalName, unknown);
                    }
                    return unknown;
                }
            });
            this.onDescriptorsChanged(doc);
        }
    }

    private ViewElementDescriptor createUnknownDescriptor(String xmlLocalName) {
        ViewElementDescriptor desc = null;
        IEditorInput editorInput = this.getEditor().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            AndroidTargetData data;
            IAndroidTarget target;
            Sdk currentSdk;
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IProject project = fileInput.getFile().getProject();
            if (xmlLocalName.indexOf(46) != -1) {
                desc = CustomViewDescriptorService.getInstance().getDescriptor(project, xmlLocalName);
            }
            if (desc == null && (currentSdk = Sdk.getCurrent()) != null && (target = currentSdk.getTarget(project)) != null && (data = currentSdk.getTargetData(target)) != null) {
                ViewElementDescriptor viewDesc = data.getLayoutDescriptors().getBaseViewDescriptor();
                desc = new ViewElementDescriptor(xmlLocalName, xmlLocalName, xmlLocalName, null, null, viewDesc.getAttributes(), viewDesc.getLayoutAttributes(), null, false);
                desc.setSuperClass(viewDesc);
            }
        }
        if (desc == null) {
            desc = new ViewElementDescriptor(xmlLocalName, xmlLocalName);
        }
        return desc;
    }

    private void onDescriptorsChanged(Document document) {
        this.mUnknownDescriptorMap.clear();
        if (document != null) {
            this.mUiDocRootNode.loadFromXmlNode(document);
        } else {
            this.mUiDocRootNode.reloadFromXmlNode(this.mUiDocRootNode.getXmlDocument());
        }
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.onTargetChange();
            this.mGraphicalEditor.reloadPalette();
            this.mGraphicalEditor.getCanvasControl().syncPreviewMode();
        }
    }

    private void handleNewInput(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IFile file = fileInput.getFile();
            this.getEditor().setPartName(String.format("%1$s", file.getName()));
        }
    }

    public ViewElementDescriptor getFqcnViewDescriptor(String fqcn) {
        DocumentDescriptor docDesc;
        LayoutDescriptors layoutDesc;
        ViewElementDescriptor desc = null;
        AndroidTargetData data = this.getEditor().getTargetData();
        if (data != null && (layoutDesc = data.getLayoutDescriptors()) != null && (docDesc = layoutDesc.getDescriptor()) != null) {
            desc = this.internalFindFqcnViewDescriptor(fqcn, docDesc.getChildren(), null);
        }
        if (desc == null) {
            desc = this.createUnknownDescriptor(fqcn);
        }
        return desc;
    }

    private ViewElementDescriptor internalFindFqcnViewDescriptor(String fqcn, ElementDescriptor[] descriptors, Set<ElementDescriptor> visited) {
        if (visited == null) {
            visited = new HashSet<ElementDescriptor>();
        }
        if (descriptors != null) {
            ElementDescriptor[] elementDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor desc = elementDescriptorArray[n2];
                if (visited.add(desc)) {
                    if (desc instanceof ViewElementDescriptor && fqcn.equals(((ViewElementDescriptor)desc).getFullClassName())) {
                        return (ViewElementDescriptor)desc;
                    }
                    ViewElementDescriptor vd = this.internalFindFqcnViewDescriptor(fqcn, desc.getChildren(), visited);
                    if (vd != null) {
                        return vd;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public LayoutEditorDelegate createForFile(@NonNull CommonXmlEditor delegator, @Nullable ResourceFolderType type) {
            if (ResourceFolderType.LAYOUT == type) {
                return new LayoutEditorDelegate(delegator);
            }
            return null;
        }
    }

    private class LintJobListener
    extends JobChangeAdapter
    implements Runnable {
        private final GraphicalEditorPart mEditor;
        private final LayoutCanvas mCanvas;

        LintJobListener(GraphicalEditorPart editor) {
            this.mEditor = editor;
            this.mCanvas = editor.getCanvasControl();
        }

        public void done(IJobChangeEvent event) {
            LayoutActionBar bar = this.mEditor.getLayoutActionBar();
            if (!bar.isDisposed()) {
                bar.updateErrorIndicator();
            }
            if (!this.mCanvas.isDisposed()) {
                this.mCanvas.getDisplay().asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (!this.mCanvas.isDisposed()) {
                this.mCanvas.redraw();
                OutlinePage outlinePage = this.mCanvas.getOutlinePage();
                if (outlinePage != null) {
                    outlinePage.refreshIcons();
                }
            }
        }
    }
}

