/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.resources.ResourceHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

class ActivityMenuListener
extends SelectionAdapter {
    private static final int ACTION_OPEN_ACTIVITY = 1;
    private static final int ACTION_SELECT_ACTIVITY = 2;
    private final ConfigurationChooser mConfigChooser;
    private final int mAction;
    private final String mFqcn;

    ActivityMenuListener(@NonNull ConfigurationChooser configChooser, int action, @Nullable String fqcn) {
        this.mConfigChooser = configChooser;
        this.mAction = action;
        this.mFqcn = fqcn;
    }

    public void widgetSelected(SelectionEvent e) {
        switch (this.mAction) {
            case 1: {
                Configuration configuration = this.mConfigChooser.getConfiguration();
                String fqcn = configuration.getActivity();
                AdtPlugin.openJavaClass(this.mConfigChooser.getProject(), fqcn);
                break;
            }
            case 2: {
                this.mConfigChooser.selectActivity(this.mFqcn);
                this.mConfigChooser.onSelectActivity();
                break;
            }
            default: {
                assert (false) : this.mAction;
                break;
            }
        }
    }

    static void show(ConfigurationChooser chooser, ToolItem combo) {
        Menu menu = new Menu((Decorations)chooser.getShell(), 8);
        ISharedImages sharedImages = JavaUI.getSharedImages();
        Configuration configuration = chooser.getConfiguration();
        String current = configuration.getActivity();
        if (current != null) {
            MenuItem item = new MenuItem(menu, 8);
            String label = ConfigurationChooser.getActivityLabel(current, true);
            item.setText(String.format("Open %1$s...", label));
            Image image = sharedImages.getImage("org.eclipse.jdt.ui.jcu_obj.gif");
            item.setImage(image);
            item.addSelectionListener((SelectionListener)new ActivityMenuListener(chooser, 1, null));
            new MenuItem(menu, 2);
        }
        IProject project = chooser.getProject();
        Image image = sharedImages.getImage("org.eclipse.jdt.ui.class_obj.gif");
        String layoutName = ResourceHelper.getLayoutName(chooser.getEditedFile());
        String pkg = ManifestInfo.get(project).getPackage();
        List<String> preferred = ManifestInfo.guessActivities(project, layoutName, pkg);
        current = ActivityMenuListener.addActivities(chooser, menu, current, image, preferred);
        List<String> activities = ManifestInfo.getProjectActivities(project);
        if (preferred.size() > 0) {
            ArrayList<String> filtered = new ArrayList<String>(activities.size());
            HashSet<String> remove = new HashSet<String>(preferred);
            for (String fqcn : activities) {
                if (remove.contains(fqcn)) continue;
                filtered.add(fqcn);
            }
            activities = filtered;
        }
        if (activities.size() > 0) {
            if (preferred.size() > 0) {
                new MenuItem(menu, 2);
            }
            ActivityMenuListener.addActivities(chooser, menu, current, image, activities);
        }
        Rectangle bounds = combo.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = combo.getParent().toDisplay(location);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
    }

    private static String addActivities(ConfigurationChooser chooser, Menu menu, String current, Image image, List<String> activities) {
        for (String fqcn : activities) {
            String title = ConfigurationChooser.getActivityLabel(fqcn, false);
            MenuItem item = new MenuItem(menu, 32);
            item.setText(title);
            item.setImage(image);
            boolean selected = title.equals(current);
            if (selected) {
                item.setSelection(true);
                current = null;
            }
            item.addSelectionListener((SelectionListener)new ActivityMenuListener(chooser, 2, fqcn));
        }
        return current;
    }
}

