/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationDescription {
    private static final String TAG_PREVIEWS = "previews";
    private static final String TAG_PREVIEW = "preview";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_CONFIG = "config";
    private static final String ATTR_LOCALE = "locale";
    private static final String ATTR_ACTIVITY = "activity";
    private static final String ATTR_DEVICE = "device";
    private static final String ATTR_STATE = "devicestate";
    private static final String ATTR_UIMODE = "ui";
    private static final String ATTR_NIGHTMODE = "night";
    private static final String SEP_LOCALE = "-";
    public static final QualifiedName NAME_CONFIG_STATE = new QualifiedName("com.android.ide.eclipse.adt", "state");
    public final IProject project;
    public String displayName;
    public String theme;
    public IAndroidTarget target;
    public FolderConfiguration folder;
    public Locale locale = Locale.ANY;
    public Device device;
    public State state;
    public String activity;
    @NonNull
    public UiMode uiMode = UiMode.NORMAL;
    @NonNull
    public NightMode nightMode = NightMode.NOTNIGHT;

    private ConfigurationDescription(@Nullable IProject project) {
        this.project = project;
    }

    @Nullable
    public static String getDescription(@NonNull IFile file) {
        return AdtPlugin.getFileProperty(file, NAME_CONFIG_STATE);
    }

    public static void setDescription(@NonNull IFile file, @NonNull String description) {
        AdtPlugin.setFileProperty(file, NAME_CONFIG_STATE, description);
    }

    public static ConfigurationDescription fromConfiguration(@Nullable IProject project, @NonNull Configuration configuration) {
        ConfigurationDescription description = new ConfigurationDescription(project);
        description.displayName = configuration.getDisplayName();
        description.theme = configuration.getTheme();
        description.target = configuration.getTarget();
        description.folder = new FolderConfiguration();
        description.folder.set(configuration.getFullConfig());
        description.locale = configuration.getLocale();
        description.device = configuration.getDevice();
        description.state = configuration.getDeviceState();
        description.activity = configuration.getActivity();
        return description;
    }

    @Nullable
    public static ConfigurationDescription fromXml(@Nullable IProject project, @NonNull Element element, @NonNull Collection<Device> deviceList) {
        String nightModeString;
        String uiModeString;
        String deviceString;
        String activity;
        String localeString;
        String targetId;
        ConfigurationDescription description = new ConfigurationDescription(project);
        if (!TAG_PREVIEW.equals(element.getTagName())) {
            return null;
        }
        String displayName = element.getAttribute("name");
        if (!displayName.isEmpty()) {
            description.displayName = displayName;
        }
        String config = element.getAttribute(ATTR_CONFIG);
        Iterable segments = Splitter.on((char)'-').split((CharSequence)config);
        description.folder = FolderConfiguration.getConfig((Iterable)segments);
        String theme = element.getAttribute("theme");
        if (!theme.isEmpty()) {
            description.theme = theme;
        }
        if (!(targetId = element.getAttribute(ATTR_TARGET)).isEmpty()) {
            IAndroidTarget target;
            description.target = target = Configuration.stringToTarget(targetId);
        }
        if (!(localeString = element.getAttribute(ATTR_LOCALE)).isEmpty()) {
            LanguageQualifier language = Locale.ANY_LANGUAGE;
            RegionQualifier region = Locale.ANY_REGION;
            String[] locales = localeString.split(SEP_LOCALE);
            if (locales[0].length() > 0) {
                language = new LanguageQualifier(locales[0]);
            }
            if (locales.length > 1 && locales[1].length() > 0) {
                region = new RegionQualifier(locales[1]);
            }
            description.locale = Locale.create(language, region);
        }
        if ((activity = element.getAttribute(ATTR_ACTIVITY)).isEmpty()) {
            activity = null;
        }
        if (!(deviceString = element.getAttribute(ATTR_DEVICE)).isEmpty()) {
            for (Device d : deviceList) {
                if (!d.getName().equals(deviceString)) continue;
                description.device = d;
                String stateName = element.getAttribute(ATTR_STATE);
                if (stateName.isEmpty() || stateName.equals("null")) {
                    description.state = Configuration.getState(d, stateName);
                    break;
                }
                if (d.getAllStates().size() <= 0) break;
                description.state = (State)d.getAllStates().get(0);
                break;
            }
        }
        if (!(uiModeString = element.getAttribute(ATTR_UIMODE)).isEmpty()) {
            description.uiMode = UiMode.getEnum((String)uiModeString);
            if (description.uiMode == null) {
                description.uiMode = UiMode.NORMAL;
            }
        }
        if (!(nightModeString = element.getAttribute(ATTR_NIGHTMODE)).isEmpty()) {
            description.nightMode = NightMode.getEnum((String)nightModeString);
            if (description.nightMode == null) {
                description.nightMode = NightMode.NOTNIGHT;
            }
        }
        return description;
    }

    @NonNull
    public Element toXml(Document document) {
        Element parent;
        Element element = document.createElement(TAG_PREVIEW);
        element.setAttribute("name", this.displayName);
        FolderConfiguration fullConfig = this.folder;
        String folderName = fullConfig.getFolderName(ResourceFolderType.LAYOUT);
        element.setAttribute(ATTR_CONFIG, folderName);
        if (this.theme != null) {
            element.setAttribute("theme", this.theme);
        }
        if (this.target != null) {
            element.setAttribute(ATTR_TARGET, Configuration.targetToString(this.target));
        }
        if (this.locale != null && (this.locale.hasLanguage() || this.locale.hasRegion())) {
            String value = this.locale.hasRegion() ? String.valueOf(this.locale.language.getValue()) + SEP_LOCALE + this.locale.region.getValue() : this.locale.language.getValue();
            element.setAttribute(ATTR_LOCALE, value);
        }
        if (this.device != null) {
            element.setAttribute(ATTR_DEVICE, this.device.getName());
            if (this.state != null) {
                element.setAttribute(ATTR_STATE, this.state.getName());
            }
        }
        if (this.activity != null) {
            element.setAttribute(ATTR_ACTIVITY, this.activity);
        }
        if (this.uiMode != null && this.uiMode != UiMode.NORMAL) {
            element.setAttribute(ATTR_UIMODE, this.uiMode.getResourceValue());
        }
        if (this.nightMode != null && this.nightMode != NightMode.NOTNIGHT) {
            element.setAttribute(ATTR_NIGHTMODE, this.nightMode.getResourceValue());
        }
        if ((parent = document.getDocumentElement()) == null) {
            parent = document.createElement(TAG_PREVIEWS);
            document.appendChild(parent);
        }
        parent.appendChild(element);
        return element;
    }

    @Nullable
    String computePreferredTheme() {
        String defaultTheme;
        if (this.project == null) {
            return "Theme";
        }
        ManifestInfo manifest = ManifestInfo.get(this.project);
        ScreenSize screenSize = null;
        if (this.device != null) {
            List states = this.device.getAllStates();
            for (State s : states) {
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)s);
                if (folderConfig == null) continue;
                ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
                screenSize = qualifier.getValue();
                break;
            }
        }
        String preferred = defaultTheme = manifest.getDefaultTheme(this.target, screenSize);
        if (this.theme == null) {
            ManifestInfo.ActivityAttributes attributes;
            if (this.activity != null && (attributes = manifest.getActivityAttributes(this.activity)) != null) {
                preferred = attributes.getTheme();
            }
            if (preferred == null) {
                preferred = defaultTheme;
            }
            this.theme = preferred;
        }
        return preferred;
    }

    private void checkThemePrefix() {
        if (this.theme != null && !this.theme.startsWith("@")) {
            ResourceRepository resources;
            AndroidTargetData data;
            Sdk sdk;
            if (this.theme.isEmpty()) {
                this.computePreferredTheme();
                return;
            }
            if (this.target != null && (sdk = Sdk.getCurrent()) != null && (data = sdk.getTargetData(this.target)) != null && (resources = data.getFrameworkResources()) != null && resources.hasResourceItem("@android:style/" + this.theme)) {
                this.theme = "@android:style/" + this.theme;
                return;
            }
            this.theme = "@style/" + this.theme;
        }
    }
}

