/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.resources.Density;
import com.android.resources.NightMode;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.utils.Pair;
import com.android.utils.SparseIntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;

public class ConfigurationMatcher {
    private static final boolean PREFER_RECENT_RENDER_TARGETS = true;
    private final ConfigurationChooser mConfigChooser;
    private final Configuration mConfiguration;
    private final IFile mEditedFile;
    private final ProjectResources mResources;
    private final boolean mUpdateUi;

    ConfigurationMatcher(ConfigurationChooser chooser) {
        this(chooser, chooser.getConfiguration(), chooser.getEditedFile(), chooser.getResources(), true);
    }

    ConfigurationMatcher(@NonNull ConfigurationChooser chooser, @NonNull Configuration configuration, @Nullable IFile editedFile, @Nullable ProjectResources resources, boolean updateUi) {
        this.mConfigChooser = chooser;
        this.mConfiguration = configuration;
        this.mEditedFile = editedFile;
        this.mResources = resources;
        this.mUpdateUi = updateUi;
    }

    public boolean isCurrentFileBestMatchFor(FolderConfiguration config) {
        ResourceFile match = this.mResources.getMatchingFile(this.mEditedFile.getName(), ResourceType.LAYOUT, config);
        if (match != null) {
            return match.getFile().equals(this.mEditedFile);
        }
        AdtPlugin.log(4, "Current file is not a match for the given config.", new Object[0]);
        return false;
    }

    void adaptConfigSelection(boolean needBestMatch) {
        FolderConfiguration currentConfig;
        boolean needConfigChange = true;
        boolean currentConfigIsCompatible = false;
        State selectedState = this.mConfiguration.getDeviceState();
        FolderConfiguration editedConfig = this.mConfiguration.getEditedConfig();
        if (selectedState != null && (currentConfig = DeviceConfigHelper.getFolderConfig((State)selectedState)) != null && editedConfig.isMatchFor(currentConfig)) {
            currentConfigIsCompatible = true;
            if (!needBestMatch || this.isCurrentFileBestMatchFor(currentConfig)) {
                needConfigChange = false;
            }
        }
        if (needConfigChange) {
            List<Locale> localeList = this.mConfigChooser.getLocaleList();
            FolderConfiguration testConfig = new FolderConfiguration();
            State matchState = null;
            int localeIndex = -1;
            Device device = this.mConfiguration.getDevice();
            if (device != null) {
                block0: for (State state : device.getAllStates()) {
                    testConfig.set(DeviceConfigHelper.getFolderConfig((State)state));
                    int i = 0;
                    while (i < localeList.size()) {
                        Locale locale = localeList.get(i);
                        testConfig.setLanguageQualifier(locale.language);
                        testConfig.setRegionQualifier(locale.region);
                        if (editedConfig.isMatchFor(testConfig) && this.isCurrentFileBestMatchFor(testConfig)) {
                            matchState = state;
                            localeIndex = i;
                            break block0;
                        }
                        ++i;
                    }
                }
            }
            if (matchState != null) {
                this.mConfiguration.setDeviceState(matchState, true);
                Locale locale = localeList.get(localeIndex);
                this.mConfiguration.setLocale(locale, true);
                if (this.mUpdateUi) {
                    this.mConfigChooser.selectDeviceState(matchState);
                    this.mConfigChooser.selectLocale(locale);
                }
                this.mConfiguration.syncFolderConfig();
            } else {
                this.findAndSetCompatibleConfig(currentConfigIsCompatible);
            }
        }
    }

    void findAndSetCompatibleConfig(boolean favorCurrentConfig) {
        int max;
        int start;
        List<Locale> localeList = this.mConfigChooser.getLocaleList();
        Collection<Device> devices = this.mConfigChooser.getDevices();
        FolderConfiguration editedConfig = this.mConfiguration.getEditedConfig();
        FolderConfiguration currentConfig = this.mConfiguration.getFullConfig();
        ArrayList<ConfigMatch> anyMatches = new ArrayList<ConfigMatch>();
        ArrayList<ConfigMatch> bestMatches = new ArrayList<ConfigMatch>();
        int localeHostMatch = this.getLocaleMatch();
        ArrayList<ConfigBundle> configBundles = new ArrayList<ConfigBundle>(200);
        if (editedConfig.getLanguageQualifier() != null || localeHostMatch == -1) {
            start = 0;
            max = localeList.size();
        } else {
            start = localeHostMatch;
            max = localeHostMatch + 1;
        }
        int i = start;
        while (i < max) {
            Locale l = localeList.get(i);
            ConfigBundle bundle = new ConfigBundle(null, null);
            bundle.config.setLanguageQualifier(l.language);
            bundle.config.setRegionQualifier(l.region);
            bundle.localeIndex = i;
            configBundles.add(bundle);
            ++i;
        }
        this.addDockModeToBundles(configBundles);
        this.addNightModeToBundles(configBundles);
        this.addRenderTargetToBundles(configBundles);
        for (Device device : devices) {
            for (State state : device.getAllStates()) {
                FolderConfiguration stateConfig = DeviceConfigHelper.getFolderConfig((State)state);
                for (ConfigBundle bundle : configBundles) {
                    FolderConfiguration testConfig = new FolderConfiguration();
                    testConfig.set(stateConfig);
                    testConfig.add(bundle.config);
                    if (!editedConfig.isMatchFor(testConfig)) continue;
                    anyMatches.add(new ConfigMatch(testConfig, device, state, bundle));
                    if (!this.isCurrentFileBestMatchFor(testConfig)) continue;
                    bestMatches.add(new ConfigMatch(testConfig, device, state, bundle));
                }
            }
        }
        if (bestMatches.size() == 0) {
            if (favorCurrentConfig) {
                if (!editedConfig.isMatchFor(currentConfig)) {
                    AdtPlugin.log(4, "favorCurrentConfig can only be true if the current config is compatible", new Object[0]);
                }
                AdtPlugin.printErrorToConsole(this.mEditedFile.getProject(), new Object[]{String.format("'%1$s' is not a best match for any device/locale combination.", editedConfig.toDisplayString()), String.format("Displaying it with '%1$s'", currentConfig.toDisplayString())});
            } else if (anyMatches.size() > 0) {
                ConfigMatch match = this.selectConfigMatch(anyMatches);
                this.mConfiguration.setDevice(match.device, true);
                this.mConfiguration.setDeviceState(match.state, true);
                this.mConfiguration.setLocale(localeList.get(match.bundle.localeIndex), true);
                this.mConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex), true);
                this.mConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex), true);
                if (this.mUpdateUi) {
                    this.mConfigChooser.selectDevice(this.mConfiguration.getDevice());
                    this.mConfigChooser.selectDeviceState(this.mConfiguration.getDeviceState());
                    this.mConfigChooser.selectLocale(this.mConfiguration.getLocale());
                }
                this.mConfiguration.syncFolderConfig();
                AdtPlugin.printErrorToConsole(this.mEditedFile.getProject(), new Object[]{String.format("'%1$s' is not a best match for any device/locale combination.", editedConfig.toDisplayString()), String.format("Displaying it with '%1$s' which is compatible, but will actually be displayed with another more specific version of the layout.", currentConfig.toDisplayString())});
            }
        } else {
            ConfigMatch match = this.selectConfigMatch(bestMatches);
            this.mConfiguration.setDevice(match.device, true);
            this.mConfiguration.setDeviceState(match.state, true);
            this.mConfiguration.setLocale(localeList.get(match.bundle.localeIndex), true);
            this.mConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex), true);
            this.mConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex), true);
            this.mConfiguration.syncFolderConfig();
            if (this.mUpdateUi) {
                this.mConfigChooser.selectDevice(this.mConfiguration.getDevice());
                this.mConfigChooser.selectDeviceState(this.mConfiguration.getDeviceState());
                this.mConfigChooser.selectLocale(this.mConfiguration.getLocale());
            }
        }
    }

    private void addRenderTargetToBundles(List<ConfigBundle> configBundles) {
        IAndroidTarget target;
        Pair<Locale, IAndroidTarget> state = Configuration.loadRenderState(this.mConfigChooser);
        if (state != null && (target = (IAndroidTarget)state.getSecond()) != null) {
            int apiLevel = target.getVersion().getApiLevel();
            for (ConfigBundle bundle : configBundles) {
                bundle.config.setVersionQualifier(new VersionQualifier(apiLevel));
            }
        }
    }

    private void addDockModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle : addConfig) {
            int index = 0;
            UiMode[] uiModeArray = UiMode.values();
            int n = uiModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UiMode mode = uiModeArray[n2];
                ConfigBundle b = new ConfigBundle(bundle, null, null);
                b.config.setUiModeQualifier(new UiModeQualifier(mode));
                b.dockModeIndex = index++;
                list.add(b);
                ++n2;
            }
        }
        addConfig.clear();
        addConfig.addAll(list);
    }

    private void addNightModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle : addConfig) {
            int index = 0;
            NightMode[] nightModeArray = NightMode.values();
            int n = nightModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                NightMode mode = nightModeArray[n2];
                ConfigBundle b = new ConfigBundle(bundle, null, null);
                b.config.setNightModeQualifier(new NightModeQualifier(mode));
                b.nightModeIndex = index++;
                list.add(b);
                ++n2;
            }
        }
        addConfig.clear();
        addConfig.addAll(list);
    }

    private int getLocaleMatch() {
        java.util.Locale defaultLocale = java.util.Locale.getDefault();
        if (defaultLocale != null) {
            String currentLanguage = defaultLocale.getLanguage();
            String currentRegion = defaultLocale.getCountry();
            List<Locale> localeList = this.mConfigChooser.getLocaleList();
            int count = localeList.size();
            int l = 0;
            while (l < count) {
                Locale locale = localeList.get(l);
                LanguageQualifier langQ = locale.language;
                RegionQualifier regionQ = locale.region;
                if (langQ.getValue().equals(currentLanguage) && (regionQ.getValue().equals(currentRegion) || regionQ.getValue().equals("__"))) {
                    return l;
                }
                ++l;
            }
            return count - 1;
        }
        return -1;
    }

    private ConfigMatch selectConfigMatch(List<ConfigMatch> matches) {
        FolderConfiguration configuration;
        int apiLevel;
        IAndroidTarget projectTarget;
        Comparator<ConfigMatch> comparator = null;
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null && (projectTarget = sdk.getTarget(this.mEditedFile.getProject())) != null && (apiLevel = projectTarget.getVersion().getApiLevel()) >= 11 && apiLevel < 14) {
            comparator = new TabletConfigComparator();
        }
        if (comparator == null) {
            comparator = new PhoneConfigComparator();
        }
        Collections.sort(matches, comparator);
        IEditorPart activeEditor = AdtUtils.getActiveEditor();
        LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor(activeEditor);
        if (delegate != null && delegate.getEditor().getProject() == this.mEditedFile.getProject() && (configuration = delegate.getGraphicalEditor().getConfiguration()) != null) {
            for (ConfigMatch match : matches) {
                if (!configuration.equals((Object)match.testConfig)) continue;
                return match;
            }
        }
        return matches.get(0);
    }

    @Nullable
    static IAndroidTarget findDefaultRenderTarget(ConfigurationChooser chooser) {
        List<IAndroidTarget> targetList = chooser.getTargetList();
        if (!targetList.isEmpty()) {
            return targetList.get(targetList.size() - 1);
        }
        IProject project = chooser.getProject();
        Sdk current = Sdk.getCurrent();
        if (current != null) {
            IAndroidTarget projectTarget = current.getTarget(project);
            int minProjectApi = Integer.MAX_VALUE;
            if (projectTarget != null) {
                if (!projectTarget.isPlatform() && projectTarget.hasRenderingLibrary()) {
                    return projectTarget;
                }
                if (projectTarget.getVersion().isPreview() && projectTarget.hasRenderingLibrary()) {
                    return projectTarget;
                }
                minProjectApi = projectTarget.getVersion().getApiLevel();
            }
            IAndroidTarget best = null;
            int bestApiLevel = Integer.MAX_VALUE;
            IAndroidTarget[] iAndroidTargetArray = current.getTargets();
            int n = iAndroidTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                String property;
                int apiLevel;
                IAndroidTarget target = iAndroidTargetArray[n2];
                if (target.isPlatform() && (apiLevel = target.getVersion().getApiLevel()) >= minProjectApi && ((property = target.getProperty("Layoutlib.Api")) != null || apiLevel >= 11) && apiLevel < bestApiLevel) {
                    bestApiLevel = apiLevel;
                    best = target;
                }
                ++n2;
            }
            return best;
        }
        return null;
    }

    @Nullable
    static String getClosestMatch(@NonNull FolderConfiguration oldConfig, @NonNull List<State> states) {
        ArrayList<Object> list1 = new ArrayList<Object>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count = FolderConfiguration.getQualifierCount();
        int i = 0;
        while (i < count) {
            for (State state : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)state);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(state);
                    continue;
                }
                if (!oldQualifier.equals((Object)newQualifier)) continue;
                list2.add(state);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.size() != 0) {
                list1.clear();
                list1.addAll(list2);
                list2.clear();
            }
            ++i;
        }
        if (list1.size() > 0) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    @Nullable
    public static IFile getBestFileMatch(ConfigurationChooser chooser) {
        FolderConfiguration config;
        ResourceManager manager = ResourceManager.getInstance();
        ProjectResources resources = manager.getProjectResources(chooser.getProject());
        if (resources == null) {
            return null;
        }
        IFile editedFile = chooser.getEditedFile();
        if (editedFile == null) {
            return null;
        }
        String name = editedFile.getName();
        ResourceFile match = resources.getMatchingFile(name, ResourceType.LAYOUT, config = chooser.getConfiguration().getFullConfig());
        if (match != null) {
            return ((IFileWrapper)match.getFile()).getIFile();
        }
        return null;
    }

    private static class ConfigBundle {
        private final FolderConfiguration config = new FolderConfiguration();
        private int localeIndex;
        private int dockModeIndex;
        private int nightModeIndex;

        private ConfigBundle() {
        }

        private ConfigBundle(ConfigBundle bundle) {
            this.config.set(bundle.config);
            this.localeIndex = bundle.localeIndex;
            this.dockModeIndex = bundle.dockModeIndex;
            this.nightModeIndex = bundle.nightModeIndex;
        }

        /* synthetic */ ConfigBundle(ConfigBundle configBundle, ConfigBundle configBundle2) {
            this();
        }

        /* synthetic */ ConfigBundle(ConfigBundle configBundle, ConfigBundle configBundle2, ConfigBundle configBundle3) {
            this(configBundle);
        }
    }

    private static class ConfigMatch {
        final FolderConfiguration testConfig;
        final Device device;
        final State state;
        final ConfigBundle bundle;

        public ConfigMatch(@NonNull FolderConfiguration testConfig, @NonNull Device device, @NonNull State state, @NonNull ConfigBundle bundle) {
            this.testConfig = testConfig;
            this.device = device;
            this.state = state;
            this.bundle = bundle;
        }

        public String toString() {
            return String.valueOf(this.device.getName()) + " - " + this.state.getName();
        }
    }

    private static class PhoneConfigComparator
    implements Comparator<ConfigMatch> {
        private SparseIntArray mDensitySort = new SparseIntArray(4);

        public PhoneConfigComparator() {
            this.mDensitySort.put(Density.HIGH.getDpiValue(), 1);
            this.mDensitySort.put(Density.MEDIUM.getDpiValue(), 2);
            this.mDensitySort.put(Density.XHIGH.getDpiValue(), 3);
            this.mDensitySort.put(Density.LOW.getDpiValue(), 4);
        }

        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 == null) {
                    return 0;
                }
                return -1;
            }
            if (config2 == null) {
                return 1;
            }
            int dpi1 = 160;
            int dpi2 = 160;
            DensityQualifier dpiQualifier1 = config1.getDensityQualifier();
            if (dpiQualifier1 != null) {
                Density value = dpiQualifier1.getValue();
                dpi1 = value != null ? value.getDpiValue() : 160;
            }
            dpi1 = this.mDensitySort.get(dpi1, 100);
            DensityQualifier dpiQualifier2 = config2.getDensityQualifier();
            if (dpiQualifier2 != null) {
                Density value = dpiQualifier2.getValue();
                int n = dpi2 = value != null ? value.getDpiValue() : 160;
            }
            if (dpi1 == (dpi2 = this.mDensitySort.get(dpi2, 100))) {
                ScreenOrientation so1 = ScreenOrientation.PORTRAIT;
                ScreenOrientationQualifier orientationQualifier1 = config1.getScreenOrientationQualifier();
                if (orientationQualifier1 != null && (so1 = orientationQualifier1.getValue()) == null) {
                    so1 = ScreenOrientation.PORTRAIT;
                }
                ScreenOrientation so2 = ScreenOrientation.PORTRAIT;
                ScreenOrientationQualifier orientationQualifier2 = config2.getScreenOrientationQualifier();
                if (orientationQualifier2 != null && (so2 = orientationQualifier2.getValue()) == null) {
                    so2 = ScreenOrientation.PORTRAIT;
                }
                if (so1 == ScreenOrientation.PORTRAIT) {
                    if (so2 == ScreenOrientation.PORTRAIT) {
                        return 0;
                    }
                    return -1;
                }
                if (so2 == ScreenOrientation.PORTRAIT) {
                    return 1;
                }
                return 0;
            }
            return dpi1 - dpi2;
        }
    }

    private static class TabletConfigComparator
    implements Comparator<ConfigMatch> {
        private TabletConfigComparator() {
        }

        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            ScreenSize ss2;
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 == null) {
                    return 0;
                }
                return -1;
            }
            if (config2 == null) {
                return 1;
            }
            ScreenSizeQualifier size1 = config1.getScreenSizeQualifier();
            ScreenSizeQualifier size2 = config2.getScreenSizeQualifier();
            ScreenSize ss1 = size1 != null ? size1.getValue() : ScreenSize.NORMAL;
            ScreenSize screenSize = ss2 = size2 != null ? size2.getValue() : ScreenSize.NORMAL;
            if (ss1 == ScreenSize.XLARGE) {
                if (ss2 == ScreenSize.XLARGE) {
                    ScreenOrientationQualifier orientation2;
                    ScreenOrientation so2;
                    ScreenOrientationQualifier orientation1 = config1.getScreenOrientationQualifier();
                    ScreenOrientation so1 = orientation1.getValue();
                    if (so1 == null) {
                        so1 = ScreenOrientation.PORTRAIT;
                    }
                    if ((so2 = (orientation2 = config2.getScreenOrientationQualifier()).getValue()) == null) {
                        so2 = ScreenOrientation.PORTRAIT;
                    }
                    if (so1 == ScreenOrientation.LANDSCAPE) {
                        if (so2 == ScreenOrientation.LANDSCAPE) {
                            return 0;
                        }
                        return -1;
                    }
                    if (so2 == ScreenOrientation.LANDSCAPE) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            if (ss2 == ScreenSize.XLARGE) {
                return 1;
            }
            return 0;
        }
    }
}

