/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.NestedConfiguration;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.resources.Density;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import java.util.Collection;
import java.util.List;

public class VaryingConfiguration
extends NestedConfiguration {
    private int mVariation;
    private int mVariationCount;
    private int mAlternate;
    private Device mPrevParentDevice;
    private Device mPrevDevice;

    private VaryingConfiguration(@NonNull ConfigurationChooser chooser, @NonNull Configuration configuration) {
        super(chooser, configuration);
    }

    @NonNull
    public static VaryingConfiguration create(@NonNull ConfigurationChooser chooser, @NonNull Configuration parent) {
        return new VaryingConfiguration(chooser, parent);
    }

    @NonNull
    public static VaryingConfiguration create(@NonNull VaryingConfiguration other, @NonNull Configuration parent) {
        VaryingConfiguration configuration = new VaryingConfiguration(other.mConfigChooser, parent);
        VaryingConfiguration.initFrom(configuration, other, other, false);
        configuration.mAlternate = other.mAlternate;
        configuration.mVariation = other.mVariation;
        configuration.mVariationCount = other.mVariationCount;
        configuration.syncFolderConfig();
        return configuration;
    }

    public int getAlternateFlags() {
        return this.mAlternate;
    }

    @Override
    public void syncFolderConfig() {
        super.syncFolderConfig();
        this.updateDisplayName();
    }

    public void setVariation(int variation) {
        this.mVariation = variation;
        this.mVariationCount = Math.max(this.mVariationCount, variation + 1);
    }

    public void setVariationCount(int count) {
        this.mVariationCount = count;
    }

    public void updateDisplayName() {
        this.setDisplayName(this.computeDisplayName());
    }

    @Override
    @NonNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            return super.getLocale();
        }
        Locale locale = this.mParent.getLocale();
        if (this.isAlternatingLocale() && locale != null) {
            List<Locale> locales = this.mConfigChooser.getLocaleList();
            for (Locale l : locales) {
                if (l.equals(locale)) continue;
                locale = l;
                break;
            }
        }
        return locale;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        List<IAndroidTarget> targets;
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        IAndroidTarget target = this.mParent.getTarget();
        if (this.isAlternatingTarget() && target != null && !(targets = this.mConfigChooser.getTargetList()).isEmpty()) {
            IAndroidTarget mostRecent = targets.get(targets.size() - 1);
            if (target.equals(mostRecent)) {
                ManifestInfo info = ManifestInfo.get(this.mConfigChooser.getProject());
                int minSdkVersion = info.getMinSdkVersion();
                for (IAndroidTarget t : targets) {
                    if (t.getVersion().getApiLevel() < minSdkVersion) continue;
                    target = t;
                    break;
                }
            } else {
                target = mostRecent;
            }
        }
        return target;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        Device device = this.mParent.getDevice();
        if (this.isAlternatingDevice() && device != null) {
            if (device == this.mPrevParentDevice) {
                return this.mPrevDevice;
            }
            this.mPrevParentDevice = device;
            Collection<Device> devices = this.mConfigChooser.getDevices();
            double smallest = 100.0;
            double biggest = 1.0;
            for (Device d : devices) {
                double size = VaryingConfiguration.getScreenSize(d);
                if (size < 0.0) continue;
                if (size >= biggest) {
                    biggest = size;
                }
                if (!(size <= smallest)) continue;
                smallest = size;
            }
            int bucketCount = this.mVariationCount + 1;
            double inchesPerBucket = (biggest - smallest) / (double)bucketCount;
            double overriddenSize = VaryingConfiguration.getScreenSize(device);
            int overriddenBucket = (int)((overriddenSize - smallest) / inchesPerBucket);
            int bucket = this.mVariation < overriddenBucket ? this.mVariation : this.mVariation + 1;
            double from = inchesPerBucket * (double)bucket + smallest;
            double to = from + inchesPerBucket;
            if (biggest - to < 0.1) {
                to = biggest + 0.1;
            }
            boolean canScaleNinePatch = this.supports(Capability.FIXED_SCALABLE_NINE_PATCH);
            for (Device d : devices) {
                Density density;
                double size = VaryingConfiguration.getScreenSize(d);
                if (!(size >= from) || !(size < to) || !canScaleNinePatch && ((density = VaryingConfiguration.getDensity(d)) == Density.TV || density == Density.LOW)) continue;
                device = d;
                break;
            }
            this.mPrevDevice = device;
        }
        return device;
    }

    @Nullable
    private static Density getDensity(@NonNull Device device) {
        Screen screen;
        Hardware hardware = device.getDefaultHardware();
        if (hardware != null && (screen = hardware.getScreen()) != null) {
            return screen.getPixelDensity();
        }
        return null;
    }

    private static double getScreenSize(@NonNull Device device) {
        Screen screen;
        Hardware hardware = device.getDefaultHardware();
        if (hardware != null && (screen = hardware.getScreen()) != null) {
            return screen.getDiagonalLength();
        }
        return -1.0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state = this.mParent.getDeviceState();
        if (this.isAlternatingDeviceState() && state != null) {
            State alternate = this.getNextDeviceState(state);
            return alternate;
        }
        if ((this.isAlternatingDevice() || this.isOverridingDevice()) && state != null && (device = this.getDevice()) != null) {
            return device.getState(state.getName());
        }
        return state;
    }

    @Override
    @NonNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            return super.getNightMode();
        }
        NightMode nightMode = this.mParent.getNightMode();
        if (this.isAlternatingNightMode() && nightMode != null) {
            nightMode = nightMode == NightMode.NIGHT ? NightMode.NOTNIGHT : NightMode.NIGHT;
            return nightMode;
        }
        return nightMode;
    }

    @Override
    @NonNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            return super.getUiMode();
        }
        UiMode uiMode = this.mParent.getUiMode();
        if (this.isAlternatingUiMode() && uiMode != null) {
            UiMode[] values = UiMode.values();
            uiMode = values[(uiMode.ordinal() + 1) % values.length];
            return uiMode;
        }
        return uiMode;
    }

    @Override
    @Nullable
    public String computeDisplayName() {
        return VaryingConfiguration.computeDisplayName(this.getOverrideFlags() | this.mAlternate, this);
    }

    public void setAlternateLocale(boolean alternate) {
        this.mAlternate |= 0x10;
    }

    public final boolean isAlternatingLocale() {
        return (this.mAlternate & 0x10) != 0;
    }

    public void setAlternateTarget(boolean alternate) {
        this.mAlternate |= 0x20;
    }

    public final boolean isAlternatingTarget() {
        return (this.mAlternate & 0x20) != 0;
    }

    public void setAlternateDevice(boolean alternate) {
        this.mAlternate |= 2;
    }

    public final boolean isAlternatingDevice() {
        return (this.mAlternate & 2) != 0;
    }

    public void setAlternateDeviceState(boolean alternate) {
        this.mAlternate |= 4;
    }

    public final boolean isAlternatingDeviceState() {
        return (this.mAlternate & 4) != 0;
    }

    public void setAlternateNightMode(boolean alternate) {
        this.mAlternate |= 0x40;
    }

    public final boolean isAlternatingNightMode() {
        return (this.mAlternate & 0x40) != 0;
    }

    public void setAlternateUiMode(boolean alternate) {
        this.mAlternate |= 0x80;
    }

    public final boolean isAlternatingUiMode() {
        return (this.mAlternate & 0x80) != 0;
    }

    public static /* bridge */ /* synthetic */ NestedConfiguration create(ConfigurationChooser configurationChooser, Configuration configuration) {
        return VaryingConfiguration.create(configurationChooser, configuration);
    }
}

