/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class AccordionControl
extends Composite {
    private static final int HEADER_SPACING = 0;
    private static final int ITEM_SPACING = 0;
    private static final String KEY_CONTENT = "content";
    private static final String KEY_HEADER = "header";
    private Image mClosed;
    private Image mOpen;
    private boolean mSingle = true;
    private boolean mWrap;

    protected Composite createChildContainer(Composite parent, Object header, int style) {
        Composite composite = new Composite(parent, style);
        if (this.mWrap) {
            RowLayout layout = new RowLayout(256);
            layout.center = true;
            composite.setLayout((Layout)layout);
        } else {
            RowLayout layout = new RowLayout(512);
            layout.spacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginRight = 0;
            layout.marginBottom = 0;
            composite.setLayout((Layout)layout);
        }
        return composite;
    }

    protected abstract void createChildren(Composite var1, Object var2);

    public void setAutoClose(boolean single) {
        this.mSingle = single;
    }

    public boolean isAutoClose() {
        return this.mSingle;
    }

    public List<CLabel> getHeaderLabels() {
        ArrayList<CLabel> headers = new ArrayList<CLabel>();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof CLabel) {
                headers.add((CLabel)c);
            }
            ++n2;
        }
        return headers;
    }

    public void expandAll(boolean performLayout) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof CLabel && !this.isOpen(c)) {
                this.toggle((CLabel)c, false, false);
            }
            ++n2;
        }
        if (performLayout) {
            this.pack();
            this.layout();
        }
    }

    public void collapseAll(boolean performLayout) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof CLabel && this.isOpen(c)) {
                this.toggle((CLabel)c, false, false);
            }
            ++n2;
        }
        if (performLayout) {
            this.layout();
        }
    }

    public AccordionControl(Composite parent, int style, List<?> headers, boolean greedy, boolean wrapChildren, Set<String> expand) {
        super(parent, style);
        this.mWrap = wrapChildren;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Font labelFont = null;
        this.mOpen = IconFactory.getInstance().getIcon("open-folder");
        this.mClosed = IconFactory.getInstance().getIcon("closed-folder");
        ArrayList<CLabel> expandLabels = new ArrayList<CLabel>();
        for (Object header : headers) {
            final CLabel label = new CLabel((Composite)this, 8);
            label.setText(header.toString().replace("&", "&&"));
            this.updateBackground(label, false);
            if (labelFont == null) {
                labelFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            label.setFont(labelFont);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.setHeader(header, label);
            label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1 && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                        AccordionControl.this.toggle(label, true, AccordionControl.this.mSingle);
                    }
                }
            });
            label.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    AccordionControl.this.updateBackground(label, true);
                }

                public void mouseExit(MouseEvent e) {
                    AccordionControl.this.updateBackground(label, false);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            final ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 512);
            ScrollBar verticalBar = scrolledComposite.getVerticalBar();
            verticalBar.setIncrement(20);
            verticalBar.setPageIncrement(100);
            this.setContentArea(label, scrolledComposite);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            GridData scrollGridData = new GridData(4, greedy ? 4 : 128, false, greedy, 1, 1);
            scrollGridData.exclude = true;
            scrollGridData.grabExcessHorizontalSpace = wrapChildren;
            scrolledComposite.setLayoutData((Object)scrollGridData);
            if (wrapChildren) {
                scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        Rectangle r = scrolledComposite.getClientArea();
                        Control content = scrolledComposite.getContent();
                        if (content != null && r != null) {
                            Point minSize = content.computeSize(r.width, -1);
                            scrolledComposite.setMinSize(minSize);
                            ScrollBar vBar = scrolledComposite.getVerticalBar();
                            vBar.setPageIncrement(r.height);
                        }
                    }
                });
            }
            this.updateIcon(label);
            if (expand == null || !expand.contains(label.getText())) continue;
            expandLabels.add(label);
        }
        for (CLabel label : expandLabels) {
            this.toggle(label, false, false);
        }
    }

    private void updateBackground(CLabel label, boolean mouseOver) {
        Display display = label.getDisplay();
        label.setBackground(new Color[]{display.getSystemColor(20), display.getSystemColor(22), display.getSystemColor(19)}, new int[]{mouseOver ? 60 : 40, 100}, true);
    }

    private void updateIcon(CLabel label) {
        label.setImage(this.isOpen((Control)label) ? this.mOpen : this.mClosed);
    }

    private boolean isOpen(Control label) {
        return !((GridData)this.getContentArea((Control)label).getLayoutData()).exclude;
    }

    private void toggle(CLabel label, boolean performLayout, boolean autoClose) {
        boolean close;
        if (autoClose) {
            this.collapseAll(true);
        }
        ScrolledComposite scrolledComposite = this.getContentArea((Control)label);
        GridData scrollGridData = (GridData)scrolledComposite.getLayoutData();
        scrollGridData.exclude = close = !scrollGridData.exclude;
        scrolledComposite.setVisible(!close);
        this.updateIcon(label);
        if (!scrollGridData.exclude && scrolledComposite.getContent() == null) {
            Object header = this.getHeader((Control)label);
            Composite composite = this.createChildContainer((Composite)scrolledComposite, header, 0);
            this.createChildren(composite, header);
            while (composite.getParent() != scrolledComposite) {
                composite = composite.getParent();
            }
            scrolledComposite.setContent((Control)composite);
            scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        }
        if (performLayout) {
            this.layout(true);
        }
    }

    private Object getHeader(Control label) {
        return label.getData(KEY_HEADER);
    }

    private void setHeader(Object header, CLabel label) {
        label.setData(KEY_HEADER, header);
    }

    private ScrolledComposite getContentArea(Control label) {
        return (ScrolledComposite)label.getData(KEY_CONTENT);
    }

    private void setContentArea(CLabel label, ScrolledComposite scrolledComposite) {
        label.setData(KEY_CONTENT, (Object)scrolledComposite);
    }

    protected void checkSubclass() {
    }

    public Set<String> getExpandedCategories() {
        HashSet<String> expanded = new HashSet<String>();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof CLabel && this.isOpen(c)) {
                expanded.add(((CLabel)c).getText());
            }
            ++n2;
        }
        return expanded;
    }
}

