/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.swt.widgets.Display;

public class CustomViewFinder {
    private static final QualifiedName CUSTOM_VIEW_FINDER = new QualifiedName("com.android.ide.eclipse.adt", "viewfinder");
    private final IProject mProject;
    private final List<Listener> mListeners = new ArrayList<Listener>();
    private List<String> mCustomViews;
    private List<String> mThirdPartyViews;
    private boolean mRefreshing;

    private CustomViewFinder(IProject project) {
        this.mProject = project;
    }

    public static CustomViewFinder get(IProject project) {
        CustomViewFinder finder = null;
        try {
            finder = (CustomViewFinder)project.getSessionProperty(CUSTOM_VIEW_FINDER);
        }
        catch (CoreException coreException) {}
        if (finder == null) {
            finder = new CustomViewFinder(project);
            try {
                project.setSessionProperty(CUSTOM_VIEW_FINDER, (Object)finder);
            }
            catch (CoreException e) {
                AdtPlugin.log(e, "Can't store CustomViewFinder", new Object[0]);
            }
        }
        return finder;
    }

    public void refresh() {
        this.refresh(null, true);
    }

    public void refresh(Listener listener) {
        this.refresh(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(Listener listener, boolean sync) {
        CustomViewFinder customViewFinder;
        if (listener != null) {
            customViewFinder = this;
            synchronized (customViewFinder) {
                this.mListeners.add(listener);
            }
        }
        customViewFinder = this;
        synchronized (customViewFinder) {
            if (listener != null) {
                this.mListeners.add(listener);
            }
            if (this.mRefreshing) {
                return;
            }
            this.mRefreshing = true;
        }
        FindViewsJob job = new FindViewsJob();
        job.schedule();
        if (sync) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
    }

    public Collection<String> getCustomViews() {
        return this.mCustomViews == null ? null : Collections.unmodifiableCollection(this.mCustomViews);
    }

    public Collection<String> getThirdPartyViews() {
        return this.mThirdPartyViews == null ? null : Collections.unmodifiableCollection(this.mThirdPartyViews);
    }

    public Collection<String> getAllViews() {
        if (this.mCustomViews == null) {
            return null;
        }
        ArrayList<String> all = new ArrayList<String>(this.mCustomViews.size() + this.mThirdPartyViews.size());
        all.addAll(this.mCustomViews);
        all.addAll(this.mThirdPartyViews);
        return all;
    }

    public static Pair<List<String>, List<String>> findViews(IProject project, boolean layoutsOnly) {
        CustomViewFinder finder = CustomViewFinder.get(project);
        return finder.findViews(layoutsOnly);
    }

    private Pair<List<String>, List<String>> findViews(final boolean layoutsOnly) {
        final HashSet customViews = new HashSet();
        final HashSet thirdPartyViews = new HashSet();
        ProjectState state = Sdk.getProjectState(this.mProject);
        final List<Object> libraries = state != null ? state.getFullLibraryProjects() : Collections.emptyList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.isInsideDocComment()) {
                    return;
                }
                Object element = match.getElement();
                if (element instanceof ResolvedBinaryType) {
                    ResolvedBinaryType type = (ResolvedBinaryType)element;
                    IPackageFragment fragment = type.getPackageFragment();
                    IPath path = fragment.getPath();
                    String last = path.lastSegment();
                    if (last.equals("android.jar")) {
                        return;
                    }
                    if (!CustomViewFinder.isValidView((IType)type, layoutsOnly)) {
                        return;
                    }
                    IProject matchProject = match.getResource().getProject();
                    if (CustomViewFinder.this.mProject == matchProject || libraries.contains(matchProject)) {
                        String fqn = type.getFullyQualifiedName();
                        thirdPartyViews.add(fqn);
                    }
                } else if (element instanceof ResolvedSourceType) {
                    IProject matchProject = match.getResource().getProject();
                    if (CustomViewFinder.this.mProject == matchProject || libraries.contains(matchProject)) {
                        ResolvedSourceType type = (ResolvedSourceType)element;
                        if (!CustomViewFinder.isValidView((IType)type, layoutsOnly)) {
                            return;
                        }
                        String fqn = type.getFullyQualifiedName();
                        fqn = fqn.replace('$', '.');
                        customViews.add(fqn);
                    }
                }
            }
        };
        try {
            String className;
            IType viewType;
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(this.mProject);
            if (javaProject != null && (viewType = javaProject.findType(className = layoutsOnly ? "android.view.ViewGroup" : "android.view.View")) != null) {
                IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)viewType);
                SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                int matchRule = 10;
                SearchPattern pattern = SearchPattern.createPattern((String)"*", (int)5, (int)1, (int)matchRule);
                SearchEngine engine = new SearchEngine();
                engine.search(pattern, participants, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        ArrayList<String> custom = new ArrayList<String>(customViews);
        ArrayList<String> thirdParty = new ArrayList<String>(thirdPartyViews);
        if (!layoutsOnly) {
            this.mCustomViews = custom;
            this.mThirdPartyViews = thirdParty;
        }
        return Pair.of(custom, thirdParty);
    }

    private static boolean isValidView(IType type, boolean layoutsOnly) throws JavaModelException {
        if (type.isAnonymous()) {
            return false;
        }
        int flags = type.getFlags();
        if (Flags.isAbstract((int)flags) || !Flags.isPublic((int)flags)) {
            return false;
        }
        String typeName = type.getElementName();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String first;
            String[] parameterTypes;
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(typeName) && (parameterTypes = method.getParameterTypes()) != null && parameterTypes.length >= 1 && parameterTypes.length <= 3 && ((first = parameterTypes[0]).equals("QContext;") || first.equals("Qandroid.content.Context;"))) {
                if (parameterTypes.length == 1) {
                    return true;
                }
                String second = parameterTypes[1];
                if (second.equals("QAttributeSet;") || second.equals("Qandroid.util.AttributeSet;")) {
                    if (parameterTypes.length == 2) {
                        return true;
                    }
                    String third = parameterTypes[2];
                    if (third.equals("I") && parameterTypes.length == 3) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    private class FindViewsJob
    extends Job {
        FindViewsJob() {
            super("Find Custom Views");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Pair views = CustomViewFinder.this.findViews(false);
            CustomViewFinder.this.mCustomViews = (List)views.getFirst();
            CustomViewFinder.this.mThirdPartyViews = (List)views.getSecond();
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Collection<String> customViews = Collections.unmodifiableCollection(CustomViewFinder.this.mCustomViews);
                    Collection<String> thirdPartyViews = Collections.unmodifiableCollection(CustomViewFinder.this.mThirdPartyViews);
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        for (Listener l : CustomViewFinder.this.mListeners) {
                            l.viewsUpdated(customViews, thirdPartyViews);
                        }
                        CustomViewFinder.this.mListeners.clear();
                        CustomViewFinder.this.mRefreshing = false;
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    public static interface Listener {
        public void viewsUpdated(Collection<String> var1, Collection<String> var2);
    }
}

