/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.INode;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ControlPoint;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutPoint;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ViewHierarchy {
    private static final boolean DUMP_INFO = false;
    private LayoutCanvas mCanvas;
    private CanvasViewInfo mLastValidViewInfoRoot;
    private boolean mIsResultValid;
    private final List<CanvasViewInfo> mInvisibleParents = new ArrayList<CanvasViewInfo>();
    private final List<CanvasViewInfo> mInvisibleParentsReadOnly = Collections.unmodifiableList(this.mInvisibleParents);
    private boolean mExplodedParents;
    private List<Rectangle> mIncludedBounds;
    private RenderSession mSession;
    private Map<UiViewElementNode, CanvasViewInfo> mNodeToView = Collections.emptyMap();
    private Map<Node, CanvasViewInfo> mDomNodeToView = Collections.emptyMap();

    public ViewHierarchy(LayoutCanvas canvas) {
        this.mCanvas = canvas;
    }

    public void dispose() {
        if (this.mSession != null) {
            this.mSession.dispose();
            this.mSession = null;
        }
    }

    void setSession(RenderSession session, Set<UiElementNode> explodedNodes, boolean layoutlib5) {
        if (this.mSession != null) {
            this.mSession.dispose();
        }
        this.mSession = session;
        this.mIsResultValid = session != null && session.getResult().isSuccess();
        this.mExplodedParents = false;
        this.mNodeToView = new HashMap<UiViewElementNode, CanvasViewInfo>(50);
        if (this.mIsResultValid && session != null) {
            ViewInfo mergeRoot;
            List rootList = session.getRootViews();
            Object infos = null;
            if (rootList == null || rootList.size() == 0) {
                if (this.hasMergeRoot()) {
                    mergeRoot = this.createMergeInfo(session);
                    infos = CanvasViewInfo.create(mergeRoot, layoutlib5);
                } else {
                    infos = null;
                }
            } else if (rootList.size() > 1 && this.hasMergeRoot()) {
                mergeRoot = this.createMergeInfo(session);
                mergeRoot.setChildren(rootList);
                infos = CanvasViewInfo.create(mergeRoot, layoutlib5);
            } else {
                ViewInfo root = (ViewInfo)rootList.get(0);
                infos = root != null ? CanvasViewInfo.create(root, layoutlib5) : null;
            }
            if (infos != null) {
                GraphicalEditorPart editor;
                this.mLastValidViewInfoRoot = (CanvasViewInfo)infos.getFirst();
                this.mIncludedBounds = (List)infos.getSecond();
                if (this.mLastValidViewInfoRoot.getUiViewNode() == null && this.mLastValidViewInfoRoot.getChildren().isEmpty() && (editor = this.mCanvas.getEditorDelegate().getGraphicalEditor()).getIncludedWithin() != null) {
                    editor.showIn(null);
                    return;
                }
            } else {
                this.mLastValidViewInfoRoot = null;
                this.mIncludedBounds = null;
            }
            this.updateNodeProxies(this.mLastValidViewInfoRoot);
            this.mExplodedParents = false;
            this.mInvisibleParents.clear();
            this.addInvisibleParents(this.mLastValidViewInfoRoot, explodedNodes);
            this.mDomNodeToView = new HashMap<Node, CanvasViewInfo>(this.mNodeToView.size());
            for (Map.Entry<UiViewElementNode, CanvasViewInfo> entry : this.mNodeToView.entrySet()) {
                this.mDomNodeToView.put(entry.getKey().getXmlNode(), entry.getValue());
            }
            this.mCanvas.getSelectionManager().sync();
        } else {
            this.mIncludedBounds = null;
            this.mInvisibleParents.clear();
            this.mDomNodeToView = Collections.emptyMap();
        }
    }

    private ViewInfo createMergeInfo(RenderSession session) {
        BufferedImage image = session.getImage();
        ControlPoint imageSize = ControlPoint.create(this.mCanvas, this.mCanvas.getHorizontalTransform().getMargin() + image.getWidth(), this.mCanvas.getVerticalTransform().getMargin() + image.getHeight());
        LayoutPoint layoutSize = imageSize.toLayout();
        UiDocumentNode model = this.mCanvas.getEditorDelegate().getUiRootNode();
        List<UiElementNode> children = model.getUiChildren();
        return new ViewInfo("merge", (Object)children.get(0), 0, 0, layoutSize.x, layoutSize.y);
    }

    private boolean hasMergeRoot() {
        List<UiElementNode> children;
        UiDocumentNode model = this.mCanvas.getEditorDelegate().getUiRootNode();
        return model != null && (children = model.getUiChildren()) != null && children.size() > 0 && "merge".equals(children.get(0).getDescriptor().getXmlName());
    }

    private void updateNodeProxies(CanvasViewInfo vi) {
        if (vi == null) {
            return;
        }
        UiViewElementNode key = vi.getUiViewNode();
        if (key != null) {
            this.mCanvas.getNodeFactory().create(vi);
            this.mNodeToView.put(key, vi);
        }
        for (CanvasViewInfo child : vi.getChildren()) {
            this.updateNodeProxies(child);
        }
    }

    private void addInvisibleParents(CanvasViewInfo vi, Set<UiElementNode> invisibleNodes) {
        UiViewElementNode key;
        if (vi == null) {
            return;
        }
        if (vi.isInvisible()) {
            this.mInvisibleParents.add(vi);
        } else if (invisibleNodes != null && (key = vi.getUiViewNode()) != null && invisibleNodes.contains(key)) {
            vi.setExploded(true);
            this.mExplodedParents = true;
            this.mInvisibleParents.add(vi);
        }
        for (CanvasViewInfo child : vi.getChildren()) {
            this.addInvisibleParents(child, invisibleNodes);
        }
    }

    public RenderSession getSession() {
        return this.mSession;
    }

    public boolean isValid() {
        return this.mIsResultValid;
    }

    public boolean isEmpty() {
        return this.mLastValidViewInfoRoot == null;
    }

    public boolean hasInvisibleParents() {
        return this.mInvisibleParents.size() > 0;
    }

    public boolean hasExplodedParents() {
        return this.mExplodedParents;
    }

    public Collection<CanvasViewInfo> findWithin(LayoutPoint topLeft, LayoutPoint bottomRight) {
        Rectangle selectionRectangle = new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        ArrayList<CanvasViewInfo> infos = new ArrayList<CanvasViewInfo>();
        this.addWithin(this.mLastValidViewInfoRoot, selectionRectangle, infos);
        return infos;
    }

    private void addWithin(CanvasViewInfo canvasViewInfo, Rectangle canvasRectangle, List<CanvasViewInfo> infos) {
        if (canvasViewInfo == null) {
            return;
        }
        Rectangle r = canvasViewInfo.getSelectionRect();
        if (canvasRectangle.intersects(r)) {
            for (CanvasViewInfo child : canvasViewInfo.getChildren()) {
                this.addWithin(child, canvasRectangle, infos);
            }
            if (canvasViewInfo != this.mLastValidViewInfoRoot) {
                infos.add(canvasViewInfo);
            }
        }
    }

    @Nullable
    public CanvasViewInfo findViewInfoFor(@Nullable Node node) {
        CanvasViewInfo vi = this.mDomNodeToView.get(node);
        if (vi == null) {
            if (node == null) {
                return null;
            }
            if (node.getNodeType() == 3) {
                return this.mDomNodeToView.get(node.getParentNode());
            }
            if (node.getNodeType() == 2) {
                return this.mDomNodeToView.get(((Attr)node).getOwnerElement());
            }
            if (node.getNodeType() == 9) {
                return this.mDomNodeToView.get(((Document)node).getDocumentElement());
            }
        }
        return vi;
    }

    public CanvasViewInfo findViewInfoAt(LayoutPoint p) {
        if (this.mLastValidViewInfoRoot == null) {
            return null;
        }
        return this.findViewInfoAt_Recursive(p, this.mLastValidViewInfoRoot);
    }

    private CanvasViewInfo findViewInfoAt_Recursive(LayoutPoint p, CanvasViewInfo canvasViewInfo) {
        if (canvasViewInfo == null) {
            return null;
        }
        Rectangle r = canvasViewInfo.getSelectionRect();
        if (r.contains(p.x, p.y)) {
            List<CanvasViewInfo> children = canvasViewInfo.getChildren();
            assert (children instanceof RandomAccess);
            int i = children.size() - 1;
            while (i >= 0) {
                CanvasViewInfo child = children.get(i);
                CanvasViewInfo v = this.findViewInfoAt_Recursive(p, child);
                if (v != null) {
                    return v;
                }
                --i;
            }
            return canvasViewInfo;
        }
        return null;
    }

    List<CanvasViewInfo> findAltViewInfoAt(LayoutPoint p) {
        if (this.mLastValidViewInfoRoot != null) {
            return this.findAltViewInfoAt_Recursive(p, this.mLastValidViewInfoRoot, null);
        }
        return null;
    }

    private List<CanvasViewInfo> findAltViewInfoAt_Recursive(LayoutPoint p, CanvasViewInfo parent, List<CanvasViewInfo> outList) {
        Rectangle r;
        if (outList == null) {
            outList = new ArrayList<CanvasViewInfo>();
            if (parent != null && (r = parent.getSelectionRect()).contains(p.x, p.y)) {
                outList.add(parent);
            }
        }
        if (parent != null && !parent.getChildren().isEmpty()) {
            for (CanvasViewInfo child : parent.getChildren()) {
                r = child.getSelectionRect();
                if (!r.contains(p.x, p.y)) continue;
                outList.add(child);
            }
            for (CanvasViewInfo child : parent.getChildren()) {
                r = child.getSelectionRect();
                if (!r.contains(p.x, p.y)) continue;
                this.findAltViewInfoAt_Recursive(p, child, outList);
            }
        }
        return outList;
    }

    public CanvasViewInfo findViewInfoFor(INode node) {
        return this.findViewInfoFor((NodeProxy)node);
    }

    public CanvasViewInfo findViewInfoFor(UiElementNode viewKey) {
        return this.mNodeToView.get(viewKey);
    }

    @Nullable
    public CanvasViewInfo findViewInfoFor(@Nullable NodeProxy proxy) {
        if (proxy == null) {
            return null;
        }
        return this.mNodeToView.get(proxy.getNode());
    }

    public List<CanvasViewInfo> findAllViewInfos(boolean includeRoot) {
        ArrayList<CanvasViewInfo> infos = new ArrayList<CanvasViewInfo>();
        if (this.mIsResultValid && this.mLastValidViewInfoRoot != null) {
            this.findAllViewInfos(infos, this.mLastValidViewInfoRoot, includeRoot);
        }
        return infos;
    }

    private void findAllViewInfos(List<CanvasViewInfo> result, CanvasViewInfo canvasViewInfo, boolean includeRoot) {
        if (canvasViewInfo != null) {
            if (includeRoot || !canvasViewInfo.isRoot()) {
                result.add(canvasViewInfo);
            }
            for (CanvasViewInfo child : canvasViewInfo.getChildren()) {
                this.findAllViewInfos(result, child, true);
            }
        }
    }

    public CanvasViewInfo getRoot() {
        return this.mLastValidViewInfoRoot;
    }

    public List<CanvasViewInfo> getInvisibleViews() {
        return this.mInvisibleParentsReadOnly;
    }

    public Set<UiElementNode> getInvisibleNodes() {
        if (this.mInvisibleParents.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<UiElementNode> nodes = new HashSet<UiElementNode>(this.mInvisibleParents.size());
        for (CanvasViewInfo info : this.mInvisibleParents) {
            UiViewElementNode node = info.getUiViewNode();
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List<Rectangle> getIncludedBounds() {
        return this.mIncludedBounds;
    }

    @Nullable
    public Map<String, String> getDefaultProperties(@NonNull Object viewObject) {
        if (this.mSession != null) {
            return this.mSession.getDefaultProperties(viewObject);
        }
        return null;
    }

    public static void dump(RenderSession session, ViewInfo info, int depth) {
    }
}

