/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.io.IFolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import com.android.xml.AndroidManifest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.BinaryType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ManifestInfo {
    private static final int SEARCH_TIMEOUT_MS = 3000;
    private final IProject mProject;
    private String mPackage;
    private String mManifestTheme;
    private Map<String, ActivityAttributes> mActivityAttributes;
    private IAbstractFile mManifestFile;
    private long mLastModified;
    private long mLastChecked;
    private String mMinSdkName;
    private int mMinSdk;
    private int mTargetSdk;
    private String mApplicationIcon;
    private String mApplicationLabel;
    private boolean mApplicationSupportsRtl;
    static final QualifiedName MANIFEST_FINDER = new QualifiedName("com.android.ide.eclipse.adt", "manifest");

    private ManifestInfo(IProject project) {
        this.mProject = project;
    }

    public void clear() {
        this.mLastChecked = 0L;
    }

    @NonNull
    public static ManifestInfo get(IProject project) {
        ManifestInfo finder = null;
        try {
            finder = (ManifestInfo)project.getSessionProperty(MANIFEST_FINDER);
        }
        catch (CoreException coreException) {}
        if (finder == null) {
            finder = new ManifestInfo(project);
            try {
                project.setSessionProperty(MANIFEST_FINDER, (Object)finder);
            }
            catch (CoreException e) {
                AdtPlugin.log(e, "Can't store ManifestInfo", new Object[0]);
            }
        }
        return finder;
    }

    private void sync() {
        long fileModified;
        long now = System.currentTimeMillis();
        if (now - this.mLastChecked < 50L && this.mManifestFile != null) {
            return;
        }
        this.mLastChecked = now;
        if (this.mManifestFile == null) {
            IFolderWrapper projectFolder = new IFolderWrapper((IContainer)this.mProject);
            this.mManifestFile = AndroidManifest.getManifest((IAbstractFolder)projectFolder);
            if (this.mManifestFile == null) {
                return;
            }
        }
        if ((fileModified = this.mManifestFile.getModificationStamp()) == this.mLastModified) {
            return;
        }
        this.mLastModified = fileModified;
        this.mActivityAttributes = new HashMap<String, ActivityAttributes>();
        this.mManifestTheme = null;
        this.mTargetSdk = 1;
        this.mMinSdk = 1;
        this.mMinSdkName = "1";
        this.mPackage = "";
        this.mApplicationIcon = null;
        this.mApplicationLabel = null;
        this.mApplicationSupportsRtl = false;
        Document document = null;
        try {
            NodeList usesSdks;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            InputSource is = new InputSource(this.mManifestFile.getContents());
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
            Element root = document.getDocumentElement();
            this.mPackage = root.getAttribute("package");
            NodeList activities = document.getElementsByTagName("activity");
            int i = 0;
            int n = activities.getLength();
            while (i < n) {
                Element activity = (Element)activities.item(i);
                ActivityAttributes info = new ActivityAttributes(activity, this.mPackage);
                this.mActivityAttributes.put(info.getName(), info);
                ++i;
            }
            NodeList applications = root.getElementsByTagName("application");
            if (applications.getLength() > 0) {
                String defaultTheme;
                assert (applications.getLength() == 1);
                Element application = (Element)applications.item(0);
                if (application.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon")) {
                    this.mApplicationIcon = application.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
                }
                if (application.hasAttributeNS("http://schemas.android.com/apk/res/android", "label")) {
                    this.mApplicationLabel = application.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
                }
                if ("true".equals(application.getAttributeNS("http://schemas.android.com/apk/res/android", "supportsRtl"))) {
                    this.mApplicationSupportsRtl = true;
                }
                if ((defaultTheme = application.getAttributeNS("http://schemas.android.com/apk/res/android", "theme")) != null && !defaultTheme.isEmpty()) {
                    this.mManifestTheme = defaultTheme;
                }
            }
            if ((usesSdks = root.getElementsByTagName("uses-sdk")).getLength() > 0) {
                Element usesSdk = (Element)usesSdks.item(0);
                this.mMinSdk = this.getApiVersion(usesSdk, "minSdkVersion", 1);
                this.mTargetSdk = this.getApiVersion(usesSdk, "targetSdkVersion", this.mMinSdk);
            }
        }
        catch (SAXException e) {
            AdtPlugin.log(e, "Malformed manifest", new Object[0]);
        }
        catch (Exception e) {
            AdtPlugin.log(e, "Could not read Manifest data", new Object[0]);
        }
    }

    private int getApiVersion(Element usesSdk, String attribute, int defaultApiLevel) {
        String valueString = null;
        if (usesSdk.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute)) {
            valueString = usesSdk.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
            if (attribute.equals("minSdkVersion")) {
                this.mMinSdkName = valueString;
            }
        }
        if (valueString != null) {
            int apiLevel;
            block5: {
                apiLevel = -1;
                try {
                    apiLevel = Integer.valueOf(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    IAndroidTarget target;
                    if (Sdk.getCurrent() == null || (target = Sdk.getCurrent().getTargetFromHashString("android-" + valueString)) == null) break block5;
                    apiLevel = target.getVersion().getApiLevel() + 1;
                }
            }
            return apiLevel;
        }
        return defaultApiLevel;
    }

    @NonNull
    public String getPackage() {
        this.sync();
        return this.mPackage;
    }

    @NonNull
    public Map<String, ActivityAttributes> getActivityAttributesMap() {
        this.sync();
        return this.mActivityAttributes;
    }

    @Nullable
    public ActivityAttributes getActivityAttributes(String activity) {
        return this.getActivityAttributesMap().get(activity);
    }

    @Nullable
    public String getManifestTheme() {
        this.sync();
        return this.mManifestTheme;
    }

    @NonNull
    public String getDefaultTheme(IAndroidTarget renderingTarget, ScreenSize screenSize) {
        int apiLevel;
        this.sync();
        if (this.mManifestTheme != null) {
            return this.mManifestTheme;
        }
        int renderingTargetSdk = this.mTargetSdk;
        if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        if ((apiLevel = Math.min(this.mTargetSdk, renderingTargetSdk)) >= 11 && screenSize == ScreenSize.XLARGE || apiLevel >= 14) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    @Nullable
    public String getApplicationIcon() {
        this.sync();
        return this.mApplicationIcon;
    }

    @Nullable
    public String getApplicationLabel() {
        this.sync();
        return this.mApplicationLabel;
    }

    public boolean isRtlSupported() {
        this.sync();
        return this.mApplicationSupportsRtl;
    }

    public int getTargetSdkVersion() {
        this.sync();
        return this.mTargetSdk;
    }

    public int getMinSdkVersion() {
        this.sync();
        return this.mMinSdk;
    }

    @NonNull
    public String getMinSdkName() {
        this.sync();
        if (this.mMinSdkName == null || this.mMinSdkName.isEmpty()) {
            this.mMinSdkName = "1";
        }
        return this.mMinSdkName;
    }

    @Nullable
    public String getMinSdkCodeName() {
        String minSdkName = this.getMinSdkName();
        if (!Character.isDigit(minSdkName.charAt(0))) {
            return minSdkName;
        }
        return null;
    }

    @Nullable
    public IPackageFragment getPackageFragment() {
        this.sync();
        try {
            IPackageFragmentRoot root;
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(this.mProject);
            if (javaProject != null && (root = ManifestInfo.getSourcePackageRoot(javaProject)) != null) {
                return root.getPackageFragment(this.mPackage);
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    @Nullable
    public static String guessActivity(IProject project, String layoutName, String pkg) {
        List<String> activities = ManifestInfo.guessActivities(project, layoutName, pkg);
        if (activities.size() > 0) {
            return activities.get(0);
        }
        return null;
    }

    @NonNull
    public static List<String> guessActivities(IProject project, String layoutName, String pkg) {
        final LinkedList<String> activities = new LinkedList<String>();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    IType declaringType = method.getDeclaringType();
                    String fqcn = declaringType.getFullyQualifiedName();
                    if (declaringType.getSuperclassName() != null && declaringType.getSuperclassName().endsWith("Activity") || method.getElementName().equals("onCreate")) {
                        activities.addFirst(fqcn);
                    } else {
                        activities.addLast(fqcn);
                    }
                }
            }
        };
        try {
            IField field;
            IType type;
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
            if (javaProject == null) {
                return Collections.emptyList();
            }
            String typeFqcn = "R.layout";
            if (pkg != null) {
                typeFqcn = String.valueOf(pkg) + '.' + typeFqcn;
            }
            if ((type = javaProject.findType(typeFqcn)) != null && (field = type.getField(layoutName)).exists()) {
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)field, (int)2);
                try {
                    ManifestInfo.search(requestor, javaProject, pattern);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return activities;
    }

    @NonNull
    public static List<String> getProjectActivities(IProject project) {
        ArrayList<String> activities = new ArrayList<String>();
        try {
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
            if (javaProject != null) {
                IType[] activityTypes = new IType[]{};
                IType activityType = javaProject.findType("android.app.Activity");
                if (activityType != null) {
                    ITypeHierarchy hierarchy = activityType.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
                    IType[] iTypeArray = activityTypes = hierarchy.getAllSubtypes(activityType);
                    int n = activityTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        if (!(type instanceof BinaryType) || type.getClassFile() != null && type.getClassFile().getResource() != null) {
                            activities.add(type.getFullyQualifiedName());
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return activities;
    }

    @Nullable
    public String guessActivityBySetContentView(String layoutName) {
        return null;
    }

    private static void search(SearchRequestor requestor, IJavaProject javaProject, SearchPattern pattern) throws CoreException {
        IJavaSearchScope scope = ManifestInfo.createPackageScope(javaProject);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        SearchEngine engine = new SearchEngine();
        final long searchStart = System.currentTimeMillis();
        NullProgressMonitor monitor = new NullProgressMonitor(){
            private boolean mCancelled;

            public void internalWorked(double work) {
                long searchEnd = System.currentTimeMillis();
                if (searchEnd - searchStart > 3000L) {
                    this.mCancelled = true;
                }
            }

            public boolean isCanceled() {
                return this.mCancelled;
            }
        };
        engine.search(pattern, participants, scope, requestor, (IProgressMonitor)monitor);
    }

    private static IJavaSearchScope createPackageScope(IJavaProject javaProject) {
        IJavaSearchScope scope;
        IPackageFragmentRoot packageRoot = ManifestInfo.getSourcePackageRoot(javaProject);
        if (packageRoot != null) {
            IJavaElement[] scopeElements = new IJavaElement[]{packageRoot};
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])scopeElements);
        } else {
            scope = SearchEngine.createWorkspaceScope();
        }
        return scope;
    }

    @Nullable
    public static IPackageFragmentRoot getSourcePackageRoot(IJavaProject javaProject) {
        IPackageFragmentRoot packageRoot = null;
        List<IPath> sources = BaseProjectHelper.getSourceClasspaths(javaProject);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        for (IPath path : sources) {
            IResource firstSource = workspace.getRoot().findMember(path);
            if (firstSource != null && (packageRoot = javaProject.getPackageFragmentRoot(firstSource)) != null) break;
        }
        return packageRoot;
    }

    @NonNull
    public static Pair<Integer, Integer> computeSdkVersions(IProject project) {
        int mMinSdkVersion = 1;
        int mTargetSdkVersion = 1;
        IAbstractFile manifestFile = AndroidManifest.getManifest((IAbstractFolder)new IFolderWrapper((IContainer)project));
        if (manifestFile != null) {
            try {
                IAndroidTarget target;
                Object value = AndroidManifest.getMinSdkVersion((IAbstractFile)manifestFile);
                mMinSdkVersion = 1;
                if (value instanceof Integer) {
                    mMinSdkVersion = (Integer)value;
                } else if (value instanceof String && Sdk.getCurrent() != null && (target = Sdk.getCurrent().getTargetFromHashString("android-" + value)) != null) {
                    mMinSdkVersion = target.getVersion().getApiLevel() + 1;
                }
                value = AndroidManifest.getTargetSdkVersion((IAbstractFile)manifestFile);
                if (value == null) {
                    mTargetSdkVersion = mMinSdkVersion;
                } else if (value instanceof String && Sdk.getCurrent() != null && (target = Sdk.getCurrent().getTargetFromHashString("android-" + value)) != null) {
                    mTargetSdkVersion = target.getVersion().getApiLevel() + 1;
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
            }
            catch (StreamException streamException) {}
        }
        return Pair.of((Object)mMinSdkVersion, (Object)mTargetSdkVersion);
    }

    public static class ActivityAttributes {
        @Nullable
        private final String mIcon;
        @Nullable
        private final String mLabel;
        @NonNull
        private final String mName;
        @Nullable
        private final String mParentActivity;
        @Nullable
        private final String mTheme;
        @Nullable
        private final String mUiOptions;

        public ActivityAttributes(Element activity, String packageName) {
            String name = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (name == null || name.length() == 0) {
                throw new RuntimeException("Activity name cannot be empty");
            }
            int index = name.indexOf(46);
            if (index <= 0 && packageName != null && !packageName.isEmpty()) {
                name = String.valueOf(packageName) + (index == -1 ? "." : "") + name;
            }
            this.mName = name;
            String value = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
            this.mIcon = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
            this.mLabel = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "parentActivityName");
            if (value == null || value.length() == 0) {
                NodeList metaData = activity.getElementsByTagName("meta-data");
                int j = 0;
                int m = metaData.getLength();
                while (j < m) {
                    Element data = (Element)metaData.item(j);
                    String metadataName = data.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if ("android.support.PARENT_ACTIVITY".equals(metadataName) && (value = data.getAttributeNS("http://schemas.android.com/apk/res/android", "value")) != null && (index = value.indexOf(46)) <= 0 && packageName != null && !packageName.isEmpty()) {
                        value = String.valueOf(packageName) + (index == -1 ? "." : "") + value;
                        break;
                    }
                    ++j;
                }
            }
            this.mParentActivity = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
            this.mTheme = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "uiOptions");
            this.mUiOptions = value != null && value.length() > 0 ? value : null;
        }

        @Nullable
        public String getIcon() {
            return this.mIcon;
        }

        @Nullable
        public String getLabel() {
            return this.mLabel;
        }

        public String getName() {
            return this.mName;
        }

        @Nullable
        public String getParentActivity() {
            return this.mParentActivity;
        }

        @Nullable
        public String getTheme() {
            return this.mTheme;
        }

        @Nullable
        public String getUiOptions() {
            return this.mUiOptions;
        }
    }
}

