/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.model;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.xml.AndroidManifest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.w3c.dom.Element;

public class UiClassAttributeNode
extends UiTextAttributeNode {
    private String mReferenceClass;
    private IPostTypeCreationAction mPostCreationAction;
    private boolean mMandatory;
    private final boolean mDefaultToProjectOnly;

    public UiClassAttributeNode(String referenceClass, IPostTypeCreationAction postCreationAction, boolean mandatory, AttributeDescriptor attributeDescriptor, UiElementNode uiParent, boolean defaultToProjectOnly) {
        super(attributeDescriptor, uiParent);
        this.mReferenceClass = referenceClass;
        this.mPostCreationAction = postCreationAction;
        this.mMandatory = mandatory;
        this.mDefaultToProjectOnly = defaultToProjectOnly;
    }

    @Override
    public void createUiControl(Composite parent, IManagedForm managedForm) {
        this.setManagedForm(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        TextAttributeDescriptor desc = (TextAttributeDescriptor)this.getDescriptor();
        StringBuilder label = new StringBuilder();
        label.append("<form><p><a href='unused'>");
        label.append(desc.getUiName());
        label.append("</a></p></form>");
        FormText formText = SectionHelper.createFormText(parent, toolkit, true, label.toString(), true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                super.linkActivated(e);
                UiClassAttributeNode.this.handleLabelClick();
            }
        });
        formText.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)formText, desc.getTooltip());
        Composite composite = toolkit.createComposite(parent);
        composite.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        toolkit.paintBordersFor(composite);
        Text text = toolkit.createText(composite, this.getCurrentValue());
        GridData gd = new GridData(768);
        gd.horizontalIndent = 1;
        text.setLayoutData((Object)gd);
        Button browseButton = toolkit.createButton(composite, "Browse...", 8);
        this.setTextWidget(text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiClassAttributeNode.this.handleBrowseClick();
            }
        });
    }

    @Override
    protected void onAddValidators(final Text text) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    String textValue = text.getText().trim();
                    if (textValue.length() == 0) {
                        if (UiClassAttributeNode.this.mMandatory) {
                            UiClassAttributeNode.this.setErrorMessage("Value is mandatory", text);
                        } else {
                            UiClassAttributeNode.this.setErrorMessage(null, text);
                        }
                        return;
                    }
                    String javaPackage = UiClassAttributeNode.this.getManifestPackage();
                    String className = AndroidManifest.combinePackageAndClassName((String)javaPackage, (String)textValue);
                    boolean testVisibility = "android.app.Activity".equals(UiClassAttributeNode.this.mReferenceClass);
                    UiClassAttributeNode.this.setErrorMessage(BaseProjectHelper.testClassForManifest(BaseProjectHelper.getJavaProject(UiClassAttributeNode.this.getProject()), className, UiClassAttributeNode.this.mReferenceClass, testVisibility), text);
                }
                catch (CoreException ce) {
                    UiClassAttributeNode.this.setErrorMessage(ce.getMessage(), text);
                }
            }
        };
        text.addModifyListener(listener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UiClassAttributeNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        listener.modifyText(null);
    }

    private void handleBrowseClick() {
        Text text = this.getTextWidget();
        IProject project = this.getProject();
        if (project != null) {
            IPackageFragmentRoot[] packageFragmentRoots = this.getPackageFragmentRoots(project, true);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])packageFragmentRoots, (boolean)false);
            try {
                Object[] results;
                SelectionDialog dlg = JavaUI.createTypeDialog((Shell)text.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"**", (TypeSelectionExtension)new HierarchyTypeSelection(project, this.mReferenceClass));
                dlg.setMessage(String.format("Select class name for element %1$s:", this.getUiParent().getBreadcrumbTrailDescription(false)));
                if (dlg instanceof ITypeSelectionComponent) {
                    ((ITypeSelectionComponent)dlg).triggerSearch();
                }
                if (dlg.open() == 0 && (results = dlg.getResult()).length == 1) {
                    this.handleNewType((IType)results[0]);
                }
            }
            catch (JavaModelException e1) {
                AdtPlugin.log(e1, "UiClassAttributeNode HandleBrowser failed", new Object[0]);
            }
        }
    }

    private void handleLabelClick() {
        String className = this.getTextWidget().getText().trim();
        String packageName = this.getManifestPackage();
        if (className.length() == 0) {
            this.createNewClass(packageName, null);
        } else {
            String fullClassName = className;
            if (className.startsWith(".")) {
                fullClassName = String.valueOf(packageName) + className;
            } else {
                String[] segments = className.split("\\.");
                if (segments.length == 1) {
                    fullClassName = String.valueOf(packageName) + "." + className;
                }
            }
            fullClassName = fullClassName.replaceAll("\\$", "\\.");
            IProject project = this.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IType result = javaProject.findType(fullClassName);
                if (result != null) {
                    JavaUI.openInEditor((IJavaElement)result);
                } else {
                    int index = fullClassName.lastIndexOf(46);
                    if (index != -1) {
                        this.createNewClass(fullClassName.substring(0, index), fullClassName.substring(index + 1));
                    } else {
                        this.createNewClass(packageName, className);
                    }
                }
            }
            catch (JavaModelException e) {
                AdtPlugin.log(e, "UiClassAttributeNode HandleLabel failed", new Object[0]);
            }
            catch (PartInitException e) {
                AdtPlugin.log(e, "UiClassAttributeNode HandleLabel failed", new Object[0]);
            }
        }
    }

    private IProject getProject() {
        UiElementNode uiNode = this.getUiParent();
        AndroidXmlEditor editor = uiNode.getEditor();
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            return file.getProject();
        }
        return null;
    }

    private String getManifestPackage() {
        UiElementNode rootNode = this.getUiParent().getUiRoot();
        Element xmlElement = (Element)rootNode.getXmlNode();
        if (xmlElement != null) {
            return xmlElement.getAttribute("package");
        }
        return "";
    }

    private IPackageFragmentRoot[] getPackageFragmentRoots(IProject project, boolean include_containers) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IClasspathEntry entry = roots[i].getRawClasspathEntry();
                if (entry.getEntryKind() == 3 || include_containers && entry.getEntryKind() == 5) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private void handleNewType(IType type) {
        Text text = this.getTextWidget();
        String name = type.getFullyQualifiedName('$');
        String packageValue = this.getManifestPackage();
        if (packageValue.length() > 0 && name.startsWith(packageValue)) {
            String[] packages = (name = name.substring(packageValue.length() + 1)).split("\\.");
            if (packages.length == 1) {
                text.setText(name);
            } else {
                text.setText("." + name);
            }
        } else {
            text.setText(name);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createNewClass(String packageName, String className) {
        block25: {
            page = new NewClassWizardPage();
            page.setSuperClass(this.mReferenceClass, true);
            roots = this.getPackageFragmentRoots(this.getProject(), true);
            currentRoot = null;
            currentFragment = null;
            packageMatchCount = -1;
            var11_8 = roots;
            var10_13 = roots.length;
            var9_15 = 0;
            while (var9_15 < var10_13) {
                root = var11_8[var9_15];
                fragment = root.getPackageFragment(packageName);
                if (fragment != null && fragment.exists()) {
                    currentRoot = root;
                    currentFragment = fragment;
                    packageMatchCount = -1;
                    break;
                }
                try {
                    var17_24 = children = root.getChildren();
                    var16_23 = children.length;
                    var15_22 = 0;
                    while (var15_22 < var16_23) {
                        child = var17_24[var15_22];
                        if (child instanceof IPackageFragment && packageName.startsWith((fragment = (IPackageFragment)child).getElementName()) && (segments = fragment.getElementName().split("\\.")).length > packageMatchCount) {
                            packageMatchCount = segments.length;
                            currentFragment = fragment;
                            currentRoot = root;
                        }
                        ++var15_22;
                    }
                }
                catch (JavaModelException v0) {}
                ++var9_15;
            }
            createdFragments = null;
            if (currentRoot == null) ** GOTO lbl74
            if (packageMatchCount == -1) {
                page.setPackageFragmentRoot(currentRoot, true);
                page.setPackageFragment(currentFragment, true);
            } else {
                try {
                    createdFragments = new ArrayList<IPackageFragment>();
                    totalCount = packageName.split("\\.").length;
                    count = 0;
                    index = -1;
                    while (count < packageMatchCount) {
                        index = packageName.indexOf(46, index + 1);
                        ++count;
                    }
                    while (count < totalCount - 1) {
                        index = packageName.indexOf(46, index + 1);
                        ++count;
                        createdFragments.add(currentRoot.createPackageFragment(packageName.substring(0, index), true, (IProgressMonitor)new NullProgressMonitor()));
                    }
                    createdFragments.add(currentRoot.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor()));
                    page.setPackageFragmentRoot(currentRoot, true);
                    page.setPackageFragment((IPackageFragment)createdFragments.get(createdFragments.size() - 1), true);
                    break block25;
                }
                catch (JavaModelException v1) {
                    var12_19 = roots;
                    index = roots.length;
                    count = 0;
                    ** while (count < index)
                }
lbl-1000:
                // 1 sources

                {
                    root = var12_19[count];
                    fragment = root.getPackageFragment(packageName);
                    if (fragment != null && fragment.exists()) {
                        page.setPackageFragmentRoot(root, true);
                        page.setPackageFragment(fragment, true);
                    } else {
                        ++count;
                        continue;
                    }
lbl73:
                    // 1 sources

                    break block25;
                }
lbl74:
                // 1 sources

                if (roots.length > 0) {
                    page.setPackageFragmentRoot(roots[0], true);
                }
            }
        }
        if (className != null) {
            page.setTypeName(className, true);
        }
        action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        element = action.getCreatedElement();
        if (element != null) {
            if (element.getElementType() == 7) {
                type = (IType)element;
                if (this.mPostCreationAction != null) {
                    this.mPostCreationAction.processNewType(type);
                }
                this.handleNewType(type);
            }
        } else if (createdFragments != null) {
            try {
                i = createdFragments.size() - 1;
                while (i >= 0) {
                    ((IPackageFragment)createdFragments.get(i)).delete(true, (IProgressMonitor)new NullProgressMonitor());
                    --i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private final void setErrorMessage(String message, Text textWidget) {
        if (message != null) {
            this.setHasError(true);
            this.getManagedForm().getMessageManager().addMessage((Object)textWidget, message, null, 3, (Control)textWidget);
        } else {
            this.setHasError(false);
            this.getManagedForm().getMessageManager().removeMessage((Object)textWidget, (Control)textWidget);
        }
    }

    @Override
    public String[] getPossibleValues(String prefix) {
        IProject project = this.getProject();
        if (project == null || this.mReferenceClass == null) {
            return null;
        }
        try {
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
            IType type = javaProject.findType(this.mReferenceClass);
            HashSet<String> libraryTypes = new HashSet<String>(80);
            HashSet<String> localTypes = new HashSet<String>(30);
            if (type != null) {
                IType[] allSubtypes;
                ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] iTypeArray = allSubtypes = hierarchy.getAllSubtypes(type);
                int n = allSubtypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType subType = iTypeArray[n2];
                    int flags = subType.getFlags();
                    if (Flags.isPublic((int)flags) && !Flags.isAbstract((int)flags)) {
                        String fqcn = subType.getFullyQualifiedName();
                        if (subType.getResource() != null) {
                            localTypes.add(fqcn);
                        } else {
                            libraryTypes.add(fqcn);
                        }
                    }
                    ++n2;
                }
            }
            ArrayList local = new ArrayList(localTypes);
            ArrayList library = new ArrayList(libraryTypes);
            Collections.sort(local);
            Collections.sort(library);
            ArrayList combined = new ArrayList(local.size() + library.size());
            combined.addAll(local);
            combined.addAll(library);
            return combined.toArray(new String[combined.size()]);
        }
        catch (Exception e) {
            AdtPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    private class HierarchyTypeSelection
    extends TypeSelectionExtension {
        private IJavaProject mJavaProject;
        private IType mReferenceType;
        private Button mProjectOnly;
        private boolean mUseProjectOnly;

        public HierarchyTypeSelection(IProject project, String referenceClass) throws JavaModelException {
            this.mJavaProject = JavaCore.create((IProject)project);
            this.mReferenceType = this.mJavaProject.findType(referenceClass);
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return new ITypeInfoFilterExtension(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                    boolean projectOnly = HierarchyTypeSelection.this.mUseProjectOnly;
                    String packageName = typeInfoRequestor.getPackageName();
                    String typeName = typeInfoRequestor.getTypeName();
                    String enclosingType = typeInfoRequestor.getEnclosingName();
                    StringBuilder sb = new StringBuilder(packageName);
                    sb.append('.');
                    if (enclosingType.length() > 0) {
                        sb.append(enclosingType);
                        sb.append('.');
                    }
                    sb.append(typeName);
                    String className = sb.toString();
                    try {
                        IType type = HierarchyTypeSelection.this.mJavaProject.findType(className);
                        if (type == null) {
                            return false;
                        }
                        if ((type.getFlags() & 0x400) != 0) {
                            return false;
                        }
                        if (projectOnly) {
                            IPackageFragment frag = type.getPackageFragment();
                            if (frag == null) return false;
                            if (frag.getKind() != 1) {
                                return false;
                            }
                        }
                        ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        IType[] supertypes = hierarchy.getAllSupertypes(type);
                        int n = supertypes.length;
                        int i = 0;
                        while (true) {
                            if (i >= n) {
                                return false;
                            }
                            IType st = supertypes[i];
                            if (HierarchyTypeSelection.this.mReferenceType.equals(st)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            };
        }

        public Control createContentArea(Composite parent) {
            this.mProjectOnly = new Button(parent, 32);
            this.mProjectOnly.setLayoutData((Object)new GridData(768));
            this.mProjectOnly.setText(String.format("Display classes from sources of project '%s' only", this.mJavaProject.getProject().getName()));
            this.mUseProjectOnly = UiClassAttributeNode.this.mDefaultToProjectOnly;
            this.mProjectOnly.setSelection(this.mUseProjectOnly);
            this.mProjectOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HierarchyTypeSelection.this.mUseProjectOnly = HierarchyTypeSelection.this.mProjectOnly.getSelection();
                    HierarchyTypeSelection.this.getTypeSelectionComponent().triggerSearch();
                }
            });
            return super.createContentArea(parent);
        }
    }

    public static interface IPostTypeCreationAction {
        public void processNewType(IType var1);
    }
}

