/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.common.xml.XmlAttributeSortOrder;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.w3c.dom.Node;

public abstract class UiAttributeNode
implements Comparable<UiAttributeNode> {
    private AttributeDescriptor mDescriptor;
    private UiElementNode mUiParent;
    private boolean mIsDirty;
    private boolean mHasError;

    public UiAttributeNode(AttributeDescriptor attributeDescriptor, UiElementNode uiParent) {
        this.mDescriptor = attributeDescriptor;
        this.mUiParent = uiParent;
    }

    public final AttributeDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public final UiElementNode getUiParent() {
        return this.mUiParent;
    }

    public abstract String getCurrentValue();

    public final boolean isDirty() {
        return this.mIsDirty;
    }

    public void setDirty(boolean isDirty) {
        AndroidXmlEditor editor;
        boolean wasDirty = this.mIsDirty;
        this.mIsDirty = isDirty;
        if (wasDirty != isDirty && (editor = this.getUiParent().getEditor()) != null) {
            editor.editorDirtyStateChanged();
        }
    }

    public final void setHasError(boolean errorFlag) {
        this.mHasError = errorFlag;
    }

    public final boolean hasError() {
        return this.mHasError;
    }

    public abstract void createUiControl(Composite var1, IManagedForm var2);

    public abstract String[] getPossibleValues(String var1);

    public abstract void updateValue(Node var1);

    public abstract void commit();

    @Override
    public int compareTo(UiAttributeNode o) {
        return XmlAttributeSortOrder.compareAttributes((String)this.mDescriptor.getXmlLocalName(), (String)o.mDescriptor.getXmlLocalName());
    }
}

