/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.values;

import com.android.ide.eclipse.adt.internal.editors.AndroidContentAssist;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiResourceAttributeNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValuesContentAssist
extends AndroidContentAssist {
    public ValuesContentAssist() {
        super(5);
    }

    @Override
    protected boolean computeAttributeValues(List<ICompletionProposal> proposals, int offset, String parentTagName, String attributeName, Node node, String wordPrefix, boolean skipEndTag, int replaceLength) {
        super.computeAttributeValues(proposals, offset, parentTagName, attributeName, node, wordPrefix, skipEndTag, replaceLength);
        if (parentTagName.equals("item") && "name".equals(attributeName)) {
            IDescriptorProvider descriptorProvider;
            AndroidTargetData data;
            String attributePrefix;
            if (ValuesContentAssist.startsWith("android:", wordPrefix)) {
                proposals.add((ICompletionProposal)new CompletionProposal("android:", offset - wordPrefix.length(), wordPrefix.length() + replaceLength, "android:".length(), IconFactory.getInstance().getIcon("attribute"), null, null, null));
            }
            if (ValuesContentAssist.startsWith(attributePrefix = wordPrefix, "android:")) {
                attributePrefix = attributePrefix.substring("android:".length());
            }
            if ((data = this.mEditor.getTargetData()) != null && (descriptorProvider = data.getDescriptorProvider(2)) != null) {
                ElementDescriptor[] rootElementDescriptors = descriptorProvider.getRootElementDescriptors();
                HashMap<String, AttributeDescriptor> matches = new HashMap<String, AttributeDescriptor>(180);
                ElementDescriptor[] elementDescriptorArray = rootElementDescriptors;
                int n = rootElementDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementDescriptor elementDesc = elementDescriptorArray[n2];
                    AttributeDescriptor[] attributeDescriptorArray = elementDesc.getAttributes();
                    int n3 = attributeDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name;
                        AttributeDescriptor desc = attributeDescriptorArray[n4];
                        if (!(desc instanceof SeparatorAttributeDescriptor) && ValuesContentAssist.startsWith(name = desc.getXmlLocalName(), attributePrefix)) {
                            matches.put(name, desc);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                ArrayList sorted = new ArrayList(matches.size());
                sorted.addAll(matches.values());
                Collections.sort(sorted);
                char needTag = '\u0000';
                this.addMatchingProposals(proposals, sorted.toArray(), offset, node, wordPrefix, needTag, true, false, skipEndTag, replaceLength);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void computeTextValues(List<ICompletionProposal> proposals, int offset, Node parentNode, Node currentNode, UiElementNode uiParent, String prefix) {
        IDescriptorProvider descriptorProvider;
        AndroidTargetData data;
        super.computeTextValues(proposals, offset, parentNode, currentNode, uiParent, prefix);
        if (parentNode.getNodeName().equals("item") && parentNode.getParentNode() != null && "style".equals(parentNode.getParentNode().getNodeName()) && (data = this.mEditor.getTargetData()) != null && (descriptorProvider = data.getDescriptorProvider(2)) != null) {
            ElementDescriptor[] rootElementDescriptors;
            Element element = (Element)parentNode;
            String attrName = element.getAttribute("name");
            int pos = attrName.indexOf(58);
            if (pos >= 0) {
                attrName = attrName.substring(pos + 1);
            }
            ElementDescriptor[] elementDescriptorArray = rootElementDescriptors = descriptorProvider.getRootElementDescriptors();
            int n = rootElementDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor elementDesc = elementDescriptorArray[n2];
                AttributeDescriptor[] attributeDescriptorArray = elementDesc.getAttributes();
                int n3 = attributeDescriptorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    AttributeDescriptor desc = attributeDescriptorArray[n4];
                    if (desc.getXmlLocalName().equals(attrName)) {
                        if (uiParent == null) {
                            DocumentDescriptor documentDescriptor = data.getLayoutDescriptors().getDescriptor();
                            uiParent = documentDescriptor.createUiNode();
                            uiParent.setEditor(this.mEditor);
                        }
                        UiAttributeNode currAttrNode = desc.createUiNode(uiParent);
                        AndroidContentAssist.AttribInfo attrInfo = new AndroidContentAssist.AttribInfo();
                        Object[] values = this.getAttributeValueChoices(currAttrNode, attrInfo, prefix);
                        char needTag = attrInfo.needTag;
                        if (attrInfo.correctedPrefix != null) {
                            prefix = attrInfo.correctedPrefix;
                        }
                        boolean isAttribute = true;
                        boolean isNew = false;
                        int replaceLength = this.computeTextReplaceLength(currentNode, offset);
                        this.addMatchingProposals(proposals, values, offset, currentNode, prefix, needTag, isAttribute, isNew, false, replaceLength);
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (parentNode.getNodeName().equals("item") && (prefix.startsWith("@") || prefix.trim().length() == 0)) {
            Object[] choices = UiResourceAttributeNode.computeResourceStringMatches(this.mEditor, null, prefix);
            if (choices == null || choices.length == 0) {
                return;
            }
            Node typeNode = parentNode.getAttributes().getNamedItem("type");
            if (typeNode != null) {
                String value = typeNode.getNodeValue();
                ArrayList<Object> filtered = new ArrayList<Object>();
                Object[] objectArray = choices;
                int n = choices.length;
                int n5 = 0;
                while (n5 < n) {
                    Object s = objectArray[n5];
                    if (((String)s).startsWith("@android:") || ((String)s).startsWith("@" + value)) {
                        filtered.add(s);
                    }
                    ++n5;
                }
                if (filtered.size() > 0) {
                    choices = filtered.toArray(new String[filtered.size()]);
                }
            }
            int replaceLength = this.computeTextReplaceLength(currentNode, offset);
            this.addMatchingProposals(proposals, choices, offset, currentNode, prefix, '\u0000', true, false, false, replaceLength);
        }
    }
}

