/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.values.uimodel;

import com.android.ide.eclipse.adt.internal.editors.descriptors.TextValueDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextValueNode;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class UiColorValueNode
extends UiTextValueNode {
    private static final Pattern RGBA_REGEXP = Pattern.compile("#(?:[0-9a-fA-F]{3,4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})");

    public UiColorValueNode(TextValueDescriptor attributeDescriptor, UiElementNode uiParent) {
        super(attributeDescriptor, uiParent);
    }

    @Override
    protected void onAddValidators(final Text text) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String color = text.getText();
                if (RGBA_REGEXP.matcher(color).matches()) {
                    UiColorValueNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
                } else {
                    UiColorValueNode.this.getManagedForm().getMessageManager().addMessage((Object)text, "Accepted color formats are one of #RGB, #ARGB, #RRGGBB or #AARRGGBB.", null, 3, (Control)text);
                }
            }
        };
        text.addModifyListener(listener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UiColorValueNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        listener.modifyText(null);
    }
}

