/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.internal.launch.LaunchMessages;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;

class InstrumentationRunnerValidator {
    private final IJavaProject mJavaProject;
    private String[] mInstrumentationNames = null;
    private boolean mHasRunnerLibrary = false;
    static final String INSTRUMENTATION_OK = null;

    InstrumentationRunnerValidator(IJavaProject javaProject) {
        this.mJavaProject = javaProject;
        ManifestData manifestData = AndroidManifestHelper.parseForData(javaProject.getProject());
        this.init(manifestData);
    }

    InstrumentationRunnerValidator(IProject project) throws CoreException {
        this(BaseProjectHelper.getJavaProject(project));
    }

    InstrumentationRunnerValidator(IJavaProject javaProject, ManifestData manifestData) {
        this.mJavaProject = javaProject;
        this.init(manifestData);
    }

    private void init(ManifestData manifestData) {
        if (manifestData == null) {
            this.mInstrumentationNames = new String[0];
            this.mHasRunnerLibrary = false;
            return;
        }
        ManifestData.Instrumentation[] instrumentations = manifestData.getInstrumentations();
        this.mInstrumentationNames = new String[instrumentations.length];
        int i = 0;
        while (i < instrumentations.length) {
            this.mInstrumentationNames[i] = instrumentations[i].getName();
            ++i;
        }
        this.mHasRunnerLibrary = this.hasTestRunnerLibrary(manifestData);
    }

    private boolean hasTestRunnerLibrary(ManifestData manifestData) {
        ManifestData.UsesLibrary[] usesLibraryArray = manifestData.getUsesLibraries();
        int n = usesLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestData.UsesLibrary lib = usesLibraryArray[n2];
            if ("android.test.runner".equals(lib.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NonNull
    String[] getInstrumentationNames() {
        return this.mInstrumentationNames;
    }

    @Nullable
    String getValidInstrumentationTestRunner() {
        String[] stringArray = this.getInstrumentationNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String instrumentation = stringArray[n2];
            if (this.validateInstrumentationRunner(instrumentation) == INSTRUMENTATION_OK) {
                return instrumentation;
            }
            ++n2;
        }
        return null;
    }

    String validateInstrumentationRunner(String instrumentation) {
        String result;
        if (!this.mHasRunnerLibrary) {
            return String.format(LaunchMessages.InstrValidator_NoTestLibMsg_s, "android.test.runner");
        }
        if (!instrumentation.equals("android.test.InstrumentationTestRunner") && (result = BaseProjectHelper.testClassForManifest(this.mJavaProject, instrumentation, "android.app.Instrumentation", true)) != BaseProjectHelper.TEST_CLASS_OK) {
            return String.format(LaunchMessages.InstrValidator_WrongRunnerTypeMsg_s, "android.app.Instrumentation");
        }
        return INSTRUMENTATION_OK;
    }
}

