/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit.runtime;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.TestCaseReference;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.TestSuiteReference;
import java.util.Map;

class TestCollector
implements ITestRunListener {
    private final String mDeviceName;
    private final TestSuiteReference mDeviceSuiteRef;
    private int mTotalTestCount;
    private String mErrorMessage = null;

    TestCollector(String deviceName) {
        this.mDeviceName = deviceName;
        this.mDeviceSuiteRef = new TestSuiteReference(deviceName);
        this.mTotalTestCount = 0;
    }

    public synchronized void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
    }

    public synchronized void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
    }

    public synchronized void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
    }

    public synchronized void testRunFailed(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public synchronized void testRunStarted(String ignoredRunName, int testCount) {
        this.mTotalTestCount = testCount;
    }

    public synchronized void testRunStopped(long elapsedTime) {
    }

    public synchronized void testStarted(TestIdentifier test) {
        TestSuiteReference suiteRef = this.mDeviceSuiteRef.getTestSuite(test.getClassName());
        if (suiteRef == null) {
            suiteRef = new TestSuiteReference(test.getClassName());
            this.mDeviceSuiteRef.addTest(suiteRef);
        }
        suiteRef.addTest(new TestCaseReference(this.mDeviceName, test));
    }

    public synchronized int getTestCaseCount() {
        return this.mTotalTestCount;
    }

    public synchronized String getErrorMessage() {
        return this.mErrorMessage;
    }

    public TestSuiteReference getDeviceSuite() {
        return this.mDeviceSuiteRef;
    }
}

