/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit.runtime;

import com.android.ide.eclipse.adt.internal.launch.junit.runtime.AndroidTestReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;

class TestSuiteReference
extends AndroidTestReference {
    private final String mClassName;
    private List<AndroidTestReference> mTests;

    TestSuiteReference(String className) {
        this.mClassName = className;
        this.mTests = new ArrayList<AndroidTestReference>();
    }

    public int countTestCases() {
        return this.mTests.size();
    }

    public void sendTree(IVisitsTestTrees notified) {
        notified.visitTreeEntry(this.getIdentifier(), true, this.countTestCases());
        for (AndroidTestReference ref : this.mTests) {
            ref.sendTree(notified);
        }
    }

    public String getName() {
        return this.mClassName;
    }

    void addTest(AndroidTestReference testRef) {
        this.mTests.add(testRef);
    }

    public TestSuiteReference getTestSuite(String name) {
        for (AndroidTestReference ref : this.mTests) {
            if (!(ref instanceof TestSuiteReference) || !ref.getName().equals(name)) continue;
            return (TestSuiteReference)ref;
        }
        return null;
    }
}

