/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.lint.DocumentFix;
import com.android.utils.XmlUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class SetPropertyFix
extends DocumentFix {
    private Region mSelect;

    protected SetPropertyFix(String id, IMarker marker) {
        super(id, marker);
    }

    protected abstract String getAttribute();

    protected abstract boolean isAndroidAttribute();

    protected String getProposal(Element element) {
        return this.invokeCodeCompletion() ? "" : "TODO";
    }

    protected boolean invokeCodeCompletion() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        this.mSelect = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            String proposal = this.getProposal(element);
            String localAttribute = this.getAttribute();
            String prefix = null;
            if (this.isAndroidAttribute()) {
                prefix = XmlUtils.lookupNamespacePrefix((Node)node, (String)"http://schemas.android.com/apk/res/android");
            }
            String attribute = prefix != null ? String.valueOf(prefix) + ':' + localAttribute : localAttribute;
            element.setAttribute(attribute, proposal);
            Attr attr = null;
            attr = this.isAndroidAttribute() ? element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", localAttribute) : element.getAttributeNode(localAttribute);
            if (attr instanceof IndexedRegion) {
                IndexedRegion region = (IndexedRegion)attr;
                int offset = region.getStartOffset();
                offset += attribute.length() + 2;
                if (this.selectValue()) {
                    this.mSelect = new Region(offset, proposal.length());
                }
            }
        }
    }

    protected boolean selectValue() {
        return true;
    }

    @Override
    public void apply(IDocument document) {
        IEditorPart editor;
        try {
            IFile file = (IFile)this.mMarker.getResource();
            super.apply(document);
            AdtPlugin.openFile(file, (IRegion)this.mSelect, true);
        }
        catch (PartInitException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        if (this.invokeCodeCompletion() && (editor = AdtUtils.getActiveEditor()) instanceof AndroidXmlEditor) {
            ((AndroidXmlEditor)editor).invokeContentAssist(-1);
        }
    }

    @Override
    public boolean needsFocus() {
        return true;
    }

    @Override
    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_OBJ_ADD");
    }
}

