/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class FixLaunchConfig
extends Thread {
    private IProject mProject;
    private String mOldPackage;
    private String mNewPackage;
    private boolean mDisplayPrompt = true;

    public FixLaunchConfig(IProject project, String oldPackage, String newPackage) {
        this.mProject = project;
        this.mOldPackage = oldPackage;
        this.mNewPackage = newPackage;
    }

    public void setDisplayPrompt(boolean displayPrompt) {
        this.mDisplayPrompt = displayPrompt;
    }

    @Override
    public void run() {
        ILaunchConfiguration[] configs;
        boolean res;
        if (this.mDisplayPrompt && !(res = AdtPlugin.displayPrompt("Launch Configuration Update", "The package definition in the manifest changed.\nDo you want to update your Launch Configuration(s)?"))) {
            return;
        }
        String projectName = this.mProject.getName();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = FixLaunchConfig.findConfigs(this.mProject.getName());
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            try {
                ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
                String activity = config.getAttribute("com.android.ide.eclipse.adt.activity", "");
                if (activity.startsWith(this.mOldPackage)) {
                    activity = String.valueOf(this.mNewPackage) + activity.substring(this.mOldPackage.length());
                    copy.setAttribute("com.android.ide.eclipse.adt.activity", activity);
                    copy.doSave();
                }
            }
            catch (CoreException e) {
                String msg = String.format("Failed to modify %1$s: %2$s", projectName, e.getMessage());
                AdtPlugin.printErrorToConsole(this.mProject, new Object[]{msg});
            }
            ++n2;
        }
    }

    private static ILaunchConfiguration[] findConfigs(String projectName) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = manager.getLaunchConfigurationType("com.android.ide.eclipse.adt.debug.LaunchConfigType");
        ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    list.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }
}

