/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProjectChooserHelper {
    private final Shell mParentShell;
    private final IProjectChooserFilter mFilter;
    private IJavaProject[] mAndroidProjects;

    public ProjectChooserHelper(Shell parentShell, IProjectChooserFilter filter) {
        this.mParentShell = parentShell;
        this.mFilter = filter;
    }

    public IJavaProject chooseJavaProject(String projectName, String message) {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.mParentShell, (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        if (message == null) {
            message = "Please select a project";
        }
        dialog.setMessage(message);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        dialog.setElements((Object[])this.getAndroidProjects(javaModel));
        IJavaProject javaProject = null;
        if (projectName != null && projectName.length() > 0) {
            javaProject = javaModel.getJavaProject(projectName);
        }
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    public IJavaProject[] getAndroidProjects(IJavaModel javaModel) {
        if (this.mAndroidProjects == null || this.mFilter != null && !this.mFilter.useCache()) {
            this.mAndroidProjects = javaModel == null ? BaseProjectHelper.getAndroidProjects(this.mFilter) : BaseProjectHelper.getAndroidProjects(javaModel, this.mFilter);
        }
        return this.mAndroidProjects;
    }

    public IProject getAndroidProject(String projectName) {
        IProject iproject = null;
        IJavaProject[] javaProjects = this.getAndroidProjects(null);
        if (javaProjects != null) {
            IJavaProject[] iJavaProjectArray = javaProjects;
            int n = javaProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject javaProject = iJavaProjectArray[n2];
                if (javaProject.getElementName().equals(projectName)) {
                    iproject = javaProject.getProject();
                    break;
                }
                ++n2;
            }
        }
        return iproject;
    }

    public static interface IProjectChooserFilter
    extends BaseProjectHelper.IProjectFilter {
        public boolean useCache();
    }

    public static final class LibraryProjectOnlyFilter
    implements IProjectChooserFilter {
        @Override
        public boolean accept(IProject project) {
            ProjectState state = Sdk.getProjectState(project);
            if (state != null) {
                return state.isLibrary();
            }
            return false;
        }

        @Override
        public boolean useCache() {
            return true;
        }
    }

    public static final class NonLibraryProjectOnlyFilter
    implements IProjectChooserFilter {
        @Override
        public boolean accept(IProject project) {
            ProjectState state = Sdk.getProjectState(project);
            if (state != null) {
                return !state.isLibrary();
            }
            return false;
        }

        @Override
        public boolean useCache() {
            return true;
        }
    }

    public static class ProjectCombo
    extends Combo
    implements SelectionListener {
        private IProject mProject;
        private IJavaProject[] mAvailableProjects;

        public ProjectCombo(ProjectChooserHelper helper, Composite parent, IProject initialProject) {
            super(parent, 0x800808);
            this.mProject = initialProject;
            this.mAvailableProjects = helper.getAndroidProjects(null);
            String[] items = new String[this.mAvailableProjects.length + 1];
            items[0] = "--- Choose Project ---";
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            int selectionIndex = 0;
            int i = 0;
            int n = this.mAvailableProjects.length;
            while (i < n) {
                IProject project = this.mAvailableProjects[i].getProject();
                items[i + 1] = labelProvider.getText((Object)project);
                if (project == initialProject) {
                    selectionIndex = i + 1;
                }
                ++i;
            }
            this.setItems(items);
            this.select(selectionIndex);
            this.addSelectionListener(this);
        }

        public IProject getSelectedProject() {
            return this.mProject;
        }

        public void setSelectedProject(IProject project) {
            this.mProject = project;
            int selectionIndex = 0;
            int i = 0;
            int n = this.mAvailableProjects.length;
            while (i < n) {
                if (project == this.mAvailableProjects[i].getProject()) {
                    selectionIndex = i + 1;
                    this.select(selectionIndex);
                    break;
                }
                ++i;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = this.getSelectionIndex();
            this.mProject = selectionIndex > 0 && this.mAvailableProjects != null && selectionIndex <= this.mAvailableProjects.length ? this.mAvailableProjects[selectionIndex - 1].getProject() : null;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected void checkSubclass() {
        }
    }
}

