/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.actions.AddSupportJarAction;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class SupportLibraryHelper {
    private static IProject sCachedProject;

    @NonNull
    public static String getTagFor(@NonNull IProject project, @NonNull String tag) {
        int minSdk;
        boolean isGridLayout = tag.equals("android.widget.GridLayout");
        boolean isSpace = tag.equals("android.widget.Space");
        if ((isGridLayout || isSpace) && (minSdk = ManifestInfo.get(project).getMinSdkVersion()) < 14) {
            ProjectState state;
            IProject supportProject = SupportLibraryHelper.getSupportProjectV7();
            if (supportProject != null && (state = Sdk.getProjectState(project)) != null) {
                for (ProjectState.LibraryState library : state.getLibraries()) {
                    if (!supportProject.equals((Object)library.getProjectState().getProject())) continue;
                    return isGridLayout ? "android.support.v7.widget.GridLayout" : "android.support.v7.widget.Space";
                }
            }
            String message = String.format("%1$s requires API level 14 or higher, or a compatibility library for older versions.\n\n Do you want to install the compatibility library?", tag);
            MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Warning", null, message, 3, new String[]{"Install", "Cancel"}, 1);
            int answer = dialog.open();
            if (answer == 0) {
                if (supportProject != null ? !AddSupportJarAction.addLibraryDependency(supportProject, project, true) : !AddSupportJarAction.installGridLayoutLibrary(project, true)) {
                    return tag;
                }
                return isGridLayout ? "android.support.v7.widget.GridLayout" : "android.support.v7.widget.Space";
            }
        }
        return tag;
    }

    @Nullable
    public static IProject getSupportProjectV7() {
        if (sCachedProject != null) {
            if (sCachedProject.isAccessible()) {
                return sCachedProject;
            }
            sCachedProject = null;
        }
        sCachedProject = SupportLibraryHelper.findSupportProjectV7();
        return sCachedProject;
    }

    @Nullable
    private static IProject findSupportProjectV7() {
        IJavaProject[] iJavaProjectArray = AdtUtils.getOpenAndroidProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestInfo manifestInfo;
            IJavaProject javaProject = iJavaProjectArray[n2];
            IProject project = javaProject.getProject();
            ProjectState state = Sdk.getProjectState(project);
            if (state != null && state.isLibrary() && (manifestInfo = ManifestInfo.get(project)).getPackage().equals("android.support.v7.gridlayout")) {
                return project;
            }
            ++n2;
        }
        return null;
    }
}

