/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlErrorHandler
extends DefaultHandler
implements AndroidManifestParser.ManifestErrorHandler {
    private final IJavaProject mJavaProject;
    private final IFile mFile;
    private final XmlErrorListener mErrorListener;

    public XmlErrorHandler(IJavaProject javaProject, IFile file, XmlErrorListener errorListener) {
        this.mJavaProject = javaProject;
        this.mFile = file;
        this.mErrorListener = errorListener;
    }

    public XmlErrorHandler(IFile file, XmlErrorListener errorListener) {
        this(null, file, errorListener);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.handleError(exception, exception.getLineNumber());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.handleError(exception, exception.getLineNumber());
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.mFile != null) {
            BaseProjectHelper.markResource((IResource)this.mFile, "com.android.ide.eclipse.common.xmlProblem", exception.getMessage(), exception.getLineNumber(), 1);
        }
    }

    protected final IFile getFile() {
        return this.mFile;
    }

    public void handleError(Exception exception, int lineNumber) {
        String message;
        if (this.mErrorListener != null) {
            this.mErrorListener.errorFound();
        }
        if ((message = exception.getMessage()) == null) {
            message = "Unknown error " + exception.getClass().getCanonicalName();
        }
        if (this.mFile != null) {
            BaseProjectHelper.markResource((IResource)this.mFile, "com.android.ide.eclipse.common.xmlProblem", message, lineNumber, 2);
        }
    }

    public void checkClass(Locator locator, String className, String superClassName, boolean testVisibility) {
        if (this.mJavaProject == null) {
            return;
        }
        String result = BaseProjectHelper.testClassForManifest(this.mJavaProject, className, superClassName, testVisibility);
        if (result != BaseProjectHelper.TEST_CLASS_OK) {
            int line = locator.getLineNumber();
            IMarker marker = BaseProjectHelper.markResource((IResource)this.getFile(), "com.android.ide.eclipse.common.androidProblem", result, line, 2);
            if (marker != null) {
                try {
                    marker.setAttribute("android.type", (Object)"activity");
                    marker.setAttribute("android.class", (Object)className);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    public static class BasicXmlErrorListener
    implements XmlErrorListener {
        public boolean mHasXmlError = false;

        @Override
        public void errorFound() {
            this.mHasXmlError = true;
        }
    }

    public static interface XmlErrorListener {
        public void errorFound();
    }
}

