/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.resources.ResourceType;
import com.android.util.Pair;
import com.android.utils.SparseArray;
import java.util.HashMap;
import java.util.Map;

public class DynamicIdMap {
    private final Map<Pair<ResourceType, String>, Integer> mDynamicIds = new HashMap<Pair<ResourceType, String>, Integer>();
    private final SparseArray<Pair<ResourceType, String>> mRevDynamicIds = new SparseArray();
    private int mDynamicSeed;

    public DynamicIdMap(int seed) {
        this.mDynamicSeed = seed;
    }

    public void reset(int seed) {
        this.mDynamicIds.clear();
        this.mRevDynamicIds.clear();
        this.mDynamicSeed = seed;
    }

    public Integer getId(ResourceType type, String name) {
        return this.getId((Pair<ResourceType, String>)Pair.of((Object)type, (Object)name));
    }

    public Integer getId(Pair<ResourceType, String> resource) {
        Integer value = this.mDynamicIds.get(resource);
        if (value == null) {
            value = ++this.mDynamicSeed;
            this.mDynamicIds.put(resource, value);
            this.mRevDynamicIds.put(value.intValue(), resource);
        }
        return value;
    }

    public Pair<ResourceType, String> resolveId(int id) {
        return (Pair)this.mRevDynamicIds.get(id);
    }
}

