/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.PropertyFactory;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import com.android.ide.eclipse.adt.internal.ui.ResourceContentProvider;
import com.android.ide.eclipse.adt.internal.ui.ResourceLabelProvider;
import com.android.ide.eclipse.adt.internal.ui.ResourcePreviewHelper;
import com.android.resources.ResourceType;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ReferenceChooserDialog
extends SelectionStatusDialog {
    private static Pattern sResourcePattern = Pattern.compile("@(.*)/(.+)");
    private static Pattern sInlineIdResourcePattern = Pattern.compile("@\\+id/(.+)");
    private static IDialogSettings sDialogSettings = new DialogSettings("");
    private ResourceRepository mProjectResources;
    private String mCurrentResource;
    private FilteredTree mFilteredTree;
    private Button mNewResButton;
    private final IProject mProject;
    private TreeViewer mTreeViewer;
    private ResourcePreviewHelper mPreviewHelper;

    public ReferenceChooserDialog(IProject project, ResourceRepository projectResources, Shell parent) {
        super(parent);
        this.mProject = project;
        this.mProjectResources = projectResources;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.setTitle("Reference Chooser");
        this.setMessage(String.format("Choose a resource", new Object[0]));
        this.setDialogBoundsSettings(sDialogSettings, this.getDialogBoundsStrategy());
    }

    public void setPreviewHelper(ResourcePreviewHelper previewHelper) {
        this.mPreviewHelper = previewHelper;
    }

    public void setCurrentResource(String resource) {
        this.mCurrentResource = resource;
    }

    public String getCurrentResource() {
        return this.mCurrentResource;
    }

    protected void computeResult() {
        TreePath treeSelection = this.getSelection();
        if (treeSelection != null && treeSelection.getSegmentCount() == 2) {
            ResourceType resourceType = (ResourceType)treeSelection.getFirstSegment();
            ResourceItem resourceItem = (ResourceItem)treeSelection.getLastSegment();
            this.mCurrentResource = resourceItem.getXmlString(resourceType, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.createMessageArea(top);
        this.createFilteredTree(top);
        if (this.mCurrentResource != null) {
            this.setupInitialSelection();
        }
        this.createNewResButtons(top);
        Composite workaround = PropertyFactory.addWorkaround(top);
        if (workaround != null) {
            workaround.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        }
        return top;
    }

    private void createNewResButtons(Composite top) {
        this.mNewResButton = new Button(top, 0);
        this.mNewResButton.addSelectionListener((SelectionListener)new OnNewResButtonSelected());
        this.updateNewResButton();
    }

    private void createFilteredTree(Composite parent) {
        this.mFilteredTree = new FilteredTree(parent, 67588, new PatternFilter());
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.mFilteredTree.setLayoutData((Object)data);
        this.mFilteredTree.setFont(parent.getFont());
        this.mTreeViewer = this.mFilteredTree.getViewer();
        Tree tree = this.mTreeViewer.getTree();
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ReferenceChooserDialog.this.handleDoubleClick();
            }

            public void widgetSelected(SelectionEvent e) {
                ReferenceChooserDialog.this.handleSelection();
            }
        });
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.mTreeViewer.setContentProvider((IContentProvider)new ResourceContentProvider(false));
        this.mTreeViewer.setInput((Object)this.mProjectResources);
    }

    protected void handleSelection() {
        this.validateCurrentSelection();
        this.updateNewResButton();
        if (this.mPreviewHelper != null) {
            Object segment;
            TreePath treeSelection = this.getSelection();
            ResourceType type = null;
            if (treeSelection != null && treeSelection.getSegmentCount() == 2 && (segment = treeSelection.getSegment(0)) instanceof ResourceType) {
                type = (ResourceType)segment;
                this.computeResult();
            }
            this.mPreviewHelper.updatePreview(type, this.mCurrentResource);
        }
    }

    protected void handleDoubleClick() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    private TreePath getSelection() {
        TreeSelection treeSelection;
        TreePath[] treePaths;
        ISelection selection = this.mFilteredTree.getViewer().getSelection();
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()).length > 0) {
            return treePaths[0];
        }
        return null;
    }

    private boolean validateCurrentSelection() {
        TreePath treeSelection = this.getSelection();
        Status status = treeSelection != null ? (treeSelection.getSegmentCount() == 2 ? new Status(0, "com.android.ide.eclipse.adt", 0, "", null) : new Status(4, "com.android.ide.eclipse.adt", 4, "You must select a Resource Item", null)) : new Status(4, "com.android.ide.eclipse.adt", 4, "", null);
        this.updateStatus((IStatus)status);
        return status.isOK();
    }

    private void updateNewResButton() {
        ResourceType type = this.getSelectedResourceType();
        this.mNewResButton.setEnabled(type == ResourceType.STRING);
        String title = String.format("New %1$s...", type == null ? "Resource" : type.getDisplayName());
        this.mNewResButton.setText(title);
        this.mNewResButton.pack();
    }

    private ResourceType getSelectedResourceType() {
        Object first;
        ResourceType type = null;
        TreePath selection = this.getSelection();
        if (selection != null && selection.getSegmentCount() > 0 && (first = selection.getFirstSegment()) instanceof ResourceType) {
            type = (ResourceType)first;
        }
        return type;
    }

    private void setupInitialSelection() {
        Matcher m = sInlineIdResourcePattern.matcher(this.mCurrentResource);
        if (m.matches()) {
            String resourceName = m.group(1);
            this.setupInitialSelection(ResourceType.ID, resourceName);
        } else {
            ResourceType resourceType;
            m = sResourcePattern.matcher(this.mCurrentResource);
            if (m.matches() && (resourceType = ResourceType.getEnum((String)m.group(1))) != null) {
                String resourceName = m.group(2);
                this.setupInitialSelection(resourceType, resourceName);
            }
        }
    }

    private void setupInitialSelection(ResourceType resourceType, String resourceName) {
        Collection resourceItems = this.mProjectResources.getResourceItemsOfType(resourceType);
        for (ResourceItem resourceItem : resourceItems) {
            if (!resourceName.equals(resourceItem.getName())) continue;
            TreePath treePath = new TreePath(new Object[]{resourceType, resourceItem});
            this.mFilteredTree.getViewer().setSelection((ISelection)new TreeSelection(treePath), true);
            return;
        }
        TreePath treePath = new TreePath(new Object[]{resourceType});
        this.mFilteredTree.getViewer().setSelection((ISelection)new TreeSelection(treePath), true);
        this.mFilteredTree.getViewer().setExpandedState((Object)resourceType, true);
    }

    private class OnNewResButtonSelected
    extends SelectionAdapter {
        private OnNewResButtonSelected() {
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            ResourceType type = ReferenceChooserDialog.this.getSelectedResourceType();
            if (type == ResourceType.STRING) {
                ExtractStringRefactoring ref = new ExtractStringRefactoring(ReferenceChooserDialog.this.mProject, true);
                ExtractStringWizard wizard = new ExtractStringWizard(ref, ReferenceChooserDialog.this.mProject);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    IWorkbench w = PlatformUI.getWorkbench();
                    if (op.run(w.getDisplay().getActiveShell(), wizard.getDefaultPageTitle()) == 0) {
                        ReferenceChooserDialog.this.mTreeViewer.refresh();
                        ReferenceChooserDialog.this.setupInitialSelection(type, ref.getXmlStringId());
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

