/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Locale;

public class FingerprintUtils {
    public static String getFingerprint(Certificate cert, String hashAlgorithm) {
        if (cert == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            return FingerprintUtils.toHexadecimalString(digest.digest(cert.getEncoded()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {}
        return null;
    }

    private static String toHexadecimalString(byte[] value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length;
        int i = 0;
        while (i < len) {
            int num = value[i] & 0xFF;
            if (num < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(num));
            if (i < len - 1) {
                sb.append(':');
            }
            ++i;
        }
        return sb.toString().toUpperCase(Locale.US);
    }
}

