/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.actions;

import com.android.ide.eclipse.adt.internal.lint.EclipseLintRunner;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.export.ExportWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class ExportWizardAction
implements IObjectActionDelegate {
    private ISelection mSelection;
    private IWorkbench mWorkbench;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mWorkbench = targetPart.getSite().getWorkbenchWindow().getWorkbench();
    }

    public void run(IAction action) {
        IStructuredSelection selection;
        if (this.mSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)this.mSelection).size() == 1) {
            Object element = selection.getFirstElement();
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
            }
            if (project != null) {
                if (!EclipseLintRunner.runLintOnExport(this.mWorkbench.getActiveWorkbenchWindow().getShell(), project)) {
                    return;
                }
                ProjectState state = Sdk.getProjectState(project);
                if (state.isLibrary()) {
                    MessageDialog.openError((Shell)this.mWorkbench.getDisplay().getActiveShell(), (String)"Android Export", (String)"Android library projects cannot be exported.");
                } else {
                    ExportWizard wizard = new ExportWizard();
                    wizard.init(this.mWorkbench, selection);
                    WizardDialog dialog = new WizardDialog(this.mWorkbench.getDisplay().getActiveShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = selection;
    }
}

